/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.migration;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.migration.MigrateMongoMdstoresApplication;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Datasource;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Project;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Software;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.io.Text;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.SparkSession;
import scala.Tuple2;

public class ExtractEntitiesFromHDFSJob {
    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)MigrateMongoMdstoresApplication.class.getResourceAsStream("/eu/dnetlib/dhp/migration/extract_entities_from_hdfs_parameters.json")));
        parser.parseArgument(args);
        SparkSession spark = SparkSession.builder().appName(ExtractEntitiesFromHDFSJob.class.getSimpleName()).master(parser.get("master")).getOrCreate();
        List<String> sourcePaths = Arrays.asList(parser.get("sourcePaths").split(","));
        String targetPath = parser.get("graphRawPath");
        try (JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());){
            ExtractEntitiesFromHDFSJob.processEntity(sc, Publication.class, sourcePaths, targetPath);
            ExtractEntitiesFromHDFSJob.processEntity(sc, Dataset.class, sourcePaths, targetPath);
            ExtractEntitiesFromHDFSJob.processEntity(sc, Software.class, sourcePaths, targetPath);
            ExtractEntitiesFromHDFSJob.processEntity(sc, OtherResearchProduct.class, sourcePaths, targetPath);
            ExtractEntitiesFromHDFSJob.processEntity(sc, Datasource.class, sourcePaths, targetPath);
            ExtractEntitiesFromHDFSJob.processEntity(sc, Organization.class, sourcePaths, targetPath);
            ExtractEntitiesFromHDFSJob.processEntity(sc, Project.class, sourcePaths, targetPath);
            ExtractEntitiesFromHDFSJob.processEntity(sc, Relation.class, sourcePaths, targetPath);
        }
    }

    private static void processEntity(JavaSparkContext sc, Class<?> clazz, List<String> sourcePaths, String targetPath) {
        String type = clazz.getSimpleName().toLowerCase();
        JavaRDD inputRdd = sc.emptyRDD();
        sourcePaths.forEach(sourcePath -> inputRdd.union(sc.sequenceFile(sourcePath, Text.class, Text.class).map((Function & Serializable)k -> new Tuple2((Object)((Text)k._1()).toString(), (Object)((Text)k._2()).toString())).filter((Function & Serializable)k -> ExtractEntitiesFromHDFSJob.isEntityType((String)k._1(), type)).map(Tuple2::_2)));
        inputRdd.saveAsTextFile(targetPath + "/" + type);
    }

    private static boolean isEntityType(String item, String entity) {
        return StringUtils.substringAfter((String)item, (String)":").equalsIgnoreCase(entity);
    }
}

