/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.migration.pace;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.text.WordUtils;

public class PacePerson {
    private static final String UTF8 = "UTF-8";
    private List<String> name;
    private List<String> surname;
    private List<String> fullname;
    private final String original;
    private static Set<String> particles = null;

    public static final String capitalize(String s) {
        return WordUtils.capitalize((String)s.toLowerCase(), (char[])new char[]{' ', '-'});
    }

    public static final String dotAbbreviations(String s) {
        return s.length() == 1 ? s + "." : s;
    }

    public static Set<String> loadFromClasspath(String classpath) {
        HashSet<String> h = new HashSet<String>();
        try {
            for (String s : IOUtils.readLines((InputStream)PacePerson.class.getResourceAsStream(classpath))) {
                h.add(s);
            }
        }
        catch (Throwable e) {
            return new HashSet<String>();
        }
        return h;
    }

    public PacePerson(String s, boolean aggressive) {
        block10: {
            block8: {
                String[] arr;
                block9: {
                    this.name = Lists.newArrayList();
                    this.surname = Lists.newArrayList();
                    this.fullname = Lists.newArrayList();
                    this.original = s;
                    s = Normalizer.normalize(s, Normalizer.Form.NFD);
                    s = s.replaceAll("\\(.+\\)", "");
                    s = s.replaceAll("\\[.+\\]", "");
                    s = s.replaceAll("\\{.+\\}", "");
                    s = s.replaceAll("\\s+-\\s+", "-");
                    s = s.replaceAll("[\\p{Punct}&&[^,-]]", " ");
                    s = s.replaceAll("\\d", " ");
                    s = s.replaceAll("\\n", " ");
                    s = s.replaceAll("\\.", " ");
                    s = s.replaceAll("\\s+", " ");
                    if (aggressive) {
                        s = s.replaceAll("[\\p{InCombiningDiacriticalMarks}&&[^,-]]", "");
                    }
                    if (!s.contains(",")) break block8;
                    arr = s.split(",");
                    if (arr.length != 1) break block9;
                    this.fullname = this.splitTerms(arr[0]);
                    break block10;
                }
                if (arr.length <= 1) break block10;
                this.surname = this.splitTerms(arr[0]);
                this.name = this.splitTerms(arr[1]);
                this.fullname.addAll(this.surname);
                this.fullname.addAll(this.name);
                break block10;
            }
            this.fullname = this.splitTerms(s);
            int lastInitialPosition = this.fullname.size();
            boolean hasSurnameInUpperCase = false;
            for (int i = 0; i < this.fullname.size(); ++i) {
                String term = this.fullname.get(i);
                if (term.length() == 1) {
                    lastInitialPosition = i;
                    continue;
                }
                if (!term.equals(term.toUpperCase())) continue;
                hasSurnameInUpperCase = true;
            }
            if (lastInitialPosition < this.fullname.size() - 1) {
                this.name = this.fullname.subList(0, lastInitialPosition + 1);
                this.surname = this.fullname.subList(lastInitialPosition + 1, this.fullname.size());
            } else if (hasSurnameInUpperCase) {
                for (String term : this.fullname) {
                    if (term.length() > 1 && term.equals(term.toUpperCase())) {
                        this.surname.add(term);
                        continue;
                    }
                    this.name.add(term);
                }
            }
        }
    }

    private List<String> splitTerms(String s) {
        if (particles == null) {
            particles = PacePerson.loadFromClasspath("/eu/dnetlib/dhp/migration/pace/name_particles.txt");
        }
        ArrayList list = Lists.newArrayList();
        for (String part : Splitter.on((String)" ").omitEmptyStrings().split((CharSequence)s)) {
            if (particles.contains(part.toLowerCase())) continue;
            list.add(part);
        }
        return list;
    }

    public List<String> getName() {
        return this.name;
    }

    public String getNameString() {
        return Joiner.on((String)" ").join(this.getName());
    }

    public List<String> getSurname() {
        return this.surname;
    }

    public List<String> getFullname() {
        return this.fullname;
    }

    public String getOriginal() {
        return this.original;
    }

    public String hash() {
        return Hashing.murmur3_128().hashString((CharSequence)this.getNormalisedFullname(), Charset.forName(UTF8)).toString();
    }

    public String getNormalisedFirstName() {
        return Joiner.on((String)" ").join(this.getCapitalFirstnames());
    }

    public String getNormalisedSurname() {
        return Joiner.on((String)" ").join(this.getCapitalSurname());
    }

    public String getSurnameString() {
        return Joiner.on((String)" ").join(this.getSurname());
    }

    public String getNormalisedFullname() {
        return this.isAccurate() ? this.getNormalisedSurname() + ", " + this.getNormalisedFirstName() : Joiner.on((String)" ").join(this.fullname);
    }

    public List<String> getCapitalFirstnames() {
        return Lists.newArrayList((Iterable)Iterables.transform(this.getNameWithAbbreviations(), PacePerson::capitalize));
    }

    public List<String> getCapitalSurname() {
        return Lists.newArrayList((Iterable)Iterables.transform(this.surname, PacePerson::capitalize));
    }

    public List<String> getNameWithAbbreviations() {
        return Lists.newArrayList((Iterable)Iterables.transform(this.name, PacePerson::dotAbbreviations));
    }

    public boolean isAccurate() {
        return this.name != null && this.surname != null && !this.name.isEmpty() && !this.surname.isEmpty();
    }
}

