/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.migration;

import eu.dnetlib.dhp.migration.AbstractMigrationExecutor;
import eu.dnetlib.dhp.migration.DbClient;
import eu.dnetlib.dhp.migration.MdstoreClient;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.GeoLocation;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.Journal;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.OAIProvenance;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;

public abstract class AbstractMongoExecutor
extends AbstractMigrationExecutor {
    protected final Map<String, String> code2name = new HashMap<String, String>();
    protected final MdstoreClient mdstoreClient;
    protected static final Qualifier MAIN_TITLE_QUALIFIER = AbstractMongoExecutor.qualifier("main title", "main title", "dnet:dataCite_title", "dnet:dataCite_title");
    protected static final Qualifier PUBLICATION_RESULTTYPE_QUALIFIER = AbstractMongoExecutor.qualifier("publication", "publication", "dnet:result_typologies", "dnet:result_typologies");
    protected static final Qualifier DATASET_RESULTTYPE_QUALIFIER = AbstractMongoExecutor.qualifier("dataset", "dataset", "dnet:result_typologies", "dnet:result_typologies");
    protected static final Qualifier SOFTWARE_RESULTTYPE_QUALIFIER = AbstractMongoExecutor.qualifier("software", "software", "dnet:result_typologies", "dnet:result_typologies");
    protected static final Qualifier OTHER_RESULTTYPE_QUALIFIER = AbstractMongoExecutor.qualifier("other", "other", "dnet:result_typologies", "dnet:result_typologies");
    private static final Log log = LogFactory.getLog(AbstractMongoExecutor.class);

    public AbstractMongoExecutor(String hdfsPath, String hdfsNameNode, String hdfsUser, String mongoBaseUrl, String mongoDb, String dbUrl, String dbUser, String dbPassword) throws Exception {
        super(hdfsPath, hdfsNameNode, hdfsUser);
        this.mdstoreClient = new MdstoreClient(mongoBaseUrl, mongoDb);
        this.loadClassNames(dbUrl, dbUser, dbPassword);
        HashMap<String, String> nsContext = new HashMap<String, String>();
        this.registerNamespaces(nsContext);
        DocumentFactory.getInstance().setXPathNamespaceURIs(nsContext);
    }

    private void loadClassNames(String dbUrl, String dbUser, String dbPassword) throws IOException {
        log.info((Object)"Loading vocabulary terms from db...");
        try (DbClient dbClient = new DbClient(dbUrl, dbUser, dbPassword);){
            this.code2name.clear();
            dbClient.processResults("select code, name from class", rs -> {
                try {
                    this.code2name.put(rs.getString("code"), rs.getString("name"));
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            });
        }
        log.info((Object)("Found " + this.code2name.size() + " terms."));
    }

    public void processMdRecords(String mdFormat, String mdLayout, String mdInterpretation) throws DocumentException {
        log.info((Object)String.format("Searching mdstores (format: %s, layout: %s, interpretation: %s)", mdFormat, mdLayout, mdInterpretation));
        Map<String, String> colls = this.mdstoreClient.validCollections(mdFormat, mdLayout, mdInterpretation);
        log.info((Object)("Found " + colls.size() + " mdstores"));
        for (Map.Entry<String, String> entry : colls.entrySet()) {
            log.info((Object)("Processing mdstore " + entry.getKey() + " (collection: " + entry.getValue() + ")"));
            String currentColl = entry.getValue();
            for (String xml : this.mdstoreClient.listRecords(currentColl)) {
                Document doc = DocumentHelper.parseText((String)xml);
                String type = doc.valueOf("//dr:CobjCategory/@type");
                KeyValue collectedFrom = AbstractMongoExecutor.keyValue(doc.valueOf("//oaf:collectedFrom/@id"), doc.valueOf("//oaf:collectedFrom/@name"));
                KeyValue hostedBy = StringUtils.isBlank((CharSequence)doc.valueOf("//oaf:hostedBy/@id")) ? collectedFrom : AbstractMongoExecutor.keyValue(doc.valueOf("//oaf:hostedBy/@id"), doc.valueOf("//oaf:hostedBy/@name"));
                DataInfo info = this.prepareDataInfo(doc);
                long lastUpdateTimestamp = new Date().getTime();
                for (Oaf oaf : this.createOafs(doc, type, collectedFrom, hostedBy, info, lastUpdateTimestamp)) {
                    this.emitOaf(oaf);
                }
            }
        }
        log.info((Object)"All Done.");
    }

    protected void registerNamespaces(Map<String, String> nsContext) {
        nsContext.put("dr", "http://www.driver-repository.eu/namespace/dr");
        nsContext.put("dri", "http://www.driver-repository.eu/namespace/dri");
        nsContext.put("oaf", "http://namespace.openaire.eu/oaf");
        nsContext.put("oai", "http://www.openarchives.org/OAI/2.0/");
        nsContext.put("prov", "http://www.openarchives.org/OAI/2.0/provenance");
    }

    protected List<Oaf> createOafs(Document doc, String type, KeyValue collectedFrom, KeyValue hostedBy, DataInfo info, long lastUpdateTimestamp) {
        ArrayList<Oaf> oafs = new ArrayList<Oaf>();
        switch (type.toLowerCase()) {
            case "": 
            case "publication": {
                Publication p = new Publication();
                this.populateResultFields((Result)p, doc, collectedFrom, hostedBy, info, lastUpdateTimestamp);
                p.setResulttype(PUBLICATION_RESULTTYPE_QUALIFIER);
                p.setJournal(this.prepareJournal(doc, info));
                oafs.add((Oaf)p);
                break;
            }
            case "dataset": {
                Dataset d = new Dataset();
                this.populateResultFields((Result)d, doc, collectedFrom, hostedBy, info, lastUpdateTimestamp);
                d.setResulttype(DATASET_RESULTTYPE_QUALIFIER);
                d.setStoragedate(this.prepareDatasetStorageDate(doc, info));
                d.setDevice(this.prepareDatasetDevice(doc, info));
                d.setSize(this.prepareDatasetSize(doc, info));
                d.setVersion(this.prepareDatasetVersion(doc, info));
                d.setLastmetadataupdate(this.prepareDatasetLastMetadataUpdate(doc, info));
                d.setMetadataversionnumber(this.prepareDatasetMetadataVersionNumber(doc, info));
                d.setGeolocation(this.prepareDatasetGeoLocations(doc, info));
                oafs.add((Oaf)d);
                break;
            }
            case "software": {
                Software s = new Software();
                this.populateResultFields((Result)s, doc, collectedFrom, hostedBy, info, lastUpdateTimestamp);
                s.setResulttype(SOFTWARE_RESULTTYPE_QUALIFIER);
                s.setDocumentationUrl(this.prepareSoftwareDocumentationUrls(doc, info));
                s.setLicense(this.prepareSoftwareLicenses(doc, info));
                s.setCodeRepositoryUrl(this.prepareSoftwareCodeRepositoryUrl(doc, info));
                s.setProgrammingLanguage(this.prepareSoftwareProgrammingLanguage(doc, info));
                oafs.add((Oaf)s);
                break;
            }
            default: {
                OtherResearchProduct o = new OtherResearchProduct();
                this.populateResultFields((Result)o, doc, collectedFrom, hostedBy, info, lastUpdateTimestamp);
                o.setResulttype(OTHER_RESULTTYPE_QUALIFIER);
                o.setContactperson(this.prepareOtherResearchProductContactPersons(doc, info));
                o.setContactgroup(this.prepareOtherResearchProductContactGroups(doc, info));
                o.setTool(this.prepareOtherResearchProductTools(doc, info));
                oafs.add((Oaf)o);
            }
        }
        if (!oafs.isEmpty()) {
            oafs.addAll(this.addProjectRels(doc, collectedFrom, info, lastUpdateTimestamp));
            oafs.addAll(this.addOtherResultRels(doc, collectedFrom, info, lastUpdateTimestamp));
        }
        return oafs;
    }

    private List<Oaf> addProjectRels(Document doc, KeyValue collectedFrom, DataInfo info, long lastUpdateTimestamp) {
        ArrayList<Oaf> res = new ArrayList<Oaf>();
        String docId = AbstractMongoExecutor.createOpenaireId(50, doc.valueOf("//dri:objIdentifier"));
        for (Object o : doc.selectNodes("//oaf:projectid")) {
            String projectId = AbstractMongoExecutor.createOpenaireId(40, ((Node)o).getText());
            Relation r1 = new Relation();
            r1.setRelType("resultProject");
            r1.setSubRelType("outcome");
            r1.setRelClass("isProducedBy");
            r1.setSource(docId);
            r1.setTarget(projectId);
            r1.setCollectedFrom(Arrays.asList(collectedFrom));
            r1.setDataInfo(info);
            r1.setLastupdatetimestamp(Long.valueOf(lastUpdateTimestamp));
            res.add((Oaf)r1);
            Relation r2 = new Relation();
            r2.setRelType("resultProject");
            r2.setSubRelType("outcome");
            r2.setRelClass("produces");
            r2.setSource(projectId);
            r2.setTarget(docId);
            r2.setCollectedFrom(Arrays.asList(collectedFrom));
            r2.setDataInfo(info);
            r2.setLastupdatetimestamp(Long.valueOf(lastUpdateTimestamp));
            res.add((Oaf)r2);
        }
        return res;
    }

    protected abstract List<Oaf> addOtherResultRels(Document var1, KeyValue var2, DataInfo var3, long var4);

    private void populateResultFields(Result r, Document doc, KeyValue collectedFrom, KeyValue hostedBy, DataInfo info, long lastUpdateTimestamp) {
        r.setDataInfo(info);
        r.setLastupdatetimestamp(Long.valueOf(lastUpdateTimestamp));
        r.setId(AbstractMongoExecutor.createOpenaireId(50, doc.valueOf("//dri:objIdentifier")));
        r.setOriginalId(Arrays.asList(doc.valueOf("//dri:objIdentifier")));
        r.setCollectedfrom(Arrays.asList(collectedFrom));
        r.setPid(this.prepareListStructProps((Node)doc, "//oaf:identifier", "@identifierType", "dnet:pid_types", "dnet:pid_types", info));
        r.setDateofcollection(doc.valueOf("//dr:dateOfCollection"));
        r.setDateoftransformation(doc.valueOf("//dr:dateOfTransformation"));
        r.setExtraInfo(new ArrayList());
        r.setOaiprovenance(this.prepareOAIprovenance(doc));
        r.setAuthor(this.prepareAuthors(doc, info));
        r.setLanguage(this.prepareLanguages(doc));
        r.setCountry(new ArrayList());
        r.setSubject(this.prepareSubjects(doc, info));
        r.setTitle(this.prepareTitles(doc, info));
        r.setRelevantdate(this.prepareRelevantDates(doc, info));
        r.setDescription(this.prepareDescriptions(doc, info));
        r.setDateofacceptance(this.prepareField((Node)doc, "//oaf:dateAccepted", info));
        r.setPublisher(this.preparePublisher(doc, info));
        r.setEmbargoenddate(this.prepareField((Node)doc, "//oaf:embargoenddate", info));
        r.setSource(this.prepareSources(doc, info));
        r.setFulltext(new ArrayList());
        r.setFormat(this.prepareFormats(doc, info));
        r.setContributor(this.prepareContributors(doc, info));
        r.setResourcetype(this.prepareResourceType(doc, info));
        r.setCoverage(this.prepareCoverages(doc, info));
        r.setContext(new ArrayList());
        r.setExternalReference(new ArrayList());
        r.setInstance(this.prepareInstances(doc, info, collectedFrom, hostedBy));
    }

    protected abstract Qualifier prepareResourceType(Document var1, DataInfo var2);

    protected abstract List<Instance> prepareInstances(Document var1, DataInfo var2, KeyValue var3, KeyValue var4);

    protected abstract List<Field<String>> prepareSources(Document var1, DataInfo var2);

    protected abstract List<StructuredProperty> prepareRelevantDates(Document var1, DataInfo var2);

    protected abstract List<Field<String>> prepareCoverages(Document var1, DataInfo var2);

    protected abstract List<Field<String>> prepareContributors(Document var1, DataInfo var2);

    protected abstract List<Field<String>> prepareFormats(Document var1, DataInfo var2);

    protected abstract Field<String> preparePublisher(Document var1, DataInfo var2);

    protected abstract List<Field<String>> prepareDescriptions(Document var1, DataInfo var2);

    protected abstract List<StructuredProperty> prepareTitles(Document var1, DataInfo var2);

    protected abstract List<StructuredProperty> prepareSubjects(Document var1, DataInfo var2);

    protected abstract Qualifier prepareLanguages(Document var1);

    protected abstract List<Author> prepareAuthors(Document var1, DataInfo var2);

    protected abstract List<Field<String>> prepareOtherResearchProductTools(Document var1, DataInfo var2);

    protected abstract List<Field<String>> prepareOtherResearchProductContactGroups(Document var1, DataInfo var2);

    protected abstract List<Field<String>> prepareOtherResearchProductContactPersons(Document var1, DataInfo var2);

    protected abstract Qualifier prepareSoftwareProgrammingLanguage(Document var1, DataInfo var2);

    protected abstract Field<String> prepareSoftwareCodeRepositoryUrl(Document var1, DataInfo var2);

    protected abstract List<StructuredProperty> prepareSoftwareLicenses(Document var1, DataInfo var2);

    protected abstract List<Field<String>> prepareSoftwareDocumentationUrls(Document var1, DataInfo var2);

    protected abstract List<GeoLocation> prepareDatasetGeoLocations(Document var1, DataInfo var2);

    protected abstract Field<String> prepareDatasetMetadataVersionNumber(Document var1, DataInfo var2);

    protected abstract Field<String> prepareDatasetLastMetadataUpdate(Document var1, DataInfo var2);

    protected abstract Field<String> prepareDatasetVersion(Document var1, DataInfo var2);

    protected abstract Field<String> prepareDatasetSize(Document var1, DataInfo var2);

    protected abstract Field<String> prepareDatasetDevice(Document var1, DataInfo var2);

    protected abstract Field<String> prepareDatasetStorageDate(Document var1, DataInfo var2);

    private Journal prepareJournal(Document doc, DataInfo info) {
        Node n = doc.selectSingleNode("//oaf:journal");
        if (n != null) {
            String name = n.getText();
            String issnPrinted = n.valueOf("@issn");
            String issnOnline = n.valueOf("@eissn");
            String issnLinking = n.valueOf("@lissn");
            String ep = n.valueOf("@ep");
            String iss = n.valueOf("@iss");
            String sp = n.valueOf("@sp");
            String vol = n.valueOf("@vol");
            String edition = n.valueOf("@edition");
            if (StringUtils.isNotBlank((CharSequence)name)) {
                return AbstractMongoExecutor.journal(name, issnPrinted, issnOnline, issnLinking, ep, iss, sp, vol, edition, null, null, info);
            }
        }
        return null;
    }

    protected Qualifier prepareQualifier(Node node, String xpath, String schemeId, String schemeName) {
        String classId = node.valueOf(xpath);
        String className = this.code2name.get(classId);
        return AbstractMongoExecutor.qualifier(classId, className, schemeId, schemeName);
    }

    protected List<StructuredProperty> prepareListStructProps(Node node, String xpath, String xpathClassId, String schemeId, String schemeName, DataInfo info) {
        ArrayList<StructuredProperty> res = new ArrayList<StructuredProperty>();
        for (Object o : node.selectNodes(xpath)) {
            Node n = (Node)o;
            String classId = n.valueOf(xpathClassId);
            String className = this.code2name.get(classId);
            res.add(AbstractMongoExecutor.structuredProperty(n.getText(), classId, className, schemeId, schemeName, info));
        }
        return res;
    }

    protected List<StructuredProperty> prepareListStructProps(Node node, String xpath, Qualifier qualifier, DataInfo info) {
        ArrayList<StructuredProperty> res = new ArrayList<StructuredProperty>();
        for (Object o : node.selectNodes(xpath)) {
            Node n = (Node)o;
            res.add(AbstractMongoExecutor.structuredProperty(n.getText(), qualifier, info));
        }
        return res;
    }

    protected List<StructuredProperty> prepareListStructProps(Node node, String xpath, DataInfo info) {
        ArrayList<StructuredProperty> res = new ArrayList<StructuredProperty>();
        for (Object o : node.selectNodes(xpath)) {
            Node n = (Node)o;
            res.add(AbstractMongoExecutor.structuredProperty(n.getText(), n.valueOf("@classid"), n.valueOf("@classname"), n.valueOf("@schemeid"), n.valueOf("@schemename"), info));
        }
        return res;
    }

    protected OAIProvenance prepareOAIprovenance(Document doc) {
        Node n = doc.selectSingleNode("//*[local-name()='provenance']/*[local-name()='originDescription']");
        if (n == null) {
            return null;
        }
        String identifier = n.valueOf("./*[local-name()='identifier']");
        String baseURL = n.valueOf("./*[local-name()='baseURL']");
        String metadataNamespace = n.valueOf("./*[local-name()='metadataNamespace']");
        boolean altered = n.valueOf("@altered").equalsIgnoreCase("true");
        String datestamp = n.valueOf("./*[local-name()='datestamp']");
        String harvestDate = n.valueOf("@harvestDate");
        return AbstractMongoExecutor.oaiIProvenance(identifier, baseURL, metadataNamespace, altered, datestamp, harvestDate);
    }

    protected DataInfo prepareDataInfo(Document doc) {
        Node n = doc.selectSingleNode("//oaf:datainfo");
        if (n == null) {
            return null;
        }
        String paClassId = n.valueOf("./oaf:provenanceaction/@classid");
        String paClassName = n.valueOf("./oaf:provenanceaction/@classname");
        String paSchemeId = n.valueOf("./oaf:provenanceaction/@schemeid");
        String paSchemeName = n.valueOf("./oaf:provenanceaction/@schemename");
        boolean deletedbyinference = Boolean.parseBoolean(n.valueOf("./oaf:deletedbyinference"));
        String inferenceprovenance = n.valueOf("./oaf:inferenceprovenance");
        Boolean inferred = Boolean.parseBoolean(n.valueOf("./oaf:inferred"));
        String trust = n.valueOf("./oaf:trust");
        return AbstractMongoExecutor.dataInfo(deletedbyinference, inferenceprovenance, inferred, false, AbstractMongoExecutor.qualifier(paClassId, paClassName, paSchemeId, paSchemeName), trust);
    }

    protected Field<String> prepareField(Node node, String xpath, DataInfo info) {
        return AbstractMongoExecutor.field(node.valueOf(xpath), info);
    }

    protected List<Field<String>> prepareListFields(Node node, String xpath, DataInfo info) {
        return AbstractMongoExecutor.listFields(info, this.prepareListString(node, xpath));
    }

    protected List<String> prepareListString(Node node, String xpath) {
        ArrayList<String> res = new ArrayList<String>();
        for (Object o : node.selectNodes(xpath)) {
            String s = ((Node)o).getText().trim();
            if (!StringUtils.isNotBlank((CharSequence)s)) continue;
            res.add(s);
        }
        return res;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.mdstoreClient.close();
    }
}

