/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.migration;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.migration.OafMigrationExecutor;
import eu.dnetlib.dhp.migration.OdfMigrationExecutor;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;

public class MigrateMongoMdstoresApplication {
    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)MigrateMongoMdstoresApplication.class.getResourceAsStream("/eu/dnetlib/dhp/migration/migrate_mongo_mstores_parameters.json")));
        parser.parseArgument(args);
        String mongoBaseUrl = parser.get("mongoBaseUrl");
        String mongoDb = parser.get("mongoDb");
        String mdFormat = parser.get("mdFormat");
        String mdLayout = parser.get("mdLayout");
        String mdInterpretation = parser.get("mdInterpretation");
        String hdfsPath = parser.get("hdfsPath");
        String hdfsNameNode = parser.get("namenode");
        String hdfsUser = parser.get("hdfsUser");
        String dbUrl = parser.get("postgresUrl");
        String dbUser = parser.get("postgresUser");
        String dbPassword = parser.get("postgresPassword");
        if (mdFormat.equalsIgnoreCase("oaf")) {
            try (OafMigrationExecutor mig = new OafMigrationExecutor(hdfsPath, hdfsNameNode, hdfsUser, mongoBaseUrl, mongoDb, dbUrl, dbUser, dbPassword);){
                mig.processMdRecords(mdFormat, mdLayout, mdInterpretation);
            }
        } else if (mdFormat.equalsIgnoreCase("odf")) {
            try (OdfMigrationExecutor mig = new OdfMigrationExecutor(hdfsPath, hdfsNameNode, hdfsUser, mongoBaseUrl, mongoDb, dbUrl, dbUser, dbPassword);){
                mig.processMdRecords(mdFormat, mdLayout, mdInterpretation);
            }
        } else {
            throw new RuntimeException("Format not supported: " + mdFormat);
        }
    }
}

