/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.migration;

import eu.dnetlib.dhp.migration.AbstractMongoExecutor;
import eu.dnetlib.dhp.migration.pace.PacePerson;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.GeoLocation;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;

public class OafMigrationExecutor
extends AbstractMongoExecutor {
    private static final Log log = LogFactory.getLog(OafMigrationExecutor.class);

    public OafMigrationExecutor(String hdfsPath, String hdfsNameNode, String hdfsUser, String mongoBaseUrl, String mongoDb, String dbUrl, String dbUser, String dbPassword) throws Exception {
        super(hdfsPath, hdfsNameNode, hdfsUser, mongoBaseUrl, mongoDb, dbUrl, dbUser, dbPassword);
    }

    @Override
    protected void registerNamespaces(Map<String, String> nsContext) {
        super.registerNamespaces(nsContext);
        nsContext.put("dc", "http://purl.org/dc/elements/1.1/");
    }

    @Override
    protected List<Author> prepareAuthors(Document doc, DataInfo info) {
        ArrayList<Author> res = new ArrayList<Author>();
        int pos = 1;
        for (Object o : doc.selectNodes("//dc:creator")) {
            Node n = (Node)o;
            Author author = new Author();
            author.setFullname(n.getText());
            author.setRank(Integer.valueOf(pos++));
            PacePerson p = new PacePerson(n.getText(), false);
            if (p.isAccurate()) {
                author.setName(p.getNormalisedFirstName());
                author.setSurname(p.getNormalisedSurname());
            }
            res.add(author);
        }
        return res;
    }

    @Override
    protected Qualifier prepareLanguages(Document doc) {
        return this.prepareQualifier((Node)doc, "//dc:language", "dnet:languages", "dnet:languages");
    }

    @Override
    protected List<StructuredProperty> prepareSubjects(Document doc, DataInfo info) {
        return this.prepareListStructProps((Node)doc, "//dc:subject", info);
    }

    @Override
    protected List<StructuredProperty> prepareTitles(Document doc, DataInfo info) {
        return this.prepareListStructProps((Node)doc, "//dc:title", MAIN_TITLE_QUALIFIER, info);
    }

    @Override
    protected List<Field<String>> prepareDescriptions(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//dc:description", info);
    }

    @Override
    protected Field<String> preparePublisher(Document doc, DataInfo info) {
        return this.prepareField((Node)doc, "//dc:publisher", info);
    }

    @Override
    protected List<Field<String>> prepareFormats(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//dc:format", info);
    }

    @Override
    protected List<Field<String>> prepareContributors(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//dc:contributor", info);
    }

    @Override
    protected List<Field<String>> prepareCoverages(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//dc:coverage", info);
    }

    @Override
    protected List<Instance> prepareInstances(Document doc, DataInfo info, KeyValue collectedfrom, KeyValue hostedby) {
        ArrayList<Instance> res = new ArrayList<Instance>();
        for (Object o : doc.selectNodes("//dc:identifier")) {
            String url = ((Node)o).getText().trim();
            if (!url.startsWith("http")) continue;
            Instance instance = new Instance();
            instance.setUrl(Arrays.asList(url));
            instance.setInstancetype(this.prepareQualifier((Node)doc, "//dr:CobjCategory", "dnet:publication_resource", "dnet:publication_resource"));
            instance.setCollectedfrom(collectedfrom);
            instance.setHostedby(hostedby);
            instance.setDateofacceptance(OafMigrationExecutor.field(doc.valueOf("//oaf:dateAccepted"), info));
            instance.setDistributionlocation(doc.valueOf("//oaf:distributionlocation"));
            instance.setAccessright(this.prepareQualifier((Node)doc, "//oaf:accessrights", "dnet:access_modes", "dnet:access_modes"));
            instance.setLicense(OafMigrationExecutor.field(doc.valueOf("//oaf:license"), info));
            instance.setRefereed(OafMigrationExecutor.field(doc.valueOf("//oaf:refereed"), info));
            instance.setProcessingchargeamount(OafMigrationExecutor.field(doc.valueOf("//oaf:processingchargeamount"), info));
            instance.setProcessingchargecurrency(OafMigrationExecutor.field(doc.valueOf("//oaf:processingchargeamount/@currency"), info));
            res.add(instance);
        }
        return res;
    }

    @Override
    protected List<Field<String>> prepareSources(Document doc, DataInfo info) {
        return this.prepareListFields((Node)doc, "//dc:source", info);
    }

    @Override
    protected List<StructuredProperty> prepareRelevantDates(Document doc, DataInfo info) {
        return new ArrayList<StructuredProperty>();
    }

    @Override
    protected Qualifier prepareSoftwareProgrammingLanguage(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected Field<String> prepareSoftwareCodeRepositoryUrl(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected List<StructuredProperty> prepareSoftwareLicenses(Document doc, DataInfo info) {
        return new ArrayList<StructuredProperty>();
    }

    @Override
    protected List<Field<String>> prepareSoftwareDocumentationUrls(Document doc, DataInfo info) {
        return new ArrayList<Field<String>>();
    }

    @Override
    protected List<GeoLocation> prepareDatasetGeoLocations(Document doc, DataInfo info) {
        return new ArrayList<GeoLocation>();
    }

    @Override
    protected Field<String> prepareDatasetMetadataVersionNumber(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected Field<String> prepareDatasetLastMetadataUpdate(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected Field<String> prepareDatasetVersion(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected Field<String> prepareDatasetSize(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected Field<String> prepareDatasetDevice(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected Field<String> prepareDatasetStorageDate(Document doc, DataInfo info) {
        return null;
    }

    @Override
    protected List<Field<String>> prepareOtherResearchProductTools(Document doc, DataInfo info) {
        return new ArrayList<Field<String>>();
    }

    @Override
    protected List<Field<String>> prepareOtherResearchProductContactGroups(Document doc, DataInfo info) {
        return new ArrayList<Field<String>>();
    }

    @Override
    protected List<Field<String>> prepareOtherResearchProductContactPersons(Document doc, DataInfo info) {
        return new ArrayList<Field<String>>();
    }

    @Override
    protected List<Oaf> addOtherResultRels(Document doc, KeyValue collectedFrom, DataInfo info, long lastUpdateTimestamp) {
        String docId = OafMigrationExecutor.createOpenaireId(50, doc.valueOf("//dri:objIdentifier"));
        ArrayList<Oaf> res = new ArrayList<Oaf>();
        for (Object o : doc.selectNodes("//*[local-name()='relatedDataset']")) {
            String otherId = OafMigrationExecutor.createOpenaireId(50, ((Node)o).getText());
            Relation r1 = new Relation();
            r1.setRelType("resultResult");
            r1.setSubRelType("publicationDataset");
            r1.setRelClass("isRelatedTo");
            r1.setSource(docId);
            r1.setTarget(otherId);
            r1.setCollectedFrom(Arrays.asList(collectedFrom));
            r1.setDataInfo(info);
            r1.setLastupdatetimestamp(Long.valueOf(lastUpdateTimestamp));
            res.add((Oaf)r1);
            Relation r2 = new Relation();
            r2.setRelType("resultResult");
            r2.setSubRelType("publicationDataset");
            r2.setRelClass("isRelatedTo");
            r2.setSource(otherId);
            r2.setTarget(docId);
            r2.setCollectedFrom(Arrays.asList(collectedFrom));
            r2.setDataInfo(info);
            r2.setLastupdatetimestamp(Long.valueOf(lastUpdateTimestamp));
            res.add((Oaf)r2);
        }
        return res;
    }

    @Override
    protected Qualifier prepareResourceType(Document doc, DataInfo info) {
        return null;
    }
}

