/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.opencitations;

import eu.dnetlib.dhp.actionmanager.Constants;
import eu.dnetlib.dhp.actionmanager.opencitations.model.COCI;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadCOCI
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ReadCOCI.class);

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)ReadCOCI.class.getResourceAsStream("/eu/dnetlib/dhp/actionmanager/opencitations/input_readcoci_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        String[] inputFile = parser.get("inputFile").split(";");
        log.info("inputFile {}", Arrays.asList(inputFile));
        Boolean isSparkSessionManaged = Constants.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String workingPath = parser.get("workingPath");
        log.info("workingPath {}", (Object)workingPath);
        String format = parser.get("format");
        log.info("format {}", (Object)format);
        SparkConf sconf = new SparkConf();
        String delimiter = Optional.ofNullable(parser.get("delimiter")).orElse(",");
        SparkSessionSupport.runWithSparkSession((SparkConf)sconf, (Boolean)isSparkSessionManaged, spark -> ReadCOCI.doRead(spark, workingPath, inputFile, outputPath, delimiter, format));
    }

    private static void doRead(SparkSession spark, String workingPath, String[] inputFiles, String outputPath, String delimiter, String format) {
        for (String inputFile : inputFiles) {
            String pString = workingPath + "/" + inputFile + ".gz";
            Dataset cociData = spark.read().format("csv").option("sep", delimiter).option("inferSchema", "true").option("header", "true").option("quotes", "\"").load(pString).repartition(100);
            cociData.map((MapFunction & Serializable)row -> {
                COCI coci = new COCI();
                if (format.equals("COCI")) {
                    coci.setCiting(row.getString(1));
                    coci.setCited(row.getString(2));
                } else {
                    coci.setCiting(String.valueOf(row.getInt(1)));
                    coci.setCited(String.valueOf(row.getInt(2)));
                }
                coci.setOci(row.getString(0));
                return coci;
            }, Encoders.bean(COCI.class)).write().mode(SaveMode.Overwrite).option("compression", "gzip").json(outputPath + inputFile);
        }
    }
}

