/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.orcid;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.collection.orcid.DownloadORCIDDumpApplication;
import eu.dnetlib.dhp.collection.orcid.ORCIDExtractor;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocatedFileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtractORCIDDump {
    private static final Logger log = LoggerFactory.getLogger(ExtractORCIDDump.class);
    private final FileSystem fileSystem;

    public ExtractORCIDDump(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser argumentParser = new ArgumentApplicationParser(IOUtils.toString((InputStream)Objects.requireNonNull(DownloadORCIDDumpApplication.class.getResourceAsStream("/eu/dnetlib/dhp/collection/orcid/extract_orcid_parameter.json"))));
        argumentParser.parseArgument(args);
        String hdfsuri = argumentParser.get("namenode");
        log.info("hdfsURI is {}", (Object)hdfsuri);
        String sourcePath = argumentParser.get("sourcePath");
        log.info("sourcePath is {}", (Object)sourcePath);
        String targetPath = argumentParser.get("targetPath");
        log.info("targetPath is {}", (Object)targetPath);
        FileSystem fileSystem = FileSystem.get((Configuration)DHPUtils.getHadoopConfiguration((String)hdfsuri));
        new ExtractORCIDDump(fileSystem).run(sourcePath, targetPath);
    }

    public void run(String sourcePath, String targetPath) throws IOException, InterruptedException {
        RemoteIterator ls = this.fileSystem.listFiles(new Path(sourcePath), false);
        ArrayList<ORCIDExtractor> workers = new ArrayList<ORCIDExtractor>();
        int i = 0;
        while (ls.hasNext()) {
            LocatedFileStatus current = (LocatedFileStatus)ls.next();
            if (!current.getPath().getName().endsWith("tar.gz")) continue;
            workers.add(new ORCIDExtractor(this.fileSystem, "" + i++, current.getPath(), targetPath));
        }
        workers.forEach(Thread::start);
        for (ORCIDExtractor worker : workers) {
            worker.join();
        }
    }
}

