/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.bipaffiliations;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.Constants;
import eu.dnetlib.dhp.actionmanager.ror.GenerateRorActionSetJob;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.action.AtomicAction;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.utils.CleaningFunctions;
import eu.dnetlib.dhp.schema.oaf.utils.IdentifierFactory;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class PrepareAffiliationRelations
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(PrepareAffiliationRelations.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String ID_PREFIX = "50|doi_________::";
    public static final String BIP_AFFILIATIONS_CLASSID = "result:organization:bipinference";
    public static final String BIP_AFFILIATIONS_CLASSNAME = "Affiliation relation inferred by BIP!";
    public static final String BIP_INFERENCE_PROVENANCE = "bip:affiliation:crossref";

    public static <I extends Result> void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)PrepareAffiliationRelations.class.getResourceAsStream("/eu/dnetlib/dhp/actionmanager/bipaffiliations/input_actionset_parameter.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Constants.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String crossrefInputPath = parser.get("crossrefInputPath");
        log.info("crossrefInputPath: {}", (Object)crossrefInputPath);
        String pubmedInputPath = parser.get("pubmedInputPath");
        log.info("pubmedInputPath: {}", (Object)pubmedInputPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            Constants.removeOutputDir(spark, outputPath);
            List collectedFromCrossref = OafMapperUtils.listKeyValues((String[])new String[]{"10|openaire____::081b82f96300b6a6e3d282bad31cb6e2", "Crossref"});
            JavaPairRDD<Text, Text> crossrefRelations = PrepareAffiliationRelations.prepareAffiliationRelations(spark, crossrefInputPath, collectedFromCrossref);
            List collectedFromPubmed = OafMapperUtils.listKeyValues((String[])new String[]{"10|opendoar____::eda80a3d5b344bc40f3bc04f65b7a357", "Pubmed"});
            JavaPairRDD<Text, Text> pubmedRelations = PrepareAffiliationRelations.prepareAffiliationRelations(spark, pubmedInputPath, collectedFromPubmed);
            crossrefRelations.union(pubmedRelations).saveAsHadoopFile(outputPath, Text.class, Text.class, SequenceFileOutputFormat.class, GzipCodec.class);
        });
    }

    private static <I extends Result> JavaPairRDD<Text, Text> prepareAffiliationRelations(SparkSession spark, String inputPath, List<KeyValue> collectedfrom) {
        Dataset df = spark.read().schema("`DOI` STRING, `Matchings` ARRAY<STRUCT<`RORid`:STRING,`Confidence`:DOUBLE>>").json(inputPath);
        df = df.withColumn("matching", functions.explode((Column)new Column("Matchings"))).select(new Column[]{new Column("DOI").as("doi"), new Column("matching.RORid").as("rorid"), new Column("matching.Confidence").as("confidence")});
        return df.toJavaRDD().flatMap((FlatMapFunction & Serializable)row -> {
            String paperId = ID_PREFIX + IdentifierFactory.md5((String)CleaningFunctions.normalizePidValue((String)"doi", (String)((String)row.getAs("doi"))));
            String affId = GenerateRorActionSetJob.calculateOpenaireId((String)row.getAs("rorid"));
            Qualifier qualifier = OafMapperUtils.qualifier((String)BIP_AFFILIATIONS_CLASSID, (String)BIP_AFFILIATIONS_CLASSNAME, (String)"dnet:provenanceActions", (String)"dnet:provenanceActions");
            DataInfo dataInfo = OafMapperUtils.dataInfo((Boolean)false, (String)BIP_INFERENCE_PROVENANCE, (Boolean)true, (Boolean)false, (Qualifier)qualifier, (String)Double.toString((Double)row.getAs("confidence")));
            return PrepareAffiliationRelations.getAffiliationRelationPair(paperId, affId, collectedfrom, dataInfo).iterator();
        }).map((Function & Serializable)p -> new AtomicAction(Relation.class, (Oaf)p)).mapToPair((PairFunction & Serializable)aa -> new Tuple2((Object)new Text(aa.getClazz().getCanonicalName()), (Object)new Text(OBJECT_MAPPER.writeValueAsString(aa))));
    }

    private static List<Relation> getAffiliationRelationPair(String paperId, String affId, List<KeyValue> collectedfrom, DataInfo dataInfo) {
        return Arrays.asList(OafMapperUtils.getRelation((String)paperId, (String)affId, (String)"resultOrganization", (String)"affiliation", (String)"hasAuthorInstitution", collectedfrom, (DataInfo)dataInfo, null), OafMapperUtils.getRelation((String)affId, (String)paperId, (String)"resultOrganization", (String)"affiliation", (String)"isAuthorInstitutionOf", collectedfrom, (DataInfo)dataInfo, null));
    }
}

