/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.createunresolvedentities;

import eu.dnetlib.dhp.actionmanager.Constants;
import eu.dnetlib.dhp.actionmanager.createunresolvedentities.model.SDGDataModel;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetSDGSparkJob
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(GetSDGSparkJob.class);

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)GetSDGSparkJob.class.getResourceAsStream("/eu/dnetlib/dhp/actionmanager/createunresolvedentities/get_input_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Constants.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String sourcePath = parser.get("sourcePath");
        log.info("sourcePath {}", (Object)sourcePath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath {}", (Object)outputPath);
        String delimiter = Optional.ofNullable(parser.get("delimiter")).orElse(",");
        SparkConf sconf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)sconf, (Boolean)isSparkSessionManaged, spark -> GetSDGSparkJob.getSDG(spark, sourcePath, outputPath, delimiter));
    }

    private static void getSDG(SparkSession spark, String sourcePath, String outputPath, String delimiter) {
        Dataset sdgData = spark.read().format("csv").option("sep", delimiter).option("inferSchema", "true").option("header", "true").option("quotes", "\"").load(sourcePath);
        sdgData.map((MapFunction & Serializable)r -> {
            SDGDataModel sdgDataModel = new SDGDataModel();
            sdgDataModel.setDoi(r.getString(0).toLowerCase());
            sdgDataModel.setSbj(r.getString(1));
            return sdgDataModel;
        }, Encoders.bean(SDGDataModel.class)).filter((FilterFunction & Serializable)sdg -> sdg.getSbj() != null).write().mode(SaveMode.Overwrite).json(outputPath);
    }
}

