/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.aggregation.mdstore;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.rest.DNetRestClient;
import eu.dnetlib.dhp.schema.mdstore.MDStoreVersion;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MDStoreActionNode {
    private static final Logger log = LoggerFactory.getLogger(MDStoreActionNode.class);
    public static final String NEW_VERSION_URI = "%s/mdstore/%s/newVersion";
    public static final String COMMIT_VERSION_URL = "%s/version/%s/commit/%s";
    public static final String ROLLBACK_VERSION_URL = "%s/version/%s/abort";
    public static final String READ_LOCK_URL = "%s/mdstore/%s/startReading";
    public static final String READ_UNLOCK_URL = "%s/version/%s/endReading";
    private static final String MDSTOREVERSIONPARAM = "mdStoreVersion";
    private static final String MDSTOREREADLOCKPARAM = "mdStoreReadLockVersion";

    /*
     * Unable to fully structure code
     */
    public static void main(String[] args) throws Exception {
        argumentParser = new ArgumentApplicationParser(IOUtils.toString((InputStream)MDStoreActionNode.class.getResourceAsStream("/eu/dnetlib/dhp/collection/mdstore_action_parameters.json")));
        argumentParser.parseArgument(args);
        MDStoreActionNode.log.info("Java Xmx: {}m", (Object)(Runtime.getRuntime().maxMemory() / 0x100000L));
        action = MDAction.valueOf(argumentParser.get("action"));
        MDStoreActionNode.log.info("Current action is {}", (Object)action);
        mdStoreManagerURI = argumentParser.get("mdStoreManagerURI");
        MDStoreActionNode.log.info("mdStoreManagerURI is {}", (Object)mdStoreManagerURI);
        switch (1.$SwitchMap$eu$dnetlib$dhp$aggregation$mdstore$MDStoreActionNode$MDAction[action.ordinal()]) {
            case 1: {
                mdStoreID = argumentParser.get("mdStoreID");
                if (StringUtils.isBlank((CharSequence)mdStoreID)) {
                    throw new IllegalArgumentException("missing or empty argument mdStoreId");
                }
                currentVersion = (MDStoreVersion)DNetRestClient.doGET((String)String.format("%s/mdstore/%s/newVersion", new Object[]{mdStoreManagerURI, mdStoreID}), MDStoreVersion.class);
                DHPUtils.populateOOZIEEnv((String)"mdStoreVersion", (String)DHPUtils.MAPPER.writeValueAsString((Object)currentVersion));
                break;
            }
            case 2: {
                hdfsuri = argumentParser.get("namenode");
                if (StringUtils.isBlank((CharSequence)hdfsuri)) {
                    throw new IllegalArgumentException("missing or empty argument namenode");
                }
                mdStoreVersion_params = argumentParser.get("mdStoreVersion");
                mdStoreVersion = (MDStoreVersion)DHPUtils.MAPPER.readValue(mdStoreVersion_params, MDStoreVersion.class);
                if (StringUtils.isBlank((CharSequence)mdStoreVersion.getId())) {
                    throw new IllegalArgumentException("invalid MDStoreVersion value current is " + mdStoreVersion_params);
                }
                hdfstoreSizepath = new Path(mdStoreVersion.getHdfsPath() + "/size");
                fs = FileSystem.get((URI)URI.create(hdfsuri), (Configuration)DHPUtils.getHadoopConfiguration((String)hdfsuri));
                var9_17 = null;
                inputStream = fs.open(hdfstoreSizepath);
                var11_21 = null;
                try {
                    mdStoreSize = Long.parseLong(IOUtils.toString((InputStream)inputStream));
                    fs.create(hdfstoreSizepath);
                    DNetRestClient.doGET((String)String.format("%s/version/%s/commit/%s", new Object[]{mdStoreManagerURI, mdStoreVersion.getId(), mdStoreSize}));
                }
                catch (Throwable var12_24) {
                    var11_21 = var12_24;
                    throw var12_24;
                }
                finally {
                    if (inputStream != null) {
                        if (var11_21 != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable var12_23) {
                                var11_21.addSuppressed(var12_23);
                            }
                        } else {
                            inputStream.close();
                        }
                    }
                }
                if (fs == null) break;
                if (var9_17 == null) ** GOTO lbl59
                try {
                    fs.close();
                }
                catch (Throwable var10_19) {
                    var9_17.addSuppressed(var10_19);
                }
                break;
lbl59:
                // 1 sources

                fs.close();
                break;
                catch (Throwable var10_20) {
                    try {
                        var9_17 = var10_20;
                        throw var10_20;
                    }
                    catch (Throwable var15_27) {
                        if (fs != null) {
                            if (var9_17 != null) {
                                try {
                                    fs.close();
                                }
                                catch (Throwable var16_28) {
                                    var9_17.addSuppressed(var16_28);
                                }
                            } else {
                                fs.close();
                            }
                        }
                        throw var15_27;
                    }
                }
            }
            case 3: {
                mdStoreVersion_params = argumentParser.get("mdStoreVersion");
                mdStoreVersion = (MDStoreVersion)DHPUtils.MAPPER.readValue(mdStoreVersion_params, MDStoreVersion.class);
                if (StringUtils.isBlank((CharSequence)mdStoreVersion.getId())) {
                    throw new IllegalArgumentException("invalid MDStoreVersion value current is " + mdStoreVersion_params);
                }
                DNetRestClient.doGET((String)String.format("%s/version/%s/abort", new Object[]{mdStoreManagerURI, mdStoreVersion.getId()}));
                break;
            }
            case 4: {
                mdStoreID = argumentParser.get("mdStoreID");
                if (StringUtils.isBlank((CharSequence)mdStoreID)) {
                    throw new IllegalArgumentException("missing or empty argument mdStoreId");
                }
                currentVersion = (MDStoreVersion)DNetRestClient.doGET((String)String.format("%s/mdstore/%s/startReading", new Object[]{mdStoreManagerURI, mdStoreID}), MDStoreVersion.class);
                DHPUtils.populateOOZIEEnv((String)"mdStoreReadLockVersion", (String)DHPUtils.MAPPER.writeValueAsString((Object)currentVersion));
                break;
            }
            case 5: {
                mdStoreVersion_params = argumentParser.get("readMDStoreId");
                mdStoreVersion = (MDStoreVersion)DHPUtils.MAPPER.readValue(mdStoreVersion_params, MDStoreVersion.class);
                if (StringUtils.isBlank((CharSequence)mdStoreVersion.getId())) {
                    throw new IllegalArgumentException("invalid MDStoreVersion value current is " + mdStoreVersion_params);
                }
                DNetRestClient.doGET((String)String.format("%s/version/%s/endReading", new Object[]{mdStoreManagerURI, mdStoreVersion.getId()}));
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid action");
            }
        }
    }

    static enum MDAction {
        NEW_VERSION,
        ROLLBACK,
        COMMIT,
        READ_LOCK,
        READ_UNLOCK;

    }
}

