/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.project;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.project.utils.model.CSVProgramme;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.HdfsSupport;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import java.io.InputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class PrepareProgramme {
    private static final Logger log = LoggerFactory.getLogger(PrepareProgramme.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)PrepareProgramme.class.getResourceAsStream("/eu/dnetlib/dhp/actionmanager/project/prepare_programme_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String programmePath = parser.get("programmePath");
        log.info("programmePath {}: ", (Object)programmePath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath {}: ", (Object)outputPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            PrepareProgramme.removeOutputDir(spark, outputPath);
            PrepareProgramme.exec(spark, programmePath, outputPath);
        });
    }

    private static void removeOutputDir(SparkSession spark, String path) {
        HdfsSupport.remove((String)path, (Configuration)spark.sparkContext().hadoopConfiguration());
    }

    private static void exec(SparkSession spark, String programmePath, String outputPath) {
        Dataset<CSVProgramme> programme = PrepareProgramme.readPath(spark, programmePath, CSVProgramme.class);
        JavaRDD h2020Programmes = programme.toJavaRDD().mapToPair((PairFunction & Serializable)csvProgramme -> new Tuple2((Object)csvProgramme.getCode(), csvProgramme)).reduceByKey(PrepareProgramme::groupProgrammeByCode).map((Function & Serializable)p -> {
            CSVProgramme csvProgramme = (CSVProgramme)p._2();
            String programmeTitle = csvProgramme.getTitle().trim();
            if (programmeTitle.length() > 8 && programmeTitle.substring(0, 8).equalsIgnoreCase("PRIORITY")) {
                if ((programmeTitle = programmeTitle.substring(9)).charAt(0) == '\'') {
                    programmeTitle = programmeTitle.substring(1);
                }
                if (programmeTitle.charAt(programmeTitle.length() - 1) == '\'') {
                    programmeTitle = programmeTitle.substring(0, programmeTitle.length() - 1);
                }
                csvProgramme.setTitle(programmeTitle);
            }
            return csvProgramme;
        });
        JavaSparkContext jsc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD rdd = jsc.parallelize(PrepareProgramme.prepareClassification((JavaRDD<CSVProgramme>)h2020Programmes), 1);
        rdd.map(arg_0 -> ((ObjectMapper)OBJECT_MAPPER).writeValueAsString(arg_0)).saveAsTextFile(outputPath);
    }

    private static CSVProgramme groupProgrammeByCode(CSVProgramme a, CSVProgramme b) {
        if (!a.getLanguage().equals("en") && b.getLanguage().equalsIgnoreCase("en")) {
            a.setTitle(b.getTitle());
            a.setLanguage(b.getLanguage());
        }
        if (StringUtils.isEmpty((CharSequence)a.getShortTitle()) && !StringUtils.isEmpty((CharSequence)b.getShortTitle())) {
            a.setShortTitle(b.getShortTitle());
        }
        return a;
    }

    private static List<CSVProgramme> prepareClassification(JavaRDD<CSVProgramme> h2020Programmes) {
        int j;
        Object[] codedescription = h2020Programmes.map((Function & Serializable)value -> new Tuple2((Object)value.getCode(), (Object)new Tuple2((Object)value.getTitle(), (Object)value.getShortTitle()))).collect().toArray();
        for (int i = 0; i < codedescription.length - 1; ++i) {
            for (j = i + 1; j < codedescription.length; ++j) {
                Tuple2 t2i = (Tuple2)codedescription[i];
                Tuple2 t2j = (Tuple2)codedescription[j];
                if (((String)t2i._1()).compareTo((String)t2j._1()) <= 0) continue;
                Tuple2 temp = t2i;
                codedescription[i] = t2j;
                codedescription[j] = temp;
            }
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (j = 0; j < codedescription.length; ++j) {
            String shortTitle;
            String key;
            String[] tmp;
            Tuple2 entry = (Tuple2)codedescription[j];
            String ent = (String)entry._1();
            if (ent.contains("Euratom-")) {
                ent = ent.replace("-Euratom-", ".Euratom.");
            }
            if ((tmp = ent.split("\\.")).length <= 2) {
                if (StringUtils.isEmpty((CharSequence)((CharSequence)((Tuple2)entry._2())._2()))) {
                    map.put(entry._1(), new Tuple2(((Tuple2)entry._2())._1(), ((Tuple2)entry._2())._1()));
                    continue;
                }
                map.put(entry._1(), entry._2());
                continue;
            }
            if (ent.endsWith(".")) {
                ent = ent.substring(0, ent.length() - 1);
            }
            if ((key = ent.substring(0, ent.lastIndexOf(".") + 1)).contains("Euratom")) {
                key = key.replace(".Euratom.", "-Euratom-");
                ent = ent.replace(".Euratom.", "-Euratom-");
                if (key.endsWith("-")) {
                    key = key.substring(0, key.length() - 1);
                }
            }
            String current = (String)((Tuple2)entry._2())._1();
            if (!ent.contains("Euratom")) {
                String tmpKey = tmp[0] + ".";
                for (int i = 1; i < tmp.length - 1; ++i) {
                    String parent = ((String)((Tuple2)map.get(tmpKey = tmpKey + tmp[i] + "."))._1()).toLowerCase().trim();
                    if (parent.contains("|")) {
                        parent = parent.substring(parent.lastIndexOf("|") + 1).trim();
                    }
                    if (current.trim().length() <= parent.length() || !current.toLowerCase().trim().startsWith(parent) || (current = current.substring(parent.length() + 1)).trim().charAt(0) != '-' && current.trim().charAt(0) != '\u2013') continue;
                    current = current.trim().substring(1).trim();
                }
            }
            if (StringUtils.isEmpty((CharSequence)(shortTitle = (String)((Tuple2)entry._2())._2()))) {
                shortTitle = current;
            }
            Tuple2 newEntry = new Tuple2((Object)((String)((Tuple2)map.get(key))._1() + " | " + current), (Object)((String)((Tuple2)map.get(key))._2() + " | " + shortTitle));
            map.put(ent + ".", newEntry);
        }
        return h2020Programmes.map((Function & Serializable)csvProgramme -> {
            String code = csvProgramme.getCode();
            if (!(code.endsWith(".") || code.contains("Euratom") || code.equals("H2020-EC") || code.equals("H2020") || code.equals("H2020-Topics"))) {
                code = code + ".";
            }
            if (map.containsKey(code)) {
                csvProgramme.setClassification((String)((Tuple2)map.get(code))._1());
                csvProgramme.setClassification_short((String)((Tuple2)map.get(code))._2());
            } else {
                log.info("WARNING: No entry in map for code " + code);
            }
            return csvProgramme;
        }).collect();
    }

    public static <R> Dataset<R> readPath(SparkSession spark, String inputPath, Class<R> clazz) {
        return spark.read().textFile(inputPath).map((MapFunction & Serializable)value -> OBJECT_MAPPER.readValue(value, clazz), Encoders.bean(clazz));
    }
}

