/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.datacite;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.application.AbstractScalaApplication;
import eu.dnetlib.dhp.collection.CollectionUtils$;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.datacite.DataciteToOAFTransformation$;
import eu.dnetlib.dhp.datacite.DataciteType;
import eu.dnetlib.dhp.datacite.GenerateDataciteDatasetSpark$;
import eu.dnetlib.dhp.schema.mdstore.MDStoreVersion;
import eu.dnetlib.dhp.schema.mdstore.MetadataRecord;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.utils.DHPUtils;
import eu.dnetlib.dhp.utils.ISLookupClientFactory;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Y4A!\u0001\u0002\u0001\u0017\tar)\u001a8fe\u0006$X\rR1uC\u000eLG/\u001a#bi\u0006\u001cX\r^*qCJ\\'BA\u0002\u0005\u0003!!\u0017\r^1dSR,'BA\u0003\u0007\u0003\r!\u0007\u000e\u001d\u0006\u0003\u000f!\tq\u0001\u001a8fi2L'MC\u0001\n\u0003\t)Wo\u0001\u0001\u0014\u0005\u0001a\u0001CA\u0007\u0011\u001b\u0005q!BA\b\u0005\u0003-\t\u0007\u000f\u001d7jG\u0006$\u0018n\u001c8\n\u0005Eq!\u0001G!cgR\u0014\u0018m\u0019;TG\u0006d\u0017-\u00119qY&\u001c\u0017\r^5p]\"I1\u0003\u0001B\u0001B\u0003%ACH\u0001\raJ|\u0007/\u001a:usB\u000bG\u000f\u001b\t\u0003+mq!AF\r\u000e\u0003]Q\u0011\u0001G\u0001\u0006g\u000e\fG.Y\u0005\u00035]\ta\u0001\u0015:fI\u00164\u0017B\u0001\u000f\u001e\u0005\u0019\u0019FO]5oO*\u0011!dF\u0005\u0003'AA\u0011\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0013\u0002\t\u0005\u0014xm\u001d\t\u0004-\t\"\u0012BA\u0012\u0018\u0005\u0015\t%O]1z\u0013\t\u0001\u0003\u0003\u0003\u0005'\u0001\t\u0005\t\u0015!\u0003(\u0003\rawn\u001a\t\u0003Q5j\u0011!\u000b\u0006\u0003U-\nQa\u001d7gi)T\u0011\u0001L\u0001\u0004_J<\u0017B\u0001\u0018*\u0005\u0019aunZ4fe\")\u0001\u0007\u0001C\u0001c\u00051A(\u001b8jiz\"BA\r\u001b6mA\u00111\u0007A\u0007\u0002\u0005!)1c\fa\u0001)!)\u0001e\fa\u0001C!)ae\fa\u0001O!)\u0001\b\u0001C!s\u0005\u0019!/\u001e8\u0015\u0003i\u0002\"AF\u001e\n\u0005q:\"\u0001B+oSRDQA\u0010\u0001\u0005\u0002}\nqB]3q_J$Hk\u001c;bYNK'0\u001a\u000b\u0004u\u0001\u0013\u0005\"B!>\u0001\u0004!\u0012A\u0003;be\u001e,G\u000fU1uQ\")1)\u0010a\u0001)\u0005qq.\u001e;qkR\u0014\u0015m]3QCRD\u0007\"B#\u0001\t\u00031\u0015aF4f]\u0016\u0014\u0018\r^3ECR\f7-\u001b;f\t\u0006$\u0018m]3u)\u0019Qt)\u0013(Y3\")\u0001\n\u0012a\u0001)\u0005Q1o\\;sG\u0016\u0004\u0016\r\u001e5\t\u000b)#\u0005\u0019A&\u0002\u0017\u0015D\bo\u001c:u\u0019&t7n\u001d\t\u0003-1K!!T\f\u0003\u000f\t{w\u000e\\3b]\")q\n\u0012a\u0001!\u0006aao\\2bEVd\u0017M]5fgB\u0011\u0011KV\u0007\u0002%*\u00111\u000bV\u0001\u000bm>\u001c\u0017MY;mCJL(BA+\u0005\u0003\u0019\u0019w.\\7p]&\u0011qK\u0015\u0002\u0010->\u001c\u0017MY;mCJLxI]8va\")\u0011\t\u0012a\u0001)!)!\f\u0012a\u00017\u0006)1\u000f]1sWB\u0011ALY\u0007\u0002;*\u0011alX\u0001\u0004gFd'B\u0001.a\u0015\t\t7&\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003Gv\u0013Ab\u00159be.\u001cVm]:j_:<Q!\u001a\u0002\t\u0002\u0019\fAdR3oKJ\fG/\u001a#bi\u0006\u001c\u0017\u000e^3ECR\f7/\u001a;Ta\u0006\u00148\u000e\u0005\u00024O\u001a)\u0011A\u0001E\u0001QN\u0011q-\u001b\t\u0003-)L!a[\f\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0001t\r\"\u0001n)\u00051\u0007b\u0002\u0014h\u0005\u0004%\ta\\\u000b\u0002O!1\u0011o\u001aQ\u0001\n\u001d\nA\u0001\\8hA!)1o\u001aC\u0001i\u0006!Q.Y5o)\tQT\u000fC\u0003!e\u0002\u0007\u0011\u0005")
public class GenerateDataciteDatasetSpark
extends AbstractScalaApplication {
    private final Logger log;

    public static void main(String[] stringArray) {
        GenerateDataciteDatasetSpark$.MODULE$.main(stringArray);
    }

    public void run() {
        String sourcePath = this.parser().get("sourcePath");
        this.log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"SourcePath is '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourcePath})));
        boolean exportLinks = "true".equalsIgnoreCase(this.parser().get("exportLinks"));
        this.log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"exportLinks is '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToBoolean((boolean)exportLinks)})));
        String isLookupUrl = this.parser().get("isLookupUrl");
        this.log.info("isLookupUrl: {}", new Object[]{isLookupUrl});
        ISLookUpService isLookupService = ISLookupClientFactory.getLookUpService((String)isLookupUrl);
        VocabularyGroup vocabularies = VocabularyGroup.loadVocsFromIS((ISLookUpService)isLookupService);
        Predef$.MODULE$.require(vocabularies != null);
        String mdstoreOutputVersion = this.parser().get("mdstoreOutputVersion");
        this.log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"mdstoreOutputVersion is '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{mdstoreOutputVersion})));
        ObjectMapper mapper = new ObjectMapper();
        MDStoreVersion cleanedMdStoreVersion = (MDStoreVersion)mapper.readValue(mdstoreOutputVersion, MDStoreVersion.class);
        String outputBasePath = cleanedMdStoreVersion.getHdfsPath();
        this.log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"outputBasePath is '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputBasePath})));
        String targetPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{outputBasePath, "/store"}));
        this.log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"targetPath is '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{targetPath})));
        this.generateDataciteDataset(sourcePath, exportLinks, vocabularies, targetPath, this.spark());
        this.reportTotalSize(targetPath, outputBasePath);
    }

    public void reportTotalSize(String targetPath, String outputBasePath) {
        long total_items = this.spark().read().text(targetPath).count();
        DHPUtils.writeHdfsFile((Configuration)this.spark().sparkContext().hadoopConfiguration(), (String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)total_items)})), (String)new StringBuilder().append((Object)outputBasePath).append((Object)"/size").toString());
    }

    public void generateDataciteDataset(String sourcePath, boolean exportLinks, VocabularyGroup vocabularies, String targetPath, SparkSession spark) {
        Predef$.MODULE$.require(spark != null);
        Encoder mrEncoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(MetadataRecord.class));
        Encoder resEncoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Oaf.class));
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(GenerateDataciteDatasetSpark.class.getClassLoader());
        public final class Eu_dnetlib_dhp_datacite_GenerateDataciteDatasetSpark$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $m.staticClass("eu.dnetlib.dhp.datacite.DataciteType").asType().toTypeConstructor();
            }

            public Eu_dnetlib_dhp_datacite_GenerateDataciteDatasetSpark$$typecreator4$1(GenerateDataciteDatasetSpark $outer) {
            }
        }
        CollectionUtils$.MODULE$.saveDataset((Dataset<Oaf>)spark.read().load(sourcePath).as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Eu_dnetlib_dhp_datacite_GenerateDataciteDatasetSpark$$typecreator4$1(this)))).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(DataciteType d) {
                return d.isActive();
            }
        }).flatMap((Function1)new Serializable(this, exportLinks, vocabularies){
            public static final long serialVersionUID = 0L;
            private final boolean exportLinks$1;
            private final VocabularyGroup vocabularies$1;

            public final List<Oaf> apply(DataciteType d) {
                return DataciteToOAFTransformation$.MODULE$.generateOAF(d.json(), d.timestamp(), d.timestamp(), this.vocabularies$1, this.exportLinks$1);
            }
            {
                this.exportLinks$1 = exportLinks$1;
                this.vocabularies$1 = vocabularies$1;
            }
        }, resEncoder).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf d) {
                return d != null;
            }
        }), targetPath);
    }

    public GenerateDataciteDatasetSpark(String propertyPath, String[] args, Logger log) {
        this.log = log;
        super(propertyPath, args, log);
    }
}

