/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.person;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.personentity.ExtractPerson;
import eu.dnetlib.dhp.schema.action.AtomicAction;
import eu.dnetlib.dhp.schema.oaf.Person;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.io.Text;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatePersonAS {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static SparkSession spark;
    private static Path workingDir;
    private static final Logger log;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(CreatePersonAS.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(CreatePersonAS.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.codegen.wholeStage", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(CreatePersonAS.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void testAuthors() throws Exception {
        String inputPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/person/").getPath();
        ExtractPerson.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-inputPath", inputPath, "-outputPath", workingDir.toString() + "/actionSet1", "-workingDir", workingDir.toString() + "/working"});
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD relations = sc.sequenceFile(workingDir.toString() + "/actionSet1", Text.class, Text.class).filter((Function & Serializable)v -> "eu.dnetlib.dhp.schema.oaf.Relation".equalsIgnoreCase(((Text)v._1()).toString())).map((Function & Serializable)value -> (AtomicAction)OBJECT_MAPPER.readValue(((Text)value._2()).toString(), AtomicAction.class)).map((Function & Serializable)aa -> (Relation)aa.getPayload());
        JavaRDD people = sc.sequenceFile(workingDir.toString() + "/actionSet1", Text.class, Text.class).filter((Function & Serializable)v -> "eu.dnetlib.dhp.schema.oaf.Person".equalsIgnoreCase(((Text)v._1()).toString())).map((Function & Serializable)value -> (AtomicAction)OBJECT_MAPPER.readValue(((Text)value._2()).toString(), AtomicAction.class)).map((Function & Serializable)aa -> (Person)aa.getPayload());
        Assertions.assertEquals((long)7L, (long)people.count());
        Assertions.assertEquals((Object)"Paulo", (Object)((Person)people.filter((Function & Serializable)p -> p.getPid().stream().anyMatch(id -> id.getValue().equalsIgnoreCase("0000-0002-3210-3034"))).first()).getGivenName());
        Assertions.assertEquals((Object)"Tavares", (Object)((Person)people.filter((Function & Serializable)p -> p.getPid().stream().anyMatch(id -> id.getValue().equalsIgnoreCase("0000-0002-3210-3034"))).first()).getFamilyName());
        Assertions.assertEquals((int)4, (int)((Person)people.filter((Function & Serializable)p -> p.getPid().stream().anyMatch(id -> id.getValue().equalsIgnoreCase("0000-0002-3210-3034"))).first()).getAlternativeNames().size());
        Assertions.assertEquals((int)4, (int)((Person)people.filter((Function & Serializable)p -> p.getPid().stream().anyMatch(id -> id.getValue().equalsIgnoreCase("0000-0002-3210-3034"))).first()).getPid().size());
        Assertions.assertTrue((boolean)((Person)people.filter((Function & Serializable)p -> p.getPid().stream().anyMatch(id -> id.getValue().equalsIgnoreCase("0000-0002-3210-3034"))).first()).getPid().stream().anyMatch(p -> p.getQualifier().getSchemename().equalsIgnoreCase("Scopus Author ID") && p.getValue().equalsIgnoreCase("15119405200")));
        Assertions.assertEquals((long)16L, (long)relations.filter((Function & Serializable)r -> r.getRelClass().equalsIgnoreCase("hasAuthored")).count());
        Assertions.assertEquals((long)14L, (long)relations.filter((Function & Serializable)r -> r.getRelClass().equalsIgnoreCase("hasCoAuthor")).count());
        Assertions.assertEquals((long)3L, (long)relations.filter((Function & Serializable)r -> r.getSource().equalsIgnoreCase("30|orcid_______::" + DHPUtils.md5((String)"0000-0001-6291-9619")) && r.getRelClass().equalsIgnoreCase("hasAuthored")).count());
        Assertions.assertEquals((long)2L, (long)relations.filter((Function & Serializable)r -> r.getSource().equalsIgnoreCase("30|orcid_______::" + DHPUtils.md5((String)"0000-0001-6291-9619")) && r.getRelClass().equalsIgnoreCase("hasAuthored") && r.getTarget().startsWith("50|doi")).count());
        Assertions.assertEquals((long)1L, (long)relations.filter((Function & Serializable)r -> r.getSource().equalsIgnoreCase("30|orcid_______::" + DHPUtils.md5((String)"0000-0001-6291-9619")) && r.getRelClass().equalsIgnoreCase("hasAuthored") && r.getTarget().startsWith("50|arXiv")).count());
        Assertions.assertEquals((long)1L, (long)relations.filter((Function & Serializable)r -> r.getSource().equalsIgnoreCase("30|orcid_______::" + DHPUtils.md5((String)"0000-0001-6291-9619")) && r.getRelClass().equalsIgnoreCase("hasCoAuthor")).count());
        Assertions.assertEquals((long)33L, (long)relations.count());
    }

    static {
        log = LoggerFactory.getLogger(CreatePersonAS.class);
    }
}

