/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.transformativeagreement;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.opencitations.CreateOpenCitationsASTest;
import eu.dnetlib.dhp.actionmanager.transformativeagreement.CreateActionSetSparkJob;
import eu.dnetlib.dhp.schema.action.AtomicAction;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.utils.IdentifierFactory;
import eu.dnetlib.dhp.schema.oaf.utils.PidCleaner;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.io.Text;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTAActionSetTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static SparkSession spark;
    private static Path workingDir;
    private static final Logger log;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(CreateTAActionSetTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(CreateTAActionSetTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(CreateTAActionSetTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void createActionSet() throws Exception {
        String inputPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/transformativeagreement/facts.json").getPath();
        CreateActionSetSparkJob.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-inputPath", inputPath, "-outputPath", workingDir.toString() + "/actionSet1"});
    }

    @Test
    void testNumberofRelations2() throws Exception {
        String inputPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/opencitations/COCI").getPath();
        eu.dnetlib.dhp.actionmanager.opencitations.CreateActionSetSparkJob.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-inputPath", inputPath, "-outputPath", workingDir.toString() + "/actionSet2"});
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD tmp = sc.sequenceFile(workingDir.toString() + "/actionSet2", Text.class, Text.class).map((Function & Serializable)value -> (AtomicAction)OBJECT_MAPPER.readValue(((Text)value._2()).toString(), AtomicAction.class)).map((Function & Serializable)aa -> (Relation)aa.getPayload());
        Assertions.assertEquals((long)23L, (long)tmp.count());
    }

    @Test
    void testRelationsCollectedFrom() throws Exception {
        String inputPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/opencitations/COCI").getPath();
        eu.dnetlib.dhp.actionmanager.opencitations.CreateActionSetSparkJob.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-inputPath", inputPath, "-outputPath", workingDir.toString() + "/actionSet3"});
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD tmp = sc.sequenceFile(workingDir.toString() + "/actionSet3", Text.class, Text.class).map((Function & Serializable)value -> (AtomicAction)OBJECT_MAPPER.readValue(((Text)value._2()).toString(), AtomicAction.class)).map((Function & Serializable)aa -> (Relation)aa.getPayload());
        tmp.foreach((VoidFunction & Serializable)r -> {
            Assertions.assertEquals((Object)"OpenCitations", (Object)((KeyValue)r.getCollectedfrom().get(0)).getValue());
            Assertions.assertEquals((Object)"10|openaire____::c06df618c5de1c786535ccf3f8b7b059", (Object)((KeyValue)r.getCollectedfrom().get(0)).getKey());
        });
    }

    @Test
    void testRelationsDataInfo() throws Exception {
        String inputPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/opencitations/COCI").getPath();
        eu.dnetlib.dhp.actionmanager.opencitations.CreateActionSetSparkJob.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-inputPath", inputPath, "-outputPath", workingDir.toString() + "/actionSet4"});
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD tmp = sc.sequenceFile(workingDir.toString() + "/actionSet4", Text.class, Text.class).map((Function & Serializable)value -> (AtomicAction)OBJECT_MAPPER.readValue(((Text)value._2()).toString(), AtomicAction.class)).map((Function & Serializable)aa -> (Relation)aa.getPayload());
        tmp.foreach((VoidFunction & Serializable)r -> {
            Assertions.assertEquals((Object)false, (Object)r.getDataInfo().getInferred());
            Assertions.assertEquals((Object)false, (Object)r.getDataInfo().getDeletedbyinference());
            Assertions.assertEquals((Object)"0.91", (Object)r.getDataInfo().getTrust());
            Assertions.assertEquals((Object)"sysimport:crosswalk:opencitations", (Object)r.getDataInfo().getProvenanceaction().getClassid());
            Assertions.assertEquals((Object)"Imported from OpenCitations", (Object)r.getDataInfo().getProvenanceaction().getClassname());
            Assertions.assertEquals((Object)"dnet:provenanceActions", (Object)r.getDataInfo().getProvenanceaction().getSchemeid());
            Assertions.assertEquals((Object)"dnet:provenanceActions", (Object)r.getDataInfo().getProvenanceaction().getSchemename());
        });
    }

    @Test
    void testRelationsSemantics() throws Exception {
        String inputPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/opencitations/COCI").getPath();
        eu.dnetlib.dhp.actionmanager.opencitations.CreateActionSetSparkJob.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-inputPath", inputPath, "-outputPath", workingDir.toString() + "/actionSet5"});
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD tmp = sc.sequenceFile(workingDir.toString() + "/actionSet5", Text.class, Text.class).map((Function & Serializable)value -> (AtomicAction)OBJECT_MAPPER.readValue(((Text)value._2()).toString(), AtomicAction.class)).map((Function & Serializable)aa -> (Relation)aa.getPayload());
        tmp.foreach((VoidFunction & Serializable)r -> {
            Assertions.assertEquals((Object)"citation", (Object)r.getSubRelType());
            Assertions.assertEquals((Object)"resultResult", (Object)r.getRelType());
        });
        Assertions.assertEquals((long)23L, (long)tmp.filter((Function & Serializable)r -> r.getRelClass().equals("Cites")).count());
        Assertions.assertEquals((long)0L, (long)tmp.filter((Function & Serializable)r -> r.getRelClass().equals("IsCitedBy")).count());
    }

    @Test
    void testRelationsSourceTargetPrefix() throws Exception {
        String inputPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/opencitations/COCI").getPath();
        eu.dnetlib.dhp.actionmanager.opencitations.CreateActionSetSparkJob.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-inputPath", inputPath, "-outputPath", workingDir.toString() + "/actionSet6"});
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD tmp = sc.sequenceFile(workingDir.toString() + "/actionSet6", Text.class, Text.class).map((Function & Serializable)value -> (AtomicAction)OBJECT_MAPPER.readValue(((Text)value._2()).toString(), AtomicAction.class)).map((Function & Serializable)aa -> (Relation)aa.getPayload());
        tmp.foreach((VoidFunction & Serializable)r -> {
            Assertions.assertEquals((Object)"50|doi_________::", (Object)r.getSource().substring(0, 17));
            Assertions.assertEquals((Object)"50|doi_________::", (Object)r.getTarget().substring(0, 17));
        });
    }

    @Test
    void testRelationsSourceTargetCouple() throws Exception {
        String doi1 = "50|doi_________::" + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)"doi", (String)"10.1007/s10854-015-3684-x"));
        String doi2 = "50|doi_________::" + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)"doi", (String)"10.1111/j.1551-2916.2008.02408.x"));
        String doi3 = "50|doi_________::" + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)"doi", (String)"10.1007/s10854-014-2114-9"));
        String doi4 = "50|doi_________::" + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)"doi", (String)"10.1016/j.ceramint.2013.09.069"));
        String doi5 = "50|doi_________::" + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)"doi", (String)"10.1007/s10854-009-9913-4"));
        String doi6 = "50|doi_________::" + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)"doi", (String)"10.1016/0038-1098(72)90370-5"));
        String inputPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/opencitations/COCI").getPath();
        eu.dnetlib.dhp.actionmanager.opencitations.CreateActionSetSparkJob.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-inputPath", inputPath, "-outputPath", workingDir.toString() + "/actionSet7"});
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD tmp = sc.sequenceFile(workingDir.toString() + "/actionSet7", Text.class, Text.class).map((Function & Serializable)value -> (AtomicAction)OBJECT_MAPPER.readValue(((Text)value._2()).toString(), AtomicAction.class)).map((Function & Serializable)aa -> (Relation)aa.getPayload());
        JavaRDD check = tmp.filter((Function & Serializable)r -> r.getSource().equals(doi1) || r.getTarget().equals(doi1));
        Assertions.assertEquals((long)5L, (long)check.count());
        Assertions.assertEquals((long)5L, (long)check.filter((Function & Serializable)r -> r.getSource().equals(doi1)).count());
        check.filter((Function & Serializable)r -> r.getSource().equals(doi1)).foreach((VoidFunction & Serializable)r -> Assertions.assertEquals((Object)"Cites", (Object)r.getRelClass()));
    }

    static {
        log = LoggerFactory.getLogger(CreateOpenCitationsASTest.class);
    }
}

