/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.dblp;

import java.io.InputStream;
import java.util.Iterator;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBLPParser
implements Iterator<String> {
    private final XMLStreamReader reader;
    private final Logger logger = LoggerFactory.getLogger(DBLPParser.class);
    String currentElement = null;
    StringBuilder currentElementContent = new StringBuilder();
    String nextData = null;

    public DBLPParser(InputStream gzipStream) throws Exception {
        XMLInputFactory xif = XMLInputFactory.newFactory();
        xif.setProperty("com.ctc.wstx.maxEntityCount", 50000000);
        xif.setXMLResolver((s, s1, s2, s3) -> {
            if (s1.contains("dblp.dtd")) {
                return this.getClass().getResourceAsStream("dblp.dtd");
            }
            return null;
        });
        this.reader = xif.createXMLStreamReader(gzipStream);
        this.nextData = this.nextElement();
    }

    private String nextElement() {
        try {
            if (!this.reader.hasNext()) {
                return null;
            }
            while (this.reader.hasNext()) {
                int event = this.reader.next();
                switch (event) {
                    case 1: {
                        if (this.reader.getLocalName().equalsIgnoreCase("dblp")) break;
                        if (this.currentElement == null) {
                            this.currentElement = this.reader.getLocalName();
                        }
                        this.extractRootNode(this.reader, this.currentElementContent);
                        break;
                    }
                    case 4: {
                        if (this.reader.getText().isEmpty()) break;
                        this.currentElementContent.append(StringEscapeUtils.escapeXml11((String)this.reader.getText()));
                        break;
                    }
                    case 2: {
                        this.currentElementContent.append("</" + this.reader.getLocalName() + ">");
                        if (!this.reader.getLocalName().equalsIgnoreCase(this.currentElement)) break;
                        String data = this.currentElementContent.toString();
                        this.currentElement = null;
                        this.currentElementContent.delete(0, this.currentElementContent.length());
                        return data;
                    }
                }
            }
        }
        catch (Throwable e) {
            this.logger.error(this.currentElement);
            this.logger.error(this.currentElementContent.toString());
            this.logger.error("Error parsing XML {}", (Object)e.getMessage());
            throw new RuntimeException(e);
        }
        return null;
    }

    public void extractRootNode(XMLStreamReader reader, StringBuilder currentElementContent) {
        currentElementContent.append("<").append(reader.getLocalName());
        int attributeCount = reader.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            String attributeName = reader.getAttributeLocalName(i);
            String attributeValue = reader.getAttributeValue(i);
            currentElementContent.append(" ").append(attributeName).append("=\"").append(attributeValue).append("\"");
        }
        currentElementContent.append(">");
    }

    @Override
    public boolean hasNext() {
        return this.nextData != null;
    }

    @Override
    public String next() {
        String data = this.nextData;
        this.nextData = this.nextElement();
        return data;
    }
}

