/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.createunresolvedentities;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.createunresolvedentities.PrepareFOSSparkJob;
import eu.dnetlib.dhp.actionmanager.createunresolvedentities.PrepareSDGSparkJob;
import eu.dnetlib.dhp.actionmanager.createunresolvedentities.ProduceTest;
import eu.dnetlib.dhp.schema.oaf.Result;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareTest {
    private static final Logger log = LoggerFactory.getLogger(ProduceTest.class);
    private static Path workingDir;
    private static SparkSession spark;
    private static LocalFileSystem fs;
    private static final ObjectMapper OBJECT_MAPPER;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(PrepareTest.class.getSimpleName(), new FileAttribute[0]);
        fs = FileSystem.getLocal((Configuration)new Configuration());
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(ProduceTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(PrepareTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void fosPrepareTest() throws Exception {
        String sourcePath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/createunresolvedentities/fos/fos.json").getPath();
        PrepareFOSSparkJob.main((String[])new String[]{"--isSparkSessionManaged", Boolean.FALSE.toString(), "--sourcePath", sourcePath, "-outputPath", workingDir.toString() + "/work"});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/work/fos").map((Function & Serializable)item -> (Result)OBJECT_MAPPER.readValue(item, Result.class));
        String doi1 = "unresolved::10.3390/s18072310::doi";
        Assertions.assertEquals((long)20L, (long)tmp.count());
        Assertions.assertEquals((long)1L, (long)tmp.filter((Function & Serializable)row -> row.getId().equals(doi1)).count());
        Assertions.assertTrue((boolean)tmp.filter((Function & Serializable)r -> r.getId().equals(doi1)).flatMap((FlatMapFunction & Serializable)r -> r.getSubject().iterator()).map((Function & Serializable)sbj -> sbj.getValue()).collect().contains("04 agricultural and veterinary sciences"));
        Assertions.assertTrue((boolean)tmp.filter((Function & Serializable)r -> r.getId().equals(doi1)).flatMap((FlatMapFunction & Serializable)r -> r.getSubject().iterator()).map((Function & Serializable)sbj -> sbj.getValue()).collect().contains("0404 agricultural biotechnology"));
        String doi = "unresolved::10.1007/s11164-020-04383-6::doi";
        Assertions.assertEquals((long)1L, (long)tmp.filter((Function & Serializable)row -> row.getId().equals(doi)).count());
        Assertions.assertTrue((boolean)tmp.filter((Function & Serializable)r -> r.getId().equals(doi)).flatMap((FlatMapFunction & Serializable)r -> r.getSubject().iterator()).map((Function & Serializable)sbj -> sbj.getValue()).collect().contains("01 natural sciences"));
        Assertions.assertTrue((boolean)tmp.filter((Function & Serializable)r -> r.getId().equals(doi)).flatMap((FlatMapFunction & Serializable)r -> r.getSubject().iterator()).map((Function & Serializable)sbj -> sbj.getValue()).collect().contains("0104 chemical sciences"));
        Assertions.assertTrue((boolean)tmp.filter((Function & Serializable)r -> r.getId().equals(doi)).flatMap((FlatMapFunction & Serializable)r -> r.getSubject().iterator()).map((Function & Serializable)sbj -> sbj.getValue()).collect().contains("010402 general chemistry"));
    }

    @Test
    void fosPrepareTest2() throws Exception {
        String sourcePath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/createunresolvedentities/fos/fos_sbs_2.json").getPath();
        PrepareFOSSparkJob.main((String[])new String[]{"--isSparkSessionManaged", Boolean.FALSE.toString(), "--sourcePath", sourcePath, "-outputPath", workingDir.toString() + "/work"});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/work/fos").map((Function & Serializable)item -> (Result)OBJECT_MAPPER.readValue(item, Result.class));
        String doi1 = "unresolved::10.1016/j.revmed.2006.07.012::doi";
        Assertions.assertEquals((long)13L, (long)tmp.count());
        Assertions.assertEquals((long)1L, (long)tmp.filter((Function & Serializable)row -> row.getId().equals(doi1)).count());
        Result result = (Result)tmp.filter((Function & Serializable)r -> r.getId().equals(doi1)).first();
        result.getSubject().forEach(s -> System.out.println(s.getValue() + " trust = " + s.getDataInfo().getTrust()));
        Assertions.assertEquals((int)6, (int)result.getSubject().size());
        Assertions.assertTrue((boolean)result.getSubject().stream().anyMatch(s -> s.getValue().contains("03 medical and health sciences") && s.getDataInfo().getTrust().equals("")));
        Assertions.assertTrue((boolean)result.getSubject().stream().anyMatch(s -> s.getValue().contains("0302 clinical medicine") && s.getDataInfo().getTrust().equals("")));
        Assertions.assertTrue((boolean)result.getSubject().stream().anyMatch(s -> s.getValue().contains("030204 cardiovascular system & hematology") && s.getDataInfo().getTrust().equals("0.5101401805877686")));
        Assertions.assertTrue((boolean)result.getSubject().stream().anyMatch(s -> s.getValue().contains("03020409 Hematology/Coagulopathies") && s.getDataInfo().getTrust().equals("0.0546871414174914")));
    }

    @Test
    void sdgPrepareTest() throws Exception {
        String sourcePath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/createunresolvedentities/sdg/sdg.json").getPath();
        PrepareSDGSparkJob.main((String[])new String[]{"--isSparkSessionManaged", Boolean.FALSE.toString(), "--sourcePath", sourcePath, "-outputPath", workingDir.toString() + "/work"});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/work/sdg").map((Function & Serializable)item -> (Result)OBJECT_MAPPER.readValue(item, Result.class));
        String doi1 = "unresolved::10.1001/amaguidesnewsletters.2019.sepoct02::doi";
        Assertions.assertEquals((long)32L, (long)tmp.count());
        Assertions.assertEquals((long)1L, (long)tmp.filter((Function & Serializable)row -> row.getId().equals(doi1)).count());
        Assertions.assertTrue((boolean)tmp.filter((Function & Serializable)r -> r.getId().equals(doi1)).flatMap((FlatMapFunction & Serializable)r -> r.getSubject().iterator()).map((Function & Serializable)sbj -> sbj.getValue()).collect().contains("3. Good health"));
        Assertions.assertTrue((boolean)tmp.filter((Function & Serializable)r -> r.getId().equals(doi1)).flatMap((FlatMapFunction & Serializable)r -> r.getSubject().iterator()).map((Function & Serializable)sbj -> sbj.getValue()).collect().contains("8. Economic growth"));
        Assertions.assertEquals((long)32L, (long)tmp.filter((Function & Serializable)row -> row.getDataInfo() != null).count());
    }

    static {
        OBJECT_MAPPER = new ObjectMapper();
    }
}

