/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.project;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.project.utils.model.CSVProgramme;
import eu.dnetlib.dhp.common.collection.GetCSV;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class ReadProgrammeTest {
    private static String workingDir;
    private static LocalFileSystem fs;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(ReadProgrammeTest.class.getSimpleName(), new FileAttribute[0]).toString();
        fs = FileSystem.getLocal((Configuration)new Configuration());
    }

    @AfterAll
    public static void cleanup() {
        FileUtils.deleteQuietly((File)new File(workingDir));
    }

    @Test
    void getLocalProgrammeFileTest() throws Exception {
        String line;
        GetCSV.getCsv((FileSystem)fs, (Reader)new BufferedReader(new FileReader(this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/project/h2020_programme.csv").getPath())), (String)(workingDir + "/programme"), (String)CSVProgramme.class.getName(), (char)';');
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fs.open(new Path(workingDir + "/programme"))));
        int count = 0;
        ObjectMapper OBJECT_MAPPER = new ObjectMapper();
        while ((line = in.readLine()) != null) {
            CSVProgramme csvp = (CSVProgramme)OBJECT_MAPPER.readValue(line, CSVProgramme.class);
            if (count == 528) {
                Assertions.assertEquals((Object)"H2020-EU.5.f.", (Object)csvp.getCode());
                Assertions.assertTrue((boolean)csvp.getTitle().startsWith("Develop the governance for the advancement of responsible research and innovation by all stakeholders"));
                Assertions.assertTrue((boolean)csvp.getTitle().endsWith("promote an ethics framework for research and innovation"));
                Assertions.assertTrue((boolean)csvp.getShortTitle().equals(""));
                Assertions.assertTrue((boolean)csvp.getLanguage().equals("en"));
            }
            if (count == 11) {
                Assertions.assertEquals((Object)"H2020-EU.3.5.4.", (Object)csvp.getCode());
                Assertions.assertTrue((boolean)csvp.getTitle().equals("Grundlagen f\u00fcr den \u00dcbergang zu einer umweltfreundlichen Wirtschaft und Gesellschaft durch \u00d6ko-Innovation"));
                Assertions.assertTrue((boolean)csvp.getShortTitle().equals("A green economy and society through eco-innovation"));
                Assertions.assertTrue((boolean)csvp.getLanguage().equals("de"));
            }
            if (count == 34) {
                Assertions.assertTrue((boolean)csvp.getCode().equals("H2020-EU.3.2."));
                Assertions.assertTrue((boolean)csvp.getTitle().equals("SOCIETAL CHALLENGES - Food security, sustainable agriculture and forestry, marine, maritime and inland water research, and the bioeconomy"));
                Assertions.assertTrue((boolean)csvp.getShortTitle().equals("Food, agriculture, forestry, marine research and bioeconomy"));
                Assertions.assertTrue((boolean)csvp.getLanguage().equals("en"));
            }
            Assertions.assertTrue((csvp.getCode() != null ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)csvp.getCode().startsWith("H2020"));
            ++count;
        }
        Assertions.assertEquals((int)769, (int)count);
    }
}

