/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.collection.ApiDescriptor;
import eu.dnetlib.dhp.common.collection.HttpClientParams;
import eu.dnetlib.dhp.schema.mdstore.MDStoreVersion;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
@ExtendWith(value={MockitoExtension.class})
public class CollectionWorkflowTest {
    private static final Logger log = LoggerFactory.getLogger(CollectionWorkflowTest.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static Path workingDir;
    private static DistributedFileSystem fileSystem;
    private static ApiDescriptor api;
    private static String mdStoreVersion;
    private static final String encoding = "XML";
    private static final String dateOfCollection;
    private static final String xpath = "//*[local-name()='header']/*[local-name()='identifier']";
    private static String provenance;
    private static final String msgMgrUrl = "http://localhost:%s/mock/mvc/dhp/message";

    @BeforeAll
    protected static void beforeAll() throws Exception {
        provenance = IOUtils.toString((InputStream)CollectionWorkflowTest.class.getResourceAsStream("/eu/dnetlib/dhp/collection/provenance.json"));
        workingDir = Files.createTempDirectory(CollectionWorkflowTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
    }

    @AfterAll
    protected static void tearDown() {
    }

    public void testCollectorWorkerApplication() throws Exception {
        HttpClientParams httpClientParams = new HttpClientParams();
    }

    public static MDStoreVersion prepareVersion(String filename) throws IOException {
        MDStoreVersion mdstore = (MDStoreVersion)OBJECT_MAPPER.readValue(IOUtils.toString((URL)CollectionWorkflowTest.class.getResource(filename)), MDStoreVersion.class);
        mdstore.setHdfsPath(String.format(mdstore.getHdfsPath(), workingDir.toString()));
        return mdstore;
    }

    static {
        dateOfCollection = System.currentTimeMillis() + "";
    }
}

