/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.file;

import eu.dnetlib.dhp.collection.ApiDescriptor;
import eu.dnetlib.dhp.collection.plugin.file.FileGZipCollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.file.FileGZipCollectorPluginTest;
import eu.dnetlib.dhp.common.aggregation.AggregatorReport;
import eu.dnetlib.dhp.common.collection.CollectorException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
@ExtendWith(value={MockitoExtension.class})
public class FileGZipMultipleNodeTest {
    private static final Logger log = LoggerFactory.getLogger(FileGZipCollectorPluginTest.class);
    private final ApiDescriptor api = new ApiDescriptor();
    private FileGZipCollectorPlugin plugin;
    private static final String SPLIT_ON_ELEMENT = "incollection,article";

    @BeforeEach
    public void setUp() throws IOException {
        String gzipFile = Objects.requireNonNull(this.getClass().getResource("/eu/dnetlib/dhp/collection/plugin/file/dblp.gz")).getFile();
        this.api.setBaseUrl(gzipFile);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("splitOnElement", SPLIT_ON_ELEMENT);
        this.api.setParams(params);
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        this.plugin = new FileGZipCollectorPlugin(fs);
    }

    @Test
    void test() throws CollectorException {
        Stream stream = this.plugin.collect(this.api, new AggregatorReport());
        stream.limit(10L).forEach(s -> {
            Assertions.assertTrue((s.length() > 0 ? 1 : 0) != 0);
            log.info(s);
        });
    }
}

