/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.transformation;

import eu.dnetlib.dhp.aggregation.AbstractVocabularyTest;
import eu.dnetlib.dhp.aggregation.common.AggregationCounter;
import eu.dnetlib.dhp.schema.mdstore.MetadataRecord;
import eu.dnetlib.dhp.schema.mdstore.Provenance;
import eu.dnetlib.dhp.transformation.TransformSparkJobNode;
import eu.dnetlib.dhp.transformation.xslt.DateCleaner;
import eu.dnetlib.dhp.transformation.xslt.XSLTTransformationFunction;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FilterFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.util.LongAccumulator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class TransformationJobTest
extends AbstractVocabularyTest {
    private SparkConf sparkConf;

    TransformationJobTest() {
    }

    @BeforeEach
    public void setUp() throws IOException, ISLookUpException {
        this.setUpVocabulary();
        this.sparkConf = new SparkConf();
        this.sparkConf.setMaster("local[*]");
        this.sparkConf.set("spark.driver.host", "localhost");
        this.sparkConf.set("spark.ui.enabled", "false");
    }

    @Test
    @DisplayName(value="Test Date cleaner")
    void testDateCleaner() throws Exception {
        DateCleaner dc = new DateCleaner();
        Assertions.assertEquals((Object)"1982-09-20", (Object)dc.clean("20/09/1982"));
        Assertions.assertEquals((Object)"2002-09-20", (Object)dc.clean("20-09-2002"));
        Assertions.assertEquals((Object)"2002-09-20", (Object)dc.clean("2002-09-20"));
        Assertions.assertEquals((Object)"2002-09-01", (Object)dc.clean("2002-9"));
        Assertions.assertEquals((Object)"2021-01-01", (Object)dc.clean("2021"));
    }

    @Test
    @DisplayName(value="Test Transform Single XML using zenodo_tr XSLTTransformator")
    void testTransformSaxonHE() throws Exception {
        MetadataRecord mr = new MetadataRecord();
        mr.setProvenance(new Provenance("DSID", "DSNAME", "PREFIX"));
        mr.setBody(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/transform/input_zenodo.xml")));
        XSLTTransformationFunction tr = this.loadTransformationRule("/eu/dnetlib/dhp/transform/zenodo_tr.xslt");
        MetadataRecord result = tr.call(mr);
        System.out.println(result.getBody());
    }

    @Test
    @DisplayName(value="Test Transform Inst.&Them.v4 record XML with zenodo_tr")
    void testTransformITGv4Zenodo() throws Exception {
        MetadataRecord mr = new MetadataRecord();
        mr.setProvenance(new Provenance("DSID", "DSNAME", "PREFIX"));
        mr.setBody(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/transform/input_itgv4.xml")));
        XSLTTransformationFunction tr = this.loadTransformationRule("/eu/dnetlib/dhp/transform/zenodo_tr.xslt");
        MetadataRecord result = tr.call(mr);
        System.out.println(result.getBody());
    }

    @Test
    @DisplayName(value="Test Transform record XML with xslt_cleaning_datarepo_datacite/oaiOpenAIRE")
    void testTransformMostlyUsedScript() throws Exception {
        String xslTransformationScript = "";
        xslTransformationScript = "/eu/dnetlib/dhp/transform/scripts/xslt_cleaning_datarepo_datacite.xsl";
        xslTransformationScript = "/eu/dnetlib/dhp/transform/scripts/xslt_cleaning_oaiOpenaire_datacite_ExchangeLandingpagePid.xsl";
        MetadataRecord mr = new MetadataRecord();
        mr.setProvenance(new Provenance("DSID", "DSNAME", "PREFIX"));
        mr.setBody(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/transform/input_itgv4.xml")));
        XSLTTransformationFunction tr = this.loadTransformationRule(xslTransformationScript);
        MetadataRecord result = tr.call(mr);
        System.out.println(result.getBody());
    }

    @Test
    @DisplayName(value="Test Transform record XML with xslt_cleaning_REST_OmicsDI")
    void testTransformRestScript() throws Exception {
        String xslTransformationScript = "";
        xslTransformationScript = "/eu/dnetlib/dhp/transform/scripts/xslt_cleaning_REST_OmicsDI.xsl";
        MetadataRecord mr = new MetadataRecord();
        mr.setProvenance(new Provenance("DSID", "DSNAME", "PREFIX"));
        mr.setBody(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/transform/input_omicsdi.xml")));
        XSLTTransformationFunction tr = this.loadTransformationRule(xslTransformationScript);
        MetadataRecord result = tr.call(mr);
        System.out.println(result.getBody());
    }

    @Test
    @DisplayName(value="Test TransformSparkJobNode.main with oaiOpenaire_datacite (v4)")
    void transformTestITGv4OAIdatacite(@TempDir Path testDir) throws Exception {
        try (SparkSession spark = SparkSession.builder().config(this.sparkConf).getOrCreate();){
            String mdstore_input = this.getClass().getResource("/eu/dnetlib/dhp/transform/mdstorenative").getFile();
            String mdstore_output = testDir.toString() + "/version";
            this.mockupTrasformationRule("simpleTRule", "/eu/dnetlib/dhp/transform/scripts/xslt_cleaning_oaiOpenaire_datacite_ExchangeLandingpagePid.xsl");
            Map<String, String> parameters = Stream.of({"dateOfTransformation", "1234"}, {"varOfficialName", "Publications at Bielefeld University"}, {"varOfficialId", "opendoar____::2294"}, {"transformationPlugin", "XSLT_TRANSFORM"}, {"transformationRuleId", "simpleTRule"}).collect(Collectors.toMap(data -> data[0], data -> data[1]));
            TransformSparkJobNode.transformRecords(parameters, (ISLookUpService)this.isLookUpService, (SparkSession)spark, (String)mdstore_input, (String)mdstore_output, (Integer)200);
            Encoder encoder = Encoders.bean(MetadataRecord.class);
            Dataset mOutput = spark.read().format("parquet").load(mdstore_output + "/store").as(encoder);
            Long total = mOutput.count();
            long recordTs = mOutput.filter((FilterFunction & Serializable)p -> p.getDateOfTransformation() == 1234L).count();
            long recordNotEmpty = mOutput.filter((FilterFunction & Serializable)p -> !StringUtils.isBlank((CharSequence)p.getBody())).count();
            Assertions.assertEquals((Long)total, (long)recordTs);
            Assertions.assertEquals((Long)total, (long)recordNotEmpty);
        }
    }

    @Test
    @DisplayName(value="Test TransformSparkJobNode.main")
    void transformTest(@TempDir Path testDir) throws Exception {
        try (SparkSession spark = SparkSession.builder().config(this.sparkConf).getOrCreate();){
            String mdstore_input = this.getClass().getResource("/eu/dnetlib/dhp/transform/mdstorenative").getFile();
            String mdstore_output = testDir.toString() + "/version";
            this.mockupTrasformationRule("simpleTRule", "/eu/dnetlib/dhp/transform/ext_simple.xsl");
            Map<String, String> parameters = Stream.of({"dateOfTransformation", "1234"}, {"transformationPlugin", "XSLT_TRANSFORM"}, {"transformationRuleId", "simpleTRule"}).collect(Collectors.toMap(data -> data[0], data -> data[1]));
            TransformSparkJobNode.transformRecords(parameters, (ISLookUpService)this.isLookUpService, (SparkSession)spark, (String)mdstore_input, (String)mdstore_output, (Integer)200);
            Encoder encoder = Encoders.bean(MetadataRecord.class);
            Dataset mOutput = spark.read().format("parquet").load(mdstore_output + "/store").as(encoder);
            Long total = mOutput.count();
            long recordTs = mOutput.filter((FilterFunction & Serializable)p -> p.getDateOfTransformation() == 1234L).count();
            long recordNotEmpty = mOutput.filter((FilterFunction & Serializable)p -> !StringUtils.isBlank((CharSequence)p.getBody())).count();
            Assertions.assertEquals((Long)total, (long)recordTs);
            Assertions.assertEquals((Long)total, (long)recordNotEmpty);
        }
    }

    @Test
    @DisplayName(value="Test Transform Single XML using cnr_explora_tr XSLTTransformator")
    void testCnrExploraTransformSaxonHE() throws Exception {
        MetadataRecord mr = new MetadataRecord();
        mr.setProvenance(new Provenance("openaire____::cnr_explora", "CNR ExploRA", "cnr_________"));
        mr.setBody(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/transform/input_cnr_explora.xml")));
        XSLTTransformationFunction tr = this.loadTransformationRule("/eu/dnetlib/dhp/transform/cnr_explora_tr.xslt");
        MetadataRecord result = tr.call(mr);
        System.out.println(result.getBody());
    }

    @Test
    public void testInvalidXSLT() throws Exception {
        MetadataRecord mr = new MetadataRecord();
        mr.setProvenance(new Provenance("openaire____::cnr_explora", "CNR ExploRA", "cnr_________"));
        mr.setBody(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/transform/input_cnr_explora.xml")));
        XSLTTransformationFunction tr = this.loadTransformationRule("/eu/dnetlib/dhp/transform/invalid.xslt");
        Assertions.assertThrows(RuntimeException.class, () -> tr.call(mr));
    }

    private XSLTTransformationFunction loadTransformationRule(String path) throws Exception {
        String trValue = IOUtils.toString((InputStream)this.getClass().getResourceAsStream(path));
        LongAccumulator la = new LongAccumulator();
        return new XSLTTransformationFunction(new AggregationCounter(la, la, la), trValue, 0L, this.vocabularies);
    }
}

