/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.opencitations;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.opencitations.model.COCI;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.action.AtomicAction;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.utils.IdentifierFactory;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import eu.dnetlib.dhp.schema.oaf.utils.PidCleaner;
import eu.dnetlib.dhp.schema.oaf.utils.PidType;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class CreateActionSetSparkJob
implements Serializable {
    public static final String OPENCITATIONS_CLASSID = "sysimport:crosswalk:opencitations";
    public static final String OPENCITATIONS_CLASSNAME = "Imported from OpenCitations";
    private static final String DOI_PREFIX = "50|doi_________::";
    private static final String PMID_PREFIX = "50|pmid________::";
    private static final String ARXIV_PREFIX = "50|arXiv_______::";
    private static final String PMCID_PREFIX = "50|pmcid_______::";
    private static final String TRUST = "0.91";
    private static final Logger log = LoggerFactory.getLogger(CreateActionSetSparkJob.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static void main(String[] args) throws IOException, ParseException {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)Objects.requireNonNull(CreateActionSetSparkJob.class.getResourceAsStream("/eu/dnetlib/dhp/actionmanager/opencitations/as_parameters.json"))));
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Optional.ofNullable(parser.get("isSparkSessionManaged")).map(Boolean::valueOf).orElse(Boolean.TRUE);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String inputPath = parser.get("inputPath");
        log.info("inputPath {}", (Object)inputPath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath {}", (Object)outputPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> CreateActionSetSparkJob.extractContent(spark, inputPath, outputPath));
    }

    private static void extractContent(SparkSession spark, String inputPath, String outputPath) {
        CreateActionSetSparkJob.getTextTextJavaPairRDD(spark, inputPath).saveAsHadoopFile(outputPath, Text.class, Text.class, SequenceFileOutputFormat.class, GzipCodec.class);
    }

    private static JavaPairRDD<Text, Text> getTextTextJavaPairRDD(SparkSession spark, String inputPath) {
        return spark.read().textFile(inputPath).map((MapFunction & Serializable)value -> (COCI)OBJECT_MAPPER.readValue(value, COCI.class), Encoders.bean(COCI.class)).flatMap((FlatMapFunction & Serializable)value -> CreateActionSetSparkJob.createRelation(value).iterator(), Encoders.bean(Relation.class)).filter(Objects::nonNull).toJavaRDD().map((Function & Serializable)p -> new AtomicAction(p.getClass(), (Oaf)p)).mapToPair((PairFunction & Serializable)aa -> new Tuple2((Object)new Text(aa.getClazz().getCanonicalName()), (Object)new Text(OBJECT_MAPPER.writeValueAsString(aa))));
    }

    private static List<Relation> createRelation(COCI value) throws JsonProcessingException {
        String cited;
        String citing;
        ArrayList<Relation> relationList = new ArrayList<Relation>();
        switch (value.getCiting_pid()) {
            case "doi": {
                citing = DOI_PREFIX + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)PidType.doi.toString(), (String)value.getCiting()));
                break;
            }
            case "pmid": {
                citing = PMID_PREFIX + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)PidType.pmid.toString(), (String)value.getCiting()));
                break;
            }
            case "arxiv": {
                citing = ARXIV_PREFIX + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)PidType.arXiv.toString(), (String)value.getCiting()));
                break;
            }
            case "pmcid": {
                citing = PMCID_PREFIX + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)PidType.pmc.toString(), (String)value.getCiting()));
                break;
            }
            case "isbn": 
            case "issn": {
                return relationList;
            }
            default: {
                throw new IllegalStateException("Invalid prefix: " + new ObjectMapper().writeValueAsString((Object)value));
            }
        }
        switch (value.getCited_pid()) {
            case "doi": {
                cited = DOI_PREFIX + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)PidType.doi.toString(), (String)value.getCited()));
                break;
            }
            case "pmid": {
                cited = PMID_PREFIX + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)PidType.pmid.toString(), (String)value.getCited()));
                break;
            }
            case "arxiv": {
                cited = ARXIV_PREFIX + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)PidType.arXiv.toString(), (String)value.getCited()));
                break;
            }
            case "pmcid": {
                cited = PMCID_PREFIX + IdentifierFactory.md5((String)PidCleaner.normalizePidValue((String)PidType.pmc.toString(), (String)value.getCited()));
                break;
            }
            case "isbn": 
            case "issn": {
                return relationList;
            }
            default: {
                throw new IllegalStateException("Invalid prefix: " + new ObjectMapper().writeValueAsString((Object)value));
            }
        }
        if (!citing.equals(cited)) {
            relationList.add(CreateActionSetSparkJob.getRelation(citing, cited, "Cites"));
        }
        return relationList;
    }

    public static Relation getRelation(String source, String target, String relClass) {
        return OafMapperUtils.getRelation((String)source, (String)target, (String)"resultResult", (String)"citation", (String)relClass, Arrays.asList(OafMapperUtils.keyValue((String)"10|openaire____::c06df618c5de1c786535ccf3f8b7b059", (String)"OpenCitations")), (DataInfo)OafMapperUtils.dataInfo((Boolean)false, null, (Boolean)false, (Boolean)false, (Qualifier)OafMapperUtils.qualifier((String)OPENCITATIONS_CLASSID, (String)OPENCITATIONS_CLASSNAME, (String)"dnet:provenanceActions", (String)"dnet:provenanceActions"), (String)TRUST), null);
    }
}

