/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.project;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.project.SparkAtomicActionJob;
import eu.dnetlib.dhp.schema.action.AtomicAction;
import eu.dnetlib.dhp.schema.oaf.Project;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.io.Text;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkUpdateProjectTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final ClassLoader cl = SparkUpdateProjectTest.class.getClassLoader();
    private static SparkSession spark;
    private static Path workingDir;
    private static final Logger log;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(SparkUpdateProjectTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(SparkUpdateProjectTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(SparkUpdateProjectTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void numberDistinctProgrammeTest() throws Exception {
        SparkAtomicActionJob.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-programmePath", this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/project/prepared_h2020_programme.json.gz").getPath(), "-projectPath", this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/project/prepared_projects.json.gz").getPath(), "-topicPath", this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/project/topics_nld.json.gz").getPath(), "-outputPath", workingDir.toString() + "/actionSet"});
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD tmp = sc.sequenceFile(workingDir.toString() + "/actionSet", Text.class, Text.class).map((Function & Serializable)value -> (AtomicAction)OBJECT_MAPPER.readValue(((Text)value._2()).toString(), AtomicAction.class)).map((Function & Serializable)aa -> (Project)aa.getPayload());
        Assertions.assertEquals((long)15L, (long)tmp.count());
        Dataset verificationDataset = spark.createDataset(tmp.rdd(), Encoders.bean(Project.class));
        verificationDataset.createOrReplaceTempView("project");
        Dataset execverification = spark.sql("SELECT id, class classification, h2020topiccode, h2020topicdescription FROM project LATERAL VIEW EXPLODE(h2020classification) c as class ");
        Assertions.assertEquals((Object)"H2020-EU.3.4.7.", (Object)((Row)execverification.filter("id = '40|corda__h2020::2c7298913008865ba784e5c1350a0aa5'").select("classification.h2020Programme.code", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"SESAR JU", (Object)((Row)execverification.filter("id = '40|corda__h2020::2c7298913008865ba784e5c1350a0aa5'").select("classification.h2020Programme.description", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"Societal Challenges", (Object)((Row)execverification.filter("id = '40|corda__h2020::2c7298913008865ba784e5c1350a0aa5'").select("classification.level1", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"Transport", (Object)((Row)execverification.filter("id = '40|corda__h2020::2c7298913008865ba784e5c1350a0aa5'").select("classification.level2", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"SESAR JU", (Object)((Row)execverification.filter("id = '40|corda__h2020::2c7298913008865ba784e5c1350a0aa5'").select("classification.level3", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"Societal challenges | Smart, Green And Integrated Transport | SESAR JU", (Object)((Row)execverification.filter("id = '40|corda__h2020::2c7298913008865ba784e5c1350a0aa5'").select("classification.classification", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"SESAR-ER4-31-2019", (Object)((Row)execverification.filter("id = '40|corda__h2020::2c7298913008865ba784e5c1350a0aa5'").select("h2020topiccode", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"U-space", (Object)((Row)execverification.filter("id = '40|corda__h2020::2c7298913008865ba784e5c1350a0aa5'").select("h2020topicdescription", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"H2020-EU.1.3.2.", (Object)((Row)execverification.filter("id = '40|corda__h2020::1a1f235fdd06ef14790baec159aa1202'").select("classification.h2020Programme.code", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"MSCA Mobility", (Object)((Row)execverification.filter("id = '40|corda__h2020::1a1f235fdd06ef14790baec159aa1202'").select("classification.h2020Programme.description", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"Excellent Science", (Object)((Row)execverification.filter("id = '40|corda__h2020::1a1f235fdd06ef14790baec159aa1202'").select("classification.level1", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"Marie-Sklodowska-Curie Actions", (Object)((Row)execverification.filter("id = '40|corda__h2020::1a1f235fdd06ef14790baec159aa1202'").select("classification.level2", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"MSCA Mobility", (Object)((Row)execverification.filter("id = '40|corda__h2020::1a1f235fdd06ef14790baec159aa1202'").select("classification.level3", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"Excellent science | Marie Sk\u0142odowska-Curie Actions | Nurturing excellence by means of cross-border and cross-sector mobility", (Object)((Row)execverification.filter("id = '40|corda__h2020::1a1f235fdd06ef14790baec159aa1202'").select("classification.classification", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"MSCA-IF-2019", (Object)((Row)execverification.filter("id = '40|corda__h2020::1a1f235fdd06ef14790baec159aa1202'").select("h2020topiccode", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"Individual Fellowships", (Object)((Row)execverification.filter("id = '40|corda__h2020::1a1f235fdd06ef14790baec159aa1202'").select("h2020topicdescription", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertTrue((((Row)execverification.filter("id = '40|corda__h2020::a657c271769fec90b60c1f2dbc25f4d5'").select("classification.h2020Programme.code", new String[0]).collectAsList().get(0)).getString(0).equals("H2020-EU.2.1.4.") || ((Row)execverification.filter("id = '40|corda__h2020::a657c271769fec90b60c1f2dbc25f4d5'").select("classification.h2020Programme.code", new String[0]).collectAsList().get(1)).getString(0).equals("H2020-EU.2.1.4.") ? 1 : 0) != 0);
        Assertions.assertTrue((((Row)execverification.filter("id = '40|corda__h2020::a657c271769fec90b60c1f2dbc25f4d5'").select("classification.h2020Programme.code", new String[0]).collectAsList().get(0)).getString(0).equals("H2020-EU.3.2.6.") || ((Row)execverification.filter("id = '40|corda__h2020::a657c271769fec90b60c1f2dbc25f4d5'").select("classification.h2020Programme.code", new String[0]).collectAsList().get(1)).getString(0).equals("H2020-EU.3.2.6.") ? 1 : 0) != 0);
        Assertions.assertEquals((Object)"Biotechnology", (Object)((Row)execverification.filter("id = '40|corda__h2020::a657c271769fec90b60c1f2dbc25f4d5' and classification.h2020Programme.code = 'H2020-EU.2.1.4.'").select("classification.h2020Programme.description", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"Bio-based Industries Joint Technology Initiative (BBI-JTI)", (Object)((Row)execverification.filter("id = '40|corda__h2020::a657c271769fec90b60c1f2dbc25f4d5' and classification.h2020Programme.code = 'H2020-EU.3.2.6.'").select("classification.h2020Programme.description", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"BBI-2019-SO3-D4", (Object)((Row)execverification.filter("id = '40|corda__h2020::a657c271769fec90b60c1f2dbc25f4d5'").select("h2020topiccode", new String[0]).collectAsList().get(0)).getString(0));
        Assertions.assertEquals((Object)"Demonstrate bio-based pesticides and/or biostimulant agents for sustainable increase in agricultural productivity", (Object)((Row)execverification.filter("id = '40|corda__h2020::a657c271769fec90b60c1f2dbc25f4d5'").select("h2020topicdescription", new String[0]).collectAsList().get(0)).getString(0));
    }

    static {
        log = LoggerFactory.getLogger(SparkUpdateProjectTest.class);
    }
}

