/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.webcrawl;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.webcrawl.RemoveRelationFromActionSet;
import eu.dnetlib.dhp.schema.action.AtomicAction;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.io.Text;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveFromASTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static SparkSession spark;
    private static Path workingDir;
    private static final Logger log;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(RemoveFromASTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(RemoveFromASTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(RemoveFromASTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void testNumberofRelations() throws Exception {
        String inputPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/webcrawl/actionSet/").getPath();
        String blackListPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/webcrawl/blackListRemove/").getPath();
        RemoveRelationFromActionSet.main((String[])new String[]{"-isSparkSessionManaged", Boolean.FALSE.toString(), "-sourcePath", inputPath, "-outputPath", workingDir.toString() + "/actionSet1", "-blackListPath", blackListPath});
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD tmp = sc.sequenceFile(workingDir.toString() + "/actionSet1", Text.class, Text.class).map((Function & Serializable)value -> (AtomicAction)OBJECT_MAPPER.readValue(((Text)value._2()).toString(), AtomicAction.class)).map((Function & Serializable)aa -> (Relation)aa.getPayload());
        Assertions.assertEquals((long)22L, (long)tmp.count());
    }

    static {
        log = LoggerFactory.getLogger(RemoveFromASTest.class);
    }
}

