/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.project;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.project.PrepareProjectTest;
import eu.dnetlib.dhp.actionmanager.project.utils.ReadTopics;
import eu.dnetlib.dhp.actionmanager.project.utils.model.JsonTopic;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadTopicTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static Path workingDir;
    private static LocalFileSystem fs;
    private static SparkSession spark;
    private static final Logger log;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(ReadTopicTest.class.getSimpleName(), new FileAttribute[0]);
        fs = FileSystem.getLocal((Configuration)new Configuration());
        SparkConf conf = new SparkConf();
        conf.setAppName(PrepareProjectTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(PrepareProjectTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Disabled
    @Test
    void readTopics() throws IOException {
        String topics = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/project/topics.json").getPath();
        ReadTopics.readTopics((String)topics, (String)(workingDir.toString() + "/topics"), (FileSystem)fs);
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/topics").map((Function & Serializable)item -> (JsonTopic)OBJECT_MAPPER.readValue(item, JsonTopic.class));
        JsonTopic topic = (JsonTopic)tmp.filter((Function & Serializable)t -> t.getProjectID().equals("886988")).first();
        Assertions.assertEquals((Object)"Individual Fellowships", (Object)topic.getTitle());
        Assertions.assertEquals((Object)"MSCA-IF-2019", (Object)topic.getTopic());
    }

    static {
        log = LoggerFactory.getLogger(ReadTopicTest.class);
    }
}

