/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.dblp;

import eu.dnetlib.dhp.collection.ApiDescriptor;
import eu.dnetlib.dhp.collection.plugin.dblp.DBLPCollectorPlugin;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

class DBLPCollectorPluginTest {
    private DBLPCollectorPlugin plugin;
    private ApiDescriptor api;
    private static final String baseURL = "/Users/miriam/Develop/python/dblp/dblp.xml.gz";

    DBLPCollectorPluginTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        LocalFileSystem fs = FileSystem.getLocal((Configuration)new Configuration());
        this.plugin = new DBLPCollectorPlugin((FileSystem)fs);
        this.api = new ApiDescriptor();
        this.api.setBaseUrl(baseURL);
        this.api.setProtocol("dblp");
    }

    @Test
    public void testOne() throws Exception {
        System.out.println("one publication");
        Iterator iterator = this.plugin.collect(this.api, null).iterator();
        if (iterator.hasNext()) {
            String res = (String)iterator.next();
            Assertions.assertNotNull((Object)res);
            System.out.println(res);
        }
    }

    @Test
    public void testCompleteHarvesting() throws Exception {
        System.out.println("testing complete harvesting");
        Iterator iterator = this.plugin.collect(this.api, null).iterator();
        int i = 0;
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter("/tmp/bdlpSplit.txt")));
        while (iterator.hasNext()) {
            String res = (String)iterator.next();
            pw.println(res);
            ++i;
        }
        System.out.println("Got " + i + " publications");
        Assertions.assertTrue((i > 0 ? 1 : 0) != 0);
    }

    @Test
    @Disabled
    public void testExtractXPaths() throws Exception {
        System.out.println("testExtractXPaths");
        LinkedHashSet set = new LinkedHashSet();
        this.plugin.collect(this.api, null).forEach(s -> {
            try {
                SAXReader reader = new SAXReader();
                Document doc = reader.read((Reader)new StringReader((String)s));
                for (Object o : doc.selectNodes("//*|//@*")) {
                    set.add(((Node)o).getPath());
                }
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
        });
        for (String s2 : set) {
            System.out.println("XPATH: " + s2);
        }
    }
}

