/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.datacite;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.datacite.CreatorType;
import eu.dnetlib.dhp.datacite.DataciteModelConstants$;
import eu.dnetlib.dhp.datacite.DataciteToOAFTransformation;
import eu.dnetlib.dhp.datacite.DateType;
import eu.dnetlib.dhp.datacite.DescriptionType;
import eu.dnetlib.dhp.datacite.OAFRelations;
import eu.dnetlib.dhp.datacite.RelatedIdentifierType;
import eu.dnetlib.dhp.datacite.SubjectType;
import eu.dnetlib.dhp.datacite.TitleType;
import eu.dnetlib.dhp.schema.action.AtomicAction;
import eu.dnetlib.dhp.schema.common.ModelConstants;
import eu.dnetlib.dhp.schema.oaf.AccessRight;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.InstanceTypeMapping;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.utils.IdentifierFactory;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.chrono.ThaiBuddhistDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.SomeValue$;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;

public final class DataciteToOAFTransformation$ {
    public static DataciteToOAFTransformation$ MODULE$;
    private final ObjectMapper mapper;
    private final DataciteToOAFTransformation.HostedByMapType unknown_repository;
    private final Map<String, DataciteToOAFTransformation.HostedByMapType> hostedByMap;

    static {
        new DataciteToOAFTransformation$();
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public DataciteToOAFTransformation.HostedByMapType unknown_repository() {
        return this.unknown_repository;
    }

    public Map<String, DataciteToOAFTransformation.HostedByMapType> hostedByMap() {
        return this.hostedByMap;
    }

    public boolean skip_record(String record, JsonAST.JValue json) {
        LazyRef formats$lzy = new LazyRef();
        return DataciteModelConstants$.MODULE$.datacite_filter().exists((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)record.contains(f))) || ((String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(json).$bslash$bslash("publisher")).extractOrElse((Function0 & Serializable & scala.Serializable)() -> "", (Formats)DataciteToOAFTransformation$.formats$2(formats$lzy), ManifestFactory$.MODULE$.classType(String.class))).equalsIgnoreCase("FAIRsharing");
    }

    public Tuple2<String, String> toActionSet(Oaf item) {
        ObjectMapper mapper = new ObjectMapper();
        Oaf oaf = item;
        if (oaf instanceof Dataset) {
            Dataset dataset = (Dataset)oaf;
            AtomicAction a = new AtomicAction();
            a.setClazz(Dataset.class);
            a.setPayload((Oaf)dataset);
            return new Tuple2((Object)dataset.getClass().getCanonicalName(), (Object)mapper.writeValueAsString((Object)a));
        }
        if (oaf instanceof Publication) {
            Publication publication = (Publication)oaf;
            AtomicAction a = new AtomicAction();
            a.setClazz(Publication.class);
            a.setPayload((Oaf)publication);
            return new Tuple2((Object)publication.getClass().getCanonicalName(), (Object)mapper.writeValueAsString((Object)a));
        }
        if (oaf instanceof Software) {
            Software software = (Software)oaf;
            AtomicAction a = new AtomicAction();
            a.setClazz(Software.class);
            a.setPayload((Oaf)software);
            return new Tuple2((Object)software.getClass().getCanonicalName(), (Object)mapper.writeValueAsString((Object)a));
        }
        if (oaf instanceof OtherResearchProduct) {
            OtherResearchProduct otherResearchProduct = (OtherResearchProduct)oaf;
            AtomicAction a = new AtomicAction();
            a.setClazz(OtherResearchProduct.class);
            a.setPayload((Oaf)otherResearchProduct);
            return new Tuple2((Object)otherResearchProduct.getClass().getCanonicalName(), (Object)mapper.writeValueAsString((Object)a));
        }
        if (oaf instanceof Relation) {
            Relation relation = (Relation)oaf;
            AtomicAction a = new AtomicAction();
            a.setClazz(Relation.class);
            a.setPayload((Oaf)relation);
            return new Tuple2((Object)relation.getClass().getCanonicalName(), (Object)mapper.writeValueAsString((Object)a));
        }
        return null;
    }

    public boolean embargo_end(String embargo_end_date) {
        LocalDate dt = LocalDate.parse(embargo_end_date, DateTimeFormatter.ofPattern("[yyyy-MM-dd]"));
        LocalDate td = LocalDate.now();
        return td.isAfter(dt);
    }

    public Option<String> extract_date(String input) {
        Option d = ((LinearSeqOptimized)DataciteModelConstants$.MODULE$.Date_regex().map((Function1 & Serializable & scala.Serializable)pattern -> {
            Matcher matcher = pattern.matcher(input);
            if (matcher.find()) {
                return matcher.group(0);
            }
            return null;
        }, List$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$extract_date$2(s)));
        if (d.isDefined()) {
            String a_date = ((String)d.get()).length() == 4 ? new StringBuilder(6).append("01-01-").append(d.get()).toString() : (String)d.get();
            try {
                return new Some((Object)LocalDate.parse(a_date, DataciteModelConstants$.MODULE$.df_en()).toString());
            }
            catch (Throwable throwable) {
                try {
                    return new Some((Object)LocalDate.parse(a_date, DataciteModelConstants$.MODULE$.df_it()).toString());
                }
                catch (Throwable throwable2) {
                    return None$.MODULE$;
                }
            }
        }
        return d;
    }

    public String fix_thai_date(String input, String format) {
        String string;
        try {
            LocalDate a_date = LocalDate.parse(input, DateTimeFormatter.ofPattern(format));
            ThaiBuddhistDate d = ThaiBuddhistDate.of(a_date.getYear(), a_date.getMonth().getValue(), a_date.getDayOfMonth());
            string = LocalDate.from(d).toString();
        }
        catch (Throwable throwable) {
            string = "";
        }
        return string;
    }

    public Tuple3<Qualifier, Qualifier, String> getTypeQualifier(String resourceType, String resourceTypeGeneral, String schemaOrg, VocabularyGroup vocabularies) {
        Qualifier typeQualifier;
        Qualifier typeQualifier2;
        Qualifier typeQualifier3;
        if (resourceType != null && new StringOps(Predef$.MODULE$.augmentString(resourceType)).nonEmpty() && (typeQualifier3 = vocabularies.getSynonymAsQualifier("dnet:publication_resource", resourceType)) != null) {
            return new Tuple3((Object)typeQualifier3, (Object)vocabularies.getSynonymAsQualifier("dnet:result_typologies", typeQualifier3.getClassid()), (Object)resourceType);
        }
        if (schemaOrg != null && new StringOps(Predef$.MODULE$.augmentString(schemaOrg)).nonEmpty() && (typeQualifier2 = vocabularies.getSynonymAsQualifier("dnet:publication_resource", schemaOrg)) != null) {
            return new Tuple3((Object)typeQualifier2, (Object)vocabularies.getSynonymAsQualifier("dnet:result_typologies", typeQualifier2.getClassid()), (Object)schemaOrg);
        }
        if (resourceTypeGeneral != null && new StringOps(Predef$.MODULE$.augmentString(resourceTypeGeneral)).nonEmpty() && (typeQualifier = vocabularies.getSynonymAsQualifier("dnet:publication_resource", resourceTypeGeneral)) != null) {
            return new Tuple3((Object)typeQualifier, (Object)vocabularies.getSynonymAsQualifier("dnet:result_typologies", typeQualifier.getClassid()), (Object)resourceTypeGeneral);
        }
        return null;
    }

    public Result getResult(String resourceType, String resourceTypeGeneral, String schemaOrg, VocabularyGroup vocabularies) {
        Tuple3<Qualifier, Qualifier, String> typeQualifiers = this.getTypeQualifier(resourceType, resourceTypeGeneral, schemaOrg, vocabularies);
        if (typeQualifiers == null) {
            return null;
        }
        Instance i = new Instance();
        i.setInstancetype((Qualifier)typeQualifiers._1());
        InstanceTypeMapping itm = new InstanceTypeMapping();
        itm.setOriginalType((String)typeQualifiers._3());
        itm.setVocabularyName("openaire::coar_resource_types_3_1");
        i.setInstanceTypeMapping((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)itm, (List)Nil$.MODULE$)).asJava());
        String string = ((Qualifier)typeQualifiers._2()).getClassname();
        if ("dataset".equals(string)) {
            Dataset r = new Dataset();
            r.setInstance((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)i, (List)Nil$.MODULE$)).asJava());
            return r;
        }
        if ("publication".equals(string)) {
            Publication r = new Publication();
            r.setInstance((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)i, (List)Nil$.MODULE$)).asJava());
            return r;
        }
        if ("software".equals(string)) {
            Software r = new Software();
            r.setInstance((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)i, (List)Nil$.MODULE$)).asJava());
            return r;
        }
        if ("other".equals(string)) {
            OtherResearchProduct r = new OtherResearchProduct();
            r.setInstance((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)i, (List)Nil$.MODULE$)).asJava());
            return r;
        }
        throw new MatchError((Object)string);
    }

    public boolean available_date(String input) {
        LazyRef formats$lzy = new LazyRef();
        LazyRef json$lzy = new LazyRef();
        List l = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(DataciteToOAFTransformation$.json$2(json$lzy, input)).$bslash$bslash("dates")).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$available_date$1(check$ifrefutable$1))).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
            JsonAST.JValue jValue = x$2;
            if (jValue instanceof JsonAST.JObject) {
                JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                List dates = jObject.obj();
                return (List)dates.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$available_date$3(check$ifrefutable$2))).map((Function1 & Serializable & scala.Serializable)x$1 -> {
                    Tuple2 tuple2 = x$1;
                    Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                    if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                        String string = (String)tuple22._1();
                        JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                        if ("dateType".equals(string) && jValue instanceof JsonAST.JString) {
                            JsonAST.JString jString = (JsonAST.JString)jValue;
                            String dateTypes = jString.s();
                            return dateTypes;
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }, List$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)jValue);
        });
        return l.exists((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)p.equalsIgnoreCase("available")));
    }

    public void fix_figshare(Result r) {
        if (r.getInstance() != null) {
            boolean hosted_by_figshare = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(r.getInstance()).asScala()).exists((Function1 & Serializable & scala.Serializable)i -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$fix_figshare$1(i)));
            if (hosted_by_figshare) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(r.getInstance()).asScala()).foreach((Function1 & Serializable & scala.Serializable)i -> {
                    i.setAccessright(ModelConstants.OPEN_ACCESS_RIGHT());
                    return BoxedUnit.UNIT;
                });
                Nil$ l = Nil$.MODULE$;
                r.setSubject((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)l).asJava());
                return;
            }
            return;
        }
    }

    public String createDNetTargetIdentifier(String pid, String pidType, String idPrefix) {
        String f_part = (String)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1).append(idPrefix).append("|").append(pidType.toLowerCase()).toString())).padTo(15, (Object)BoxesRunTime.boxToCharacter((char)'_'), Predef$.MODULE$.StringCanBuildFrom());
        return new StringBuilder(2).append(f_part).append("::").append(IdentifierFactory.md5((String)pid.toLowerCase())).toString();
    }

    public StructuredProperty generateOAFDate(String dt, Qualifier q) {
        return OafMapperUtils.structuredProperty((String)dt, (Qualifier)q, null);
    }

    public Relation generateRelation(String sourceId, String targetId, String relClass, KeyValue cf, DataInfo di) {
        Relation r = new Relation();
        r.setSource(sourceId);
        r.setTarget(targetId);
        r.setRelType("resultProject");
        r.setRelClass(relClass);
        r.setSubRelType("outcome");
        r.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)cf, (List)Nil$.MODULE$)).asJava());
        r.setDataInfo(di);
        return r;
    }

    public List<Relation> get_projectRelation(String awardUri, String sourceId) {
        Option match_pattern = DataciteModelConstants$.MODULE$.funder_regex().find((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$get_projectRelation$1(awardUri, s)));
        if (match_pattern.isDefined()) {
            Pattern m = (Pattern)((Tuple2)match_pattern.get())._1();
            String p = (String)((Tuple2)match_pattern.get())._2();
            String grantId = m.matcher(awardUri).replaceAll("$2");
            String targetId = new StringBuilder(0).append(p).append(DHPUtils.md5((String)grantId)).toString();
            return new .colon.colon((Object)this.generateRelation(sourceId, targetId, "isProducedBy", DataciteModelConstants$.MODULE$.DATACITE_COLLECTED_FROM(), DataciteModelConstants$.MODULE$.dataInfo()), (List)Nil$.MODULE$);
        }
        return Nil$.MODULE$;
    }

    public List<Oaf> generateOAF(String input, long ts, long dateOfCollection, VocabularyGroup vocabularies, boolean exportLinks) {
        AccessRight access_rights_qualifier;
        String language;
        LazyRef formats$lzy = new LazyRef();
        LazyRef json$lzy = new LazyRef();
        if (this.skip_record(input, DataciteToOAFTransformation$.json$3(json$lzy, input))) {
            return Nil$.MODULE$;
        }
        String resourceType = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(DataciteToOAFTransformation$.json$3(json$lzy, input)).$bslash("attributes")).$bslash("types")).$bslash("resourceType")).extractOrElse((Function0 & Serializable & scala.Serializable)() -> null, (Formats)DataciteToOAFTransformation$.formats$4(formats$lzy), ManifestFactory$.MODULE$.classType(String.class));
        String resourceTypeGeneral = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(DataciteToOAFTransformation$.json$3(json$lzy, input)).$bslash("attributes")).$bslash("types")).$bslash("resourceTypeGeneral")).extractOrElse((Function0 & Serializable & scala.Serializable)() -> null, (Formats)DataciteToOAFTransformation$.formats$4(formats$lzy), ManifestFactory$.MODULE$.classType(String.class));
        String schemaOrg = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(DataciteToOAFTransformation$.json$3(json$lzy, input)).$bslash("attributes")).$bslash("types")).$bslash("schemaOrg")).extractOrElse((Function0 & Serializable & scala.Serializable)() -> null, (Formats)DataciteToOAFTransformation$.formats$4(formats$lzy), ManifestFactory$.MODULE$.classType(String.class));
        String doi = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(DataciteToOAFTransformation$.json$3(json$lzy, input)).$bslash("attributes")).$bslash("doi")).extract((Formats)DataciteToOAFTransformation$.formats$4(formats$lzy), ManifestFactory$.MODULE$.classType(String.class));
        if (doi.isEmpty()) {
            return Nil$.MODULE$;
        }
        Result result = this.getResult(resourceType, resourceTypeGeneral, schemaOrg, vocabularies);
        if (result == null) {
            return Nil$.MODULE$;
        }
        Qualifier doi_q = OafMapperUtils.qualifier((String)"doi", (String)"doi", (String)"dnet:pid_types", (String)"dnet:pid_types");
        StructuredProperty pid = OafMapperUtils.structuredProperty((String)doi, (Qualifier)doi_q, (DataInfo)DataciteModelConstants$.MODULE$.dataInfo());
        result.setPid((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)pid, (List)Nil$.MODULE$)).asJava());
        result.setId(OafMapperUtils.createOpenaireId((int)50, (String)new StringBuilder(14).append("datacite____::").append(doi).toString(), (boolean)true));
        result.setOriginalId((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)doi, (List)Nil$.MODULE$)).asJava());
        Date d2 = new Date(dateOfCollection * 1000L);
        SimpleDateFormat ISO8601FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
        result.setDateofcollection(ISO8601FORMAT.format(d2));
        result.setDateoftransformation(ISO8601FORMAT.format(d2));
        result.setDataInfo(DataciteModelConstants$.MODULE$.dataInfo());
        List creators = (List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(DataciteToOAFTransformation$.json$3(json$lzy, input)).$bslash$bslash("creators")).extractOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$, (Formats)DataciteToOAFTransformation$.formats$4(formats$lzy), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(CreatorType.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        List authors = (List)((List)creators.zipWithIndex(List$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                CreatorType c = (CreatorType)tuple2._1();
                int idx = tuple2._2$mcI$sp();
                Author a = new Author();
                a.setFullname((String)c.name().orNull(Predef$.MODULE$.$conforms()));
                a.setName((String)c.givenName().orNull(Predef$.MODULE$.$conforms()));
                a.setSurname((String)c.familyName().orNull(Predef$.MODULE$.$conforms()));
                if (c.nameIdentifiers() != null && c.nameIdentifiers().isDefined() && c.nameIdentifiers().get() != null) {
                    a.setPid((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)c.nameIdentifiers().get()).map((Function1 & Serializable & scala.Serializable)ni -> {
                        Qualifier q;
                        Qualifier qualifier = q = ni.nameIdentifierScheme().isDefined() ? vocabularies.getTermAsQualifier("dnet:pid_types", ((String)ni.nameIdentifierScheme().get()).toLowerCase()) : null;
                        if (ni.nameIdentifier() != null && ni.nameIdentifier().isDefined()) {
                            return OafMapperUtils.structuredProperty((String)((String)ni.nameIdentifier().get()), (Qualifier)q, (DataInfo)DataciteModelConstants$.MODULE$.dataInfo());
                        }
                        return null;
                    }, List$.MODULE$.canBuildFrom())).asJava());
                }
                if (c.affiliation().isDefined()) {
                    a.setRawAffiliationString((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)c.affiliation().get()).filter((Function1 & Serializable & scala.Serializable)af -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateOAF$7(af)))).asJava());
                }
                a.setRank(Predef$.MODULE$.int2Integer(idx + 1));
                return a;
            }
            throw new MatchError((Object)tuple2);
        }, List$.MODULE$.canBuildFrom());
        if (authors == null || authors.isEmpty() || !authors.exists((Function1 & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateOAF$8(a)))) {
            return Nil$.MODULE$;
        }
        result.setAuthor((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)authors).asJava());
        List titles = (List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(DataciteToOAFTransformation$.json$3(json$lzy, input)).$bslash$bslash("titles")).extractOrElse((Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$, (Formats)DataciteToOAFTransformation$.formats$4(formats$lzy), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(TitleType.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        result.setTitle((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)titles.filter((Function1 & Serializable & scala.Serializable)t -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateOAF$10(t)))).map((Function1 & Serializable & scala.Serializable)t -> {
            if (t.titleType().isEmpty()) {
                return OafMapperUtils.structuredProperty((String)((String)t.title().get()), (Qualifier)ModelConstants.MAIN_TITLE_QUALIFIER, null);
            }
            return OafMapperUtils.structuredProperty((String)((String)t.title().get()), (String)((String)t.titleType().get()), (String)((String)t.titleType().get()), (String)"dnet:dataCite_title", (String)"dnet:dataCite_title", null);
        }, List$.MODULE$.canBuildFrom())).asJava());
        List dates = (List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(DataciteToOAFTransformation$.json$3(json$lzy, input)).$bslash$bslash("dates")).extract((Formats)DataciteToOAFTransformation$.formats$4(formats$lzy), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(DateType.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        String publication_year = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(DataciteToOAFTransformation$.json$3(json$lzy, input)).$bslash$bslash("publicationYear")).extractOrElse((Function0 & Serializable & scala.Serializable)() -> null, (Formats)DataciteToOAFTransformation$.formats$4(formats$lzy), ManifestFactory$.MODULE$.classType(String.class));
        Option i_date = ((LinearSeqOptimized)dates.filter((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateOAF$13(d)))).find((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateOAF$14(d))).map((Function1 & Serializable & scala.Serializable)d -> MODULE$.extract_date((String)d.date().get()));
        Option a_date = ((LinearSeqOptimized)((List)dates.filter((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateOAF$16(d)))).map((Function1 & Serializable & scala.Serializable)d -> MODULE$.extract_date((String)d.date().get()), List$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateOAF$18(d))).map((Function1 & Serializable & scala.Serializable)d -> (String)d.get());
        if (a_date.isDefined()) {
            if (doi.startsWith("10.14457")) {
                result.setEmbargoenddate(OafMapperUtils.field((Object)this.fix_thai_date((String)a_date.get(), "[yyyy-MM-dd]"), null));
            } else {
                result.setEmbargoenddate(OafMapperUtils.field((Object)a_date.get(), null));
            }
        }
        if (i_date.isDefined() && ((Option)i_date.get()).isDefined()) {
            if (doi.startsWith("10.14457")) {
                result.setDateofacceptance(OafMapperUtils.field((Object)this.fix_thai_date((String)((Option)i_date.get()).get(), "[yyyy-MM-dd]"), null));
                ((Instance)result.getInstance().get(0)).setDateofacceptance(OafMapperUtils.field((Object)this.fix_thai_date((String)((Option)i_date.get()).get(), "[yyyy-MM-dd]"), null));
            } else {
                result.setDateofacceptance(OafMapperUtils.field((Object)((Option)i_date.get()).get(), null));
                ((Instance)result.getInstance().get(0)).setDateofacceptance(OafMapperUtils.field((Object)((Option)i_date.get()).get(), null));
            }
        } else if (publication_year != null) {
            if (doi.startsWith("10.14457")) {
                result.setDateofacceptance(OafMapperUtils.field((Object)this.fix_thai_date(new StringBuilder(6).append("01-01-").append(publication_year).toString(), "[dd-MM-yyyy]"), null));
                ((Instance)result.getInstance().get(0)).setDateofacceptance(OafMapperUtils.field((Object)this.fix_thai_date(new StringBuilder(6).append("01-01-").append(publication_year).toString(), "[dd-MM-yyyy]"), null));
            } else {
                result.setDateofacceptance(OafMapperUtils.field((Object)new StringBuilder(6).append("01-01-").append(publication_year).toString(), null));
                ((Instance)result.getInstance().get(0)).setDateofacceptance(OafMapperUtils.field((Object)new StringBuilder(6).append("01-01-").append(publication_year).toString(), null));
            }
        }
        result.setRelevantdate((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)((TraversableLike)((List)((TraversableLike)((List)dates.filter((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateOAF$20(d)))).map((Function1 & Serializable & scala.Serializable)d -> new Tuple2(MODULE$.extract_date((String)d.date().get()), d.dateType().get()), List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateOAF$22(d)))).map((Function1 & Serializable & scala.Serializable)d -> new Tuple2(((Option)d._1()).get(), (Object)vocabularies.getTermAsQualifier("dnet:dataCite_date", ((String)d._2()).toLowerCase())), List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateOAF$24(d)))).map((Function1 & Serializable & scala.Serializable)d -> MODULE$.generateOAFDate((String)d._1(), (Qualifier)d._2()), List$.MODULE$.canBuildFrom())).asJava());
        List subjects = (List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(DataciteToOAFTransformation$.json$3(json$lzy, input)).$bslash$bslash("subjects")).extract((Formats)DataciteToOAFTransformation$.formats$4(formats$lzy), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(SubjectType.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        result.setSubject((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)subjects.filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateOAF$26(s)))).map((Function1 & Serializable & scala.Serializable)s -> OafMapperUtils.subject((String)((String)s.subject().get()), (String)DataciteModelConstants$.MODULE$.SUBJ_CLASS(), (String)DataciteModelConstants$.MODULE$.SUBJ_CLASS(), (String)"dnet:subject_classification_typologies", (String)"dnet:subject_classification_typologies", null), List$.MODULE$.canBuildFrom())).asJava());
        result.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)DataciteModelConstants$.MODULE$.DATACITE_COLLECTED_FROM(), (List)Nil$.MODULE$)).asJava());
        List descriptions = (List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(DataciteToOAFTransformation$.json$3(json$lzy, input)).$bslash$bslash("descriptions")).extract((Formats)DataciteToOAFTransformation$.formats$4(formats$lzy), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(DescriptionType.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        result.setDescription((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((List)descriptions.filter((Function1 & Serializable & scala.Serializable)d -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateOAF$28(d)))).map((Function1 & Serializable & scala.Serializable)d -> OafMapperUtils.field((Object)d.description().get(), null), List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateOAF$30(s)))).asJava());
        String publisher = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(DataciteToOAFTransformation$.json$3(json$lzy, input)).$bslash$bslash("publisher")).extractOrElse((Function0 & Serializable & scala.Serializable)() -> null, (Formats)DataciteToOAFTransformation$.formats$4(formats$lzy), ManifestFactory$.MODULE$.classType(String.class));
        if (publisher != null) {
            result.setPublisher(OafMapperUtils.field((Object)publisher, null));
        }
        if ((language = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(DataciteToOAFTransformation$.json$3(json$lzy, input)).$bslash$bslash("language")).extractOrElse((Function0 & Serializable & scala.Serializable)() -> null, (Formats)DataciteToOAFTransformation$.formats$4(formats$lzy), ManifestFactory$.MODULE$.classType(String.class))) != null) {
            result.setLanguage(vocabularies.getSynonymAsQualifier("dnet:languages", language));
        }
        Instance instance = (Instance)result.getInstance().get(0);
        Option client = package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(DataciteToOAFTransformation$.json$3(json$lzy, input)).$bslash("relationships")).$bslash("client")).$bslash$bslash("id")).extractOpt((Formats)DataciteToOAFTransformation$.formats$4(formats$lzy), ManifestFactory$.MODULE$.classType(String.class));
        List accessRights = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(DataciteToOAFTransformation$.json$3(json$lzy, input)).$bslash$bslash("rightsList")).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateOAF$33(check$ifrefutable$3))).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> {
            JsonAST.JValue jValue = x$4;
            if (jValue instanceof JsonAST.JObject) {
                JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                List rightsList = jObject.obj();
                return (List)rightsList.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateOAF$35(check$ifrefutable$4))).map((Function1 & Serializable & scala.Serializable)x$3 -> {
                    Tuple2 tuple2 = x$3;
                    Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                    if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                        String string = (String)tuple22._1();
                        JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                        if ("rightsUri".equals(string) && jValue instanceof JsonAST.JString) {
                            JsonAST.JString jString = (JsonAST.JString)jValue;
                            String rightsUri = jString.s();
                            return rightsUri;
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }, List$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)jValue);
        });
        Option aRights = ((LinearSeqOptimized)accessRights.map((Function1 & Serializable & scala.Serializable)r -> vocabularies.getSynonymAsQualifier("dnet:access_modes", r), List$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)q -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateOAF$38(q))).map((Function1 & Serializable & scala.Serializable)q -> {
            AccessRight a = new AccessRight();
            a.setClassid(q.getClassid());
            a.setClassname(q.getClassname());
            a.setSchemeid(q.getSchemeid());
            a.setSchemename(q.getSchemename());
            return a;
        });
        AccessRight accessRight = access_rights_qualifier = aRights.isDefined() ? (AccessRight)aRights.get() : OafMapperUtils.accessRight((String)"UNKNOWN", (String)"not available", (String)"dnet:access_modes", (String)"dnet:access_modes");
        if (client.isDefined()) {
            DataciteToOAFTransformation.HostedByMapType hb = (DataciteToOAFTransformation.HostedByMapType)this.hostedByMap().getOrElse((Object)((String)client.get()).toUpperCase(), (Function0 & Serializable & scala.Serializable)() -> MODULE$.unknown_repository());
            instance.setHostedby(OafMapperUtils.keyValue((String)this.generateDSId(hb.openaire_id()), (String)hb.official_name()));
            instance.setCollectedfrom(DataciteModelConstants$.MODULE$.DATACITE_COLLECTED_FROM());
            instance.setUrl((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)new StringBuilder(19).append("https://dx.doi.org/").append(doi).toString(), (List)Nil$.MODULE$)).asJava());
            instance.setAccessright(access_rights_qualifier);
            instance.setPid(result.getPid());
            Option license = accessRights.find((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateOAF$41(r)));
            if (license.isDefined()) {
                instance.setLicense(OafMapperUtils.field((Object)license.get(), null));
            }
        }
        List awardUris = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(DataciteToOAFTransformation$.json$3(json$lzy, input)).$bslash$bslash("fundingReferences")).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateOAF$42(check$ifrefutable$5))).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> {
            JsonAST.JValue jValue = x$6;
            if (jValue instanceof JsonAST.JObject) {
                JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                List fundingReferences = jObject.obj();
                return (List)fundingReferences.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$6 -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateOAF$44(check$ifrefutable$6))).map((Function1 & Serializable & scala.Serializable)x$5 -> {
                    Tuple2 tuple2 = x$5;
                    Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                    if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                        String string = (String)tuple22._1();
                        JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                        if ("awardUri".equals(string) && jValue instanceof JsonAST.JString) {
                            JsonAST.JString jString = (JsonAST.JString)jValue;
                            String awardUri = jString.s();
                            return awardUri;
                        }
                    }
                    throw new MatchError((Object)tuple2);
                }, List$.MODULE$.canBuildFrom());
            }
            throw new MatchError((Object)jValue);
        });
        String oid = result.getId();
        result.setId(IdentifierFactory.createIdentifier((OafEntity)result));
        if (!result.getId().equalsIgnoreCase(oid)) {
            String string = oid;
            result.setOriginalId((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)doi, (List)Nil$.MODULE$).$colon$colon((Object)string)).asJava());
        }
        List relations = (List)((TraversableLike)awardUris.flatMap((Function1 & Serializable & scala.Serializable)a -> MODULE$.get_projectRelation((String)a, result.getId()), List$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateOAF$47(r)));
        this.fix_figshare(result);
        if (result.getId() == null) {
            return Nil$.MODULE$;
        }
        if (exportLinks) {
            List rels = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(DataciteToOAFTransformation$.json$3(json$lzy, input)).$bslash$bslash("relatedIdentifiers")).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$7 -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateOAF$48(check$ifrefutable$7))).flatMap((Function1 & Serializable & scala.Serializable)x$11 -> {
                JsonAST.JValue jValue = x$11;
                if (jValue instanceof JsonAST.JObject) {
                    JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                    List relIdentifier = jObject.obj();
                    return (List)relIdentifier.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$8 -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateOAF$50(check$ifrefutable$8))).flatMap((Function1 & Serializable & scala.Serializable)x$10 -> {
                        Tuple2 tuple2 = x$10;
                        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                            String string = (String)tuple22._1();
                            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                            if ("relationType".equals(string) && jValue instanceof JsonAST.JString) {
                                JsonAST.JString jString = (JsonAST.JString)jValue;
                                String relationType = jString.s();
                                return (List)relIdentifier.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$9 -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateOAF$52(check$ifrefutable$9))).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> {
                                    Tuple2 tuple2 = x$9;
                                    Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                                    if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                                        String string = (String)tuple22._1();
                                        JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                                        if ("relatedIdentifierType".equals(string) && jValue instanceof JsonAST.JString) {
                                            JsonAST.JString jString = (JsonAST.JString)jValue;
                                            String relatedIdentifierType = jString.s();
                                            return (List)relIdentifier.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$10 -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateOAF$54(check$ifrefutable$10))).map((Function1 & Serializable & scala.Serializable)x$8 -> {
                                                Tuple2 tuple2 = x$8;
                                                Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
                                                    String string = (String)tuple22._1();
                                                    JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
                                                    if ("relatedIdentifier".equals(string) && jValue instanceof JsonAST.JString) {
                                                        JsonAST.JString jString = (JsonAST.JString)jValue;
                                                        String relatedIdentifier = jString.s();
                                                        return new RelatedIdentifierType(relationType, relatedIdentifier, relatedIdentifierType);
                                                    }
                                                }
                                                throw new MatchError((Object)tuple2);
                                            }, List$.MODULE$.canBuildFrom());
                                        }
                                    }
                                    throw new MatchError((Object)tuple2);
                                }, List$.MODULE$.canBuildFrom());
                            }
                        }
                        throw new MatchError((Object)tuple2);
                    }, List$.MODULE$.canBuildFrom());
                }
                throw new MatchError((Object)jValue);
            });
            List list = relations;
            relations = this.generateRelations((List<RelatedIdentifierType>)rels, result.getId(), i_date.isDefined() && ((Option)i_date.get()).isDefined() ? (String)((Option)i_date.get()).get() : null).$colon$colon$colon(list);
        }
        if (relations != null && relations.nonEmpty()) {
            .colon.colon colon2 = new .colon.colon((Object)result, (List)Nil$.MODULE$);
            return relations.$colon$colon$colon((List)colon2);
        }
        return new .colon.colon((Object)result, (List)Nil$.MODULE$);
    }

    private List<Relation> generateRelations(List<RelatedIdentifierType> rels, String id, String date) {
        List citationRels;
        List bidirectionalRels = (List)((List)rels.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateRelations$1(r)))).map((Function1 & Serializable & scala.Serializable)r -> {
            String subRelType = ((OAFRelations)DataciteModelConstants$.MODULE$.subRelTypeMapping().apply((Object)r.relationType())).relType();
            String target = DHPUtils.generateUnresolvedIdentifier((String)r.relatedIdentifier(), (String)r.relatedIdentifierType());
            return MODULE$.relation(id, target, subRelType, r.relationType(), date);
        }, List$.MODULE$.canBuildFrom());
        List list = citationRels = (List)((List)rels.filter((Function1 & Serializable & scala.Serializable)r -> BoxesRunTime.boxToBoolean((boolean)DataciteToOAFTransformation$.$anonfun$generateRelations$3(r)))).map((Function1 & Serializable & scala.Serializable)r -> {
            String string = r.relationType();
            if ("Cites".equals(string) ? true : "References".equals(string)) {
                String target = DHPUtils.generateUnresolvedIdentifier((String)r.relatedIdentifier(), (String)r.relatedIdentifierType());
                return MODULE$.relation(id, target, "citation", "Cites", date);
            }
            if ("IsCitedBy".equals(string) ? true : "IsReferencedBy".equals(string)) {
                String source = DHPUtils.generateUnresolvedIdentifier((String)r.relatedIdentifier(), (String)r.relatedIdentifierType());
                return MODULE$.relation(source, id, "citation", "Cites", date);
            }
            throw new MatchError((Object)string);
        }, List$.MODULE$.canBuildFrom());
        return bidirectionalRels.$colon$colon$colon(list);
    }

    public Relation relation(String source, String target, String subRelType, String relClass, String date) {
        Relation rel = new Relation();
        rel.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)DataciteModelConstants$.MODULE$.DATACITE_COLLECTED_FROM(), (List)Nil$.MODULE$)).asJava());
        rel.setDataInfo(DataciteModelConstants$.MODULE$.dataInfo());
        rel.setRelType(DataciteModelConstants$.MODULE$.REL_TYPE_VALUE());
        rel.setSubRelType(subRelType);
        rel.setRelClass(relClass);
        KeyValue dateProps = OafMapperUtils.keyValue((String)DataciteModelConstants$.MODULE$.DATE_RELATION_KEY(), (String)date);
        rel.setProperties((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)dateProps, (List)Nil$.MODULE$)).asJava());
        rel.setSource(source);
        rel.setTarget(target);
        rel.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)DataciteModelConstants$.MODULE$.DATACITE_COLLECTED_FROM(), (List)Nil$.MODULE$)).asJava());
        ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rel.getCollectedfrom()).asScala()).map((Function1 & Serializable & scala.Serializable)c -> c.getValue(), Buffer$.MODULE$.canBuildFrom())).toList();
        return rel;
    }

    public String generateDSId(String input) {
        String b = StringUtils.substringBefore((String)input, (String)"::");
        String a = StringUtils.substringAfter((String)input, (String)"::");
        return new StringBuilder(5).append("10|").append(b).append("::").append(DHPUtils.md5((String)a)).toString();
    }

    private static final /* synthetic */ DefaultFormats$ formats$lzycompute$1(LazyRef formats$lzy$1) {
        DefaultFormats$ defaultFormats$;
        LazyRef lazyRef = formats$lzy$1;
        synchronized (lazyRef) {
            defaultFormats$ = formats$lzy$1.initialized() ? (DefaultFormats$)formats$lzy$1.value() : (DefaultFormats$)formats$lzy$1.initialize((Object)DefaultFormats$.MODULE$);
        }
        return defaultFormats$;
    }

    private static final DefaultFormats$ formats$1(LazyRef formats$lzy$1) {
        if (formats$lzy$1.initialized()) {
            return (DefaultFormats$)formats$lzy$1.value();
        }
        return DataciteToOAFTransformation$.formats$lzycompute$1(formats$lzy$1);
    }

    private static final /* synthetic */ JsonAST.JValue json$lzycompute$1(LazyRef json$lzy$1, String s$1) {
        JsonAST.JValue jValue;
        LazyRef lazyRef = json$lzy$1;
        synchronized (lazyRef) {
            jValue = json$lzy$1.initialized() ? (JsonAST.JValue)json$lzy$1.value() : (JsonAST.JValue)json$lzy$1.initialize((Object)JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(s$1), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()));
        }
        return jValue;
    }

    private static final JsonAST.JValue json$1(LazyRef json$lzy$1, String s$1) {
        if (json$lzy$1.initialized()) {
            return (JsonAST.JValue)json$lzy$1.value();
        }
        return DataciteToOAFTransformation$.json$lzycompute$1(json$lzy$1, s$1);
    }

    private static final /* synthetic */ DefaultFormats$ formats$lzycompute$2(LazyRef formats$lzy$2) {
        DefaultFormats$ defaultFormats$;
        LazyRef lazyRef = formats$lzy$2;
        synchronized (lazyRef) {
            defaultFormats$ = formats$lzy$2.initialized() ? (DefaultFormats$)formats$lzy$2.value() : (DefaultFormats$)formats$lzy$2.initialize((Object)DefaultFormats$.MODULE$);
        }
        return defaultFormats$;
    }

    private static final DefaultFormats$ formats$2(LazyRef formats$lzy$2) {
        if (formats$lzy$2.initialized()) {
            return (DefaultFormats$)formats$lzy$2.value();
        }
        return DataciteToOAFTransformation$.formats$lzycompute$2(formats$lzy$2);
    }

    public static final /* synthetic */ boolean $anonfun$extract_date$2(String s) {
        return s != null;
    }

    private static final /* synthetic */ DefaultFormats$ formats$lzycompute$3(LazyRef formats$lzy$3) {
        DefaultFormats$ defaultFormats$;
        LazyRef lazyRef = formats$lzy$3;
        synchronized (lazyRef) {
            defaultFormats$ = formats$lzy$3.initialized() ? (DefaultFormats$)formats$lzy$3.value() : (DefaultFormats$)formats$lzy$3.initialize((Object)DefaultFormats$.MODULE$);
        }
        return defaultFormats$;
    }

    private static final DefaultFormats$ formats$3(LazyRef formats$lzy$3) {
        if (formats$lzy$3.initialized()) {
            return (DefaultFormats$)formats$lzy$3.value();
        }
        return DataciteToOAFTransformation$.formats$lzycompute$3(formats$lzy$3);
    }

    private static final /* synthetic */ JsonAST.JValue json$lzycompute$2(LazyRef json$lzy$2, String input$2) {
        JsonAST.JValue jValue;
        LazyRef lazyRef = json$lzy$2;
        synchronized (lazyRef) {
            jValue = json$lzy$2.initialized() ? (JsonAST.JValue)json$lzy$2.value() : (JsonAST.JValue)json$lzy$2.initialize((Object)JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(input$2), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()));
        }
        return jValue;
    }

    private static final JsonAST.JValue json$2(LazyRef json$lzy$2, String input$2) {
        if (json$lzy$2.initialized()) {
            return (JsonAST.JValue)json$lzy$2.value();
        }
        return DataciteToOAFTransformation$.json$lzycompute$2(json$lzy$2, input$2);
    }

    public static final /* synthetic */ boolean $anonfun$available_date$1(JsonAST.JValue check$ifrefutable$1) {
        JsonAST.JValue jValue = check$ifrefutable$1;
        return jValue instanceof JsonAST.JObject;
    }

    public static final /* synthetic */ boolean $anonfun$available_date$3(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("dateType".equals(string) && jValue instanceof JsonAST.JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$fix_figshare$1(Instance i) {
        return i.getHostedby() != null && "figshare".equalsIgnoreCase(i.getHostedby().getValue());
    }

    public static final /* synthetic */ boolean $anonfun$get_projectRelation$1(String awardUri$1, Tuple2 s) {
        return ((Pattern)s._1()).matcher(awardUri$1).find();
    }

    private static final /* synthetic */ DefaultFormats$ formats$lzycompute$4(LazyRef formats$lzy$4) {
        DefaultFormats$ defaultFormats$;
        LazyRef lazyRef = formats$lzy$4;
        synchronized (lazyRef) {
            defaultFormats$ = formats$lzy$4.initialized() ? (DefaultFormats$)formats$lzy$4.value() : (DefaultFormats$)formats$lzy$4.initialize((Object)DefaultFormats$.MODULE$);
        }
        return defaultFormats$;
    }

    private static final DefaultFormats$ formats$4(LazyRef formats$lzy$4) {
        if (formats$lzy$4.initialized()) {
            return (DefaultFormats$)formats$lzy$4.value();
        }
        return DataciteToOAFTransformation$.formats$lzycompute$4(formats$lzy$4);
    }

    private static final /* synthetic */ JsonAST.JValue json$lzycompute$3(LazyRef json$lzy$3, String input$3) {
        JsonAST.JValue jValue;
        LazyRef lazyRef = json$lzy$3;
        synchronized (lazyRef) {
            jValue = json$lzy$3.initialized() ? (JsonAST.JValue)json$lzy$3.value() : (JsonAST.JValue)json$lzy$3.initialize((Object)JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(input$3), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()));
        }
        return jValue;
    }

    private static final JsonAST.JValue json$3(LazyRef json$lzy$3, String input$3) {
        if (json$lzy$3.initialized()) {
            return (JsonAST.JValue)json$lzy$3.value();
        }
        return DataciteToOAFTransformation$.json$lzycompute$3(json$lzy$3, input$3);
    }

    public static final /* synthetic */ boolean $anonfun$generateOAF$7(String af) {
        return new StringOps(Predef$.MODULE$.augmentString(af)).nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$generateOAF$8(Author a) {
        return a != null;
    }

    public static final /* synthetic */ boolean $anonfun$generateOAF$10(TitleType t) {
        return t.title().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$generateOAF$13(DateType d) {
        return d.date().isDefined() && d.dateType().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$generateOAF$14(DateType d) {
        return ((String)d.dateType().get()).equalsIgnoreCase("issued");
    }

    public static final /* synthetic */ boolean $anonfun$generateOAF$16(DateType d) {
        return d.date().isDefined() && d.dateType().isDefined() && ((String)d.dateType().get()).equalsIgnoreCase("available");
    }

    public static final /* synthetic */ boolean $anonfun$generateOAF$18(Option d) {
        return d != null && d.isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$generateOAF$20(DateType d) {
        return d.date().isDefined() && d.dateType().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$generateOAF$22(Tuple2 d) {
        return ((Option)d._1()).isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$generateOAF$24(Tuple2 d) {
        return d._2() != null;
    }

    public static final /* synthetic */ boolean $anonfun$generateOAF$26(SubjectType s) {
        return s.subject().nonEmpty();
    }

    public static final /* synthetic */ boolean $anonfun$generateOAF$28(DescriptionType d) {
        return d.description().isDefined();
    }

    public static final /* synthetic */ boolean $anonfun$generateOAF$30(Field s) {
        return s != null;
    }

    public static final /* synthetic */ boolean $anonfun$generateOAF$33(JsonAST.JValue check$ifrefutable$3) {
        JsonAST.JValue jValue = check$ifrefutable$3;
        return jValue instanceof JsonAST.JObject;
    }

    public static final /* synthetic */ boolean $anonfun$generateOAF$35(Tuple2 check$ifrefutable$4) {
        Tuple2 tuple2 = check$ifrefutable$4;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("rightsUri".equals(string) && jValue instanceof JsonAST.JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$generateOAF$38(Qualifier q) {
        return q != null;
    }

    public static final /* synthetic */ boolean $anonfun$generateOAF$41(String r) {
        return r.startsWith("http") && r.matches(".*(/licenses|/publicdomain|unlicense\\.org/|/legal-and-data-protection-notices|/download/license|/open-government-licence).*");
    }

    public static final /* synthetic */ boolean $anonfun$generateOAF$42(JsonAST.JValue check$ifrefutable$5) {
        JsonAST.JValue jValue = check$ifrefutable$5;
        return jValue instanceof JsonAST.JObject;
    }

    public static final /* synthetic */ boolean $anonfun$generateOAF$44(Tuple2 check$ifrefutable$6) {
        Tuple2 tuple2 = check$ifrefutable$6;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("awardUri".equals(string) && jValue instanceof JsonAST.JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$generateOAF$47(Relation r) {
        return r != null;
    }

    public static final /* synthetic */ boolean $anonfun$generateOAF$48(JsonAST.JValue check$ifrefutable$7) {
        JsonAST.JValue jValue = check$ifrefutable$7;
        return jValue instanceof JsonAST.JObject;
    }

    public static final /* synthetic */ boolean $anonfun$generateOAF$50(Tuple2 check$ifrefutable$8) {
        Tuple2 tuple2 = check$ifrefutable$8;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("relationType".equals(string) && jValue instanceof JsonAST.JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$generateOAF$52(Tuple2 check$ifrefutable$9) {
        Tuple2 tuple2 = check$ifrefutable$9;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("relatedIdentifierType".equals(string) && jValue instanceof JsonAST.JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$generateOAF$54(Tuple2 check$ifrefutable$10) {
        Tuple2 tuple2 = check$ifrefutable$10;
        Tuple2 tuple22 = JsonAST.JField$.MODULE$.unapply(tuple2);
        if (!SomeValue$.MODULE$.isEmpty$extension((Object)tuple22)) {
            String string = (String)tuple22._1();
            JsonAST.JValue jValue = (JsonAST.JValue)tuple22._2();
            if ("relatedIdentifier".equals(string) && jValue instanceof JsonAST.JString) {
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean $anonfun$generateRelations$1(RelatedIdentifierType r) {
        return DataciteModelConstants$.MODULE$.subRelTypeMapping().contains((Object)r.relationType()) && (r.relatedIdentifierType().equalsIgnoreCase("doi") || r.relatedIdentifierType().equalsIgnoreCase("pmid") || r.relatedIdentifierType().equalsIgnoreCase("arxiv"));
    }

    public static final /* synthetic */ boolean $anonfun$generateRelations$3(RelatedIdentifierType r) {
        return !(!r.relatedIdentifierType().equalsIgnoreCase("doi") && !r.relatedIdentifierType().equalsIgnoreCase("pmid") && !r.relatedIdentifierType().equalsIgnoreCase("arxiv") || !r.relationType().toLowerCase().contains("cite") && !r.relationType().toLowerCase().contains("reference"));
    }

    private DataciteToOAFTransformation$() {
        MODULE$ = this;
        this.mapper = new ObjectMapper();
        this.unknown_repository = new DataciteToOAFTransformation.HostedByMapType("openaire____::1256f046-bf1f-4afc-8b47-d0b147148b18", ModelConstants.UNKNOWN_REPOSITORY.getValue(), ModelConstants.UNKNOWN_REPOSITORY.getValue(), (Option<Object>)new Some((Object)BoxesRunTime.boxToFloat((float)1.0f)));
        LazyRef formats$lzy = new LazyRef();
        LazyRef json$lzy = new LazyRef();
        String s = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("hostedBy_map.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        this.hostedByMap = (Map)package$.MODULE$.jvalue2extractable(DataciteToOAFTransformation$.json$1(json$lzy, s)).extract((Formats)DataciteToOAFTransformation$.formats$1(formats$lzy), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(DataciteToOAFTransformation.HostedByMapType.class)})));
    }
}

