/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.sftp;

import com.google.common.base.Splitter;
import com.google.common.collect.Sets;
import eu.dnetlib.dhp.collection.ApiDescriptor;
import eu.dnetlib.dhp.collection.plugin.CollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.sftp.AbstractSftpIterator;
import eu.dnetlib.dhp.collection.plugin.sftp.SftpIteratorWithAuthenticationKey;
import eu.dnetlib.dhp.collection.plugin.sftp.SftpIteratorWithPassword;
import eu.dnetlib.dhp.common.aggregation.AggregatorReport;
import eu.dnetlib.dhp.common.collection.CollectorException;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class SftpCollectorPlugin
implements CollectorPlugin {
    private static final int SFTP_PORT = 22;

    @Override
    public Stream<String> collect(ApiDescriptor api, AggregatorReport report) throws CollectorException {
        AbstractSftpIterator iter;
        String url = api.getBaseUrl();
        String username = Optional.ofNullable(api.getParams().get("username")).filter(StringUtils::isNotBlank).orElseThrow(() -> new CollectorException("Param 'username' is null or empty"));
        int port = Optional.ofNullable(api.getParams().get("port")).filter(StringUtils::isNotBlank).map(s -> NumberUtils.toInt((String)s, (int)22)).orElse(22);
        boolean recursive = Optional.ofNullable(api.getParams().get("recursive")).filter(StringUtils::isNotBlank).map(BooleanUtils::toBoolean).orElse(false);
        Set extensions = Optional.ofNullable(api.getParams().get("extensions")).filter(StringUtils::isNotBlank).map(s -> Sets.newHashSet((Iterable)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)s))).orElseThrow(() -> new CollectorException("Param 'extensions' is null or empty"));
        String fromDate = (String)api.getParams().get("fromDate");
        if (fromDate != null && !fromDate.matches("\\d{4}-\\d{2}-\\d{2}")) {
            throw new CollectorException("Invalid date (YYYY-MM-DD): " + fromDate);
        }
        String authMethod = (String)api.getParams().get("authMethod");
        String password = (String)api.getParams().get("password");
        String privateKeyPath = (String)api.getParams().get("privateKeyPath");
        if ("key".equalsIgnoreCase(authMethod) && StringUtils.isNotBlank((CharSequence)privateKeyPath)) {
            iter = new SftpIteratorWithAuthenticationKey(url, port, username, recursive, extensions, fromDate, privateKeyPath);
        } else if (!"key".equalsIgnoreCase(authMethod) && StringUtils.isNotBlank((CharSequence)password)) {
            iter = new SftpIteratorWithPassword(url, port, username, recursive, extensions, fromDate, password);
        } else {
            throw new CollectorException("Invalid authentication params, verify the parameters: authMethod, password and privateKeyPath");
        }
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iter, 16), false);
    }
}

