/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.utils;

import eu.dnetlib.dhp.collection.plugin.utils.JsonUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class JsonUtilsTest {
    JsonUtilsTest() {
    }

    private static String wrapped(String xml) {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?><recordWrap>" + xml + "</recordWrap>";
    }

    @Test
    void keyStartWithDigit() {
        Assertions.assertEquals((Object)JsonUtilsTest.wrapped("<m_100><n_200v>null</n_200v></m_100>"), (Object)JsonUtils.convertToXML((String)"{\"100\" : {\"200v\" : null}}"));
    }

    @Test
    void keyStartWithSpecialchars() {
        Assertions.assertEquals((Object)JsonUtilsTest.wrapped("<_parent><_nest1><_nest2>null</_nest2></_nest1></_parent>"), (Object)JsonUtils.convertToXML((String)"{\"   parent\" : {\"-nest1\" : {\".nest2\" : null}}}"));
    }

    @Test
    void encodeArray() {
        Assertions.assertEquals((Object)JsonUtilsTest.wrapped("<_parent.child>1</_parent.child><_parent.child>2</_parent.child>"), (Object)JsonUtils.convertToXML((String)"{\" parent.child\":[1, 2]}"));
    }

    @Test
    void arrayOfObjects() {
        Assertions.assertEquals((Object)JsonUtilsTest.wrapped("<parent><id>1</id></parent><parent><id>2</id></parent>"), (Object)JsonUtils.convertToXML((String)"{\"parent\": [{\"id\": 1}, {\"id\": 2}]}"));
    }

    @Test
    void removeControlCharacters() {
        Assertions.assertEquals((Object)JsonUtilsTest.wrapped("<m_100><n_200v>Test</n_200v></m_100>"), (Object)JsonUtils.convertToXML((String)"{\"100\" : {\"200v\" : \"\\u0000\\u000cTest\"}}"));
    }
}

