/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.fosnodoi;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.createunresolvedentities.PrepareFOSSparkJob;
import eu.dnetlib.dhp.schema.oaf.Result;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PrepareTest {
    private static final Logger log = LoggerFactory.getLogger(PrepareTest.class);
    private static Path workingDir;
    private static SparkSession spark;
    private static LocalFileSystem fs;
    private static final ObjectMapper OBJECT_MAPPER;

    @BeforeAll
    static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(PrepareTest.class.getSimpleName(), new FileAttribute[0]);
        fs = FileSystem.getLocal((Configuration)new Configuration());
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(PrepareTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(PrepareTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void fosPrepareTest() throws Exception {
        String sourcePath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/fosnodoi/fosnodoi.json").getPath();
        PrepareFOSSparkJob.main((String[])new String[]{"--isSparkSessionManaged", Boolean.FALSE.toString(), "--sourcePath", sourcePath, "--outputPath", workingDir.toString() + "/work"});
        JavaSparkContext sc = JavaSparkContext.fromSparkContext((SparkContext)spark.sparkContext());
        JavaRDD tmp = sc.textFile(workingDir.toString() + "/work/fos").map((Function & Serializable)item -> (Result)OBJECT_MAPPER.readValue(item, Result.class));
        tmp.foreach((VoidFunction & Serializable)t -> System.out.println(new ObjectMapper().writeValueAsString(t)));
    }

    static {
        OBJECT_MAPPER = new ObjectMapper();
    }
}

