/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.ror;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.ror.GenerateRorActionSetJob;
import eu.dnetlib.dhp.actionmanager.ror.model.RorOrganization;
import eu.dnetlib.dhp.schema.action.AtomicAction;
import eu.dnetlib.dhp.schema.oaf.Organization;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

class GenerateRorActionSetJobTest {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final String local_file_path = "/Users/michele/Downloads/ror-data-2021-04-06.json";

    GenerateRorActionSetJobTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
    }

    @Test
    void testConvertRorOrg() throws Exception {
        RorOrganization r = (RorOrganization)mapper.readValue(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("ror_org.json")), RorOrganization.class);
        List aas = GenerateRorActionSetJob.convertRorOrg((RorOrganization)r, (boolean)false);
        Assertions.assertEquals((int)1, (int)aas.size());
        Assertions.assertEquals(Organization.class, (Object)((AtomicAction)aas.get(0)).getClazz());
        Organization o = (Organization)((AtomicAction)aas.get(0)).getPayload();
        Assertions.assertNotNull((Object)o);
        Assertions.assertNotNull((Object)o.getCountry());
        Assertions.assertEquals((Object)"AU", (Object)o.getCountry().getClassid());
        Assertions.assertNotNull((Object)o.getLegalname());
        Assertions.assertEquals((Object)"Mount Stromlo Observatory", (Object)o.getLegalname().getValue());
        System.out.println(mapper.writeValueAsString((Object)o));
    }

    @Test
    void testConvertRorOrgWirthRels() throws Exception {
        RorOrganization r = (RorOrganization)mapper.readValue(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("ror_org.json")), RorOrganization.class);
        List aas = GenerateRorActionSetJob.convertRorOrg((RorOrganization)r, (boolean)true);
        Assertions.assertEquals((int)2, (int)aas.size());
        Assertions.assertEquals(Organization.class, (Object)((AtomicAction)aas.get(0)).getClazz());
        Assertions.assertEquals(Relation.class, (Object)((AtomicAction)aas.get(1)).getClazz());
        Organization o = (Organization)((AtomicAction)aas.get(0)).getPayload();
        Relation rel = (Relation)((AtomicAction)aas.get(1)).getPayload();
        Assertions.assertNotNull((Object)o);
        Assertions.assertNotNull((Object)rel);
        Assertions.assertEquals((Object)o.getId(), (Object)rel.getSource());
        Assertions.assertNotNull((Object)rel.getTarget());
        Assertions.assertEquals((Object)"IsParentOf", (Object)rel.getRelClass());
        Assertions.assertEquals((Object)"organizationOrganization", (Object)rel.getRelType());
        System.out.println(mapper.writeValueAsString((Object)rel));
    }

    @Test
    @Disabled
    void testConvertAllRorOrg() throws Exception {
        RorOrganization[] arr;
        for (RorOrganization r : arr = (RorOrganization[])mapper.readValue(IOUtils.toString((InputStream)new FileInputStream(local_file_path)), RorOrganization[].class)) {
            List aas = GenerateRorActionSetJob.convertRorOrg((RorOrganization)r, (boolean)false);
            Assertions.assertFalse((boolean)aas.isEmpty());
            Assertions.assertNotNull(aas.get(0));
            Organization o = (Organization)((AtomicAction)aas.get(0)).getPayload();
            Assertions.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)o.getId()));
        }
    }
}

