/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.file;

import eu.dnetlib.dhp.collection.ApiDescriptor;
import eu.dnetlib.dhp.collection.plugin.file.FileCollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.file.FileGZipCollectorPluginTest;
import eu.dnetlib.dhp.common.aggregation.AggregatorReport;
import eu.dnetlib.dhp.common.collection.CollectorException;
import java.io.IOException;
import java.util.HashMap;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCollectorPluginTest {
    private static final Logger log = LoggerFactory.getLogger(FileGZipCollectorPluginTest.class);
    private final ApiDescriptor api = new ApiDescriptor();
    private FileCollectorPlugin plugin;
    private static final String SPLIT_ON_ELEMENT = "repository";

    @BeforeEach
    public void setUp() throws IOException {
        String gzipFile = this.getClass().getResource("/eu/dnetlib/dhp/collection/plugin/file/opendoar.xml").getFile();
        this.api.setBaseUrl(gzipFile);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("splitOnElement", SPLIT_ON_ELEMENT);
        this.api.setParams(params);
        FileSystem fs = FileSystem.get((Configuration)new Configuration());
        this.plugin = new FileCollectorPlugin(fs);
    }

    @Test
    void test() throws CollectorException {
        Stream stream = this.plugin.collect(this.api, new AggregatorReport());
        stream.limit(10L).forEach(s -> {
            Assertions.assertTrue((s.length() > 0 ? 1 : 0) != 0);
            log.info(s);
        });
    }
}

