/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.utils;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;

public class JsonUtils {
    public static final String XML_WRAP_TAG = "recordWrap";
    private static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private static final String INVALID_XMLTAG_CHARS = "!\"#$%&'()*+,/;<=>?@[\\]^`{|}~,";
    private static final Log log = LogFactory.getLog(JsonUtils.class);

    public static JSONObject cleanJsonObject(JSONObject input) {
        if (null == input) {
            return null;
        }
        JSONObject result = new JSONObject();
        for (String key : input.keySet()) {
            Object value = input.opt(key);
            if (value == null) continue;
            result.put(JsonUtils.cleanKey(key), JsonUtils.cleanValue(value));
        }
        return result;
    }

    private static Object cleanValue(Object object) {
        if (object instanceof JSONObject) {
            return JsonUtils.cleanJsonObject((JSONObject)object);
        }
        if (object instanceof JSONArray) {
            JSONArray array = (JSONArray)object;
            JSONArray res = new JSONArray();
            for (int i = array.length() - 1; i >= 0; --i) {
                res.put(i, JsonUtils.cleanValue(array.opt(i)));
            }
            return res;
        }
        if (object instanceof String) {
            String value = (String)object;
            return value.codePoints().filter(cp -> cp == 9 || cp == 10 || cp == 13 || cp >= 32 && cp <= 55295 || cp >= 57344 && cp <= 65533 || cp >= 65536 && cp <= 0x10FFFF).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
        }
        return object;
    }

    private static String cleanKey(String key) {
        if (key == null || key.isEmpty()) {
            return key;
        }
        switch (key.charAt(0)) {
            case '-': 
            case '.': {
                key = "_" + key.substring(1);
            }
        }
        if (Character.isDigit(key.charAt(0))) {
            key = key.matches("^[0-9]+$") ? "m_" + key : "n_" + key;
        }
        StringBuilder res = new StringBuilder(key.length());
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (Character.isWhitespace(c)) {
                while (i + 1 < key.length() && Character.isWhitespace(key.charAt(i + 1))) {
                    ++i;
                }
                res.append('_');
                continue;
            }
            if (INVALID_XMLTAG_CHARS.indexOf(c) >= 0) {
                switch (c) {
                    case '=': {
                        res.append('-');
                        break;
                    }
                    case '/': {
                        res.append('_');
                        break;
                    }
                }
                continue;
            }
            res.append(c);
        }
        return res.toString();
    }

    public static String convertToXML(String jsonRecord) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("input json: " + jsonRecord));
        }
        JSONObject jsonObject = JsonUtils.cleanJsonObject(new JSONObject(jsonRecord));
        String res = XML_HEADER + XML.toString((Object)jsonObject, (String)XML_WRAP_TAG);
        if (log.isTraceEnabled()) {
            log.trace((Object)("outout xml: " + res));
        }
        return res;
    }
}

