/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.crossref;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.aggregation.AbstractVocabularyTest;
import eu.dnetlib.dhp.collection.crossref.Crossref2Oaf;
import eu.dnetlib.dhp.collection.crossref.Crossref2Oaf$;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Publication;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;

@ExtendWith(value={MockitoExtension.class})
@ScalaSignature(bytes="\u0006\u0001\u00194A!\u0001\u0002\u0001\u001b\t\u00192I]8tgJ,g-T1qa&tw\rV3ti*\u00111\u0001B\u0001\tGJ|7o\u001d:fM*\u0011QAB\u0001\u000bG>dG.Z2uS>t'BA\u0004\t\u0003\r!\u0007\u000e\u001d\u0006\u0003\u0013)\tq\u0001\u001a8fi2L'MC\u0001\f\u0003\t)Wo\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0013\u001b\u0005\u0001\"BA\t\u0007\u0003-\twm\u001a:fO\u0006$\u0018n\u001c8\n\u0005M\u0001\"AF!cgR\u0014\u0018m\u0019;W_\u000e\f'-\u001e7bef$Vm\u001d;\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001b\u0002\u000e\u0001\u0005\u0004%\taG\u0001\u0007Y><w-\u001a:\u0016\u0003q\u0001\"!\b\u0012\u000e\u0003yQ!a\b\u0011\u0002\u000bMdg\r\u000e6\u000b\u0003\u0005\n1a\u001c:h\u0013\t\u0019cD\u0001\u0004M_\u001e<WM\u001d\u0005\u0007K\u0001\u0001\u000b\u0011\u0002\u000f\u0002\u000f1|wmZ3sA!9q\u0005\u0001b\u0001\n\u0003A\u0013AB7baB,'/F\u0001*!\tQ3'D\u0001,\u0015\taS&\u0001\u0005eCR\f'-\u001b8e\u0015\tqs&A\u0004kC\u000e\\7o\u001c8\u000b\u0005A\n\u0014!\u00034bgR,'\u000f_7m\u0015\u0005\u0011\u0014aA2p[&\u0011Ag\u000b\u0002\r\u001f\nTWm\u0019;NCB\u0004XM\u001d\u0005\u0007m\u0001\u0001\u000b\u0011B\u0015\u0002\u000f5\f\u0007\u000f]3sA!)\u0001\b\u0001C\u0001s\u0005)1/\u001a;VaR\t!\b\u0005\u0002<}5\tAHC\u0001>\u0003\u0015\u00198-\u00197b\u0013\tyDH\u0001\u0003V]&$\bFA\u001cB!\t\u0011\u0015*D\u0001D\u0015\t!U)A\u0002ba&T!AR$\u0002\u000f),\b/\u001b;fe*\u0011\u0001\nI\u0001\u0006UVt\u0017\u000e^\u0005\u0003\u0015\u000e\u0013!BQ3g_J,W)Y2i\u0011\u0015a\u0005\u0001\"\u0001:\u00035i\u0017\r\u001d9j]\u001e\u0014VmY8sI\"\u00121J\u0014\t\u0003\u0005>K!\u0001U\"\u0003\tQ+7\u000f\u001e\u0005\u0006%\u0002!\t!O\u0001\u0013[\u0006\u0004\b/\u001b8h\u0003\u001a4\u0017\u000e\\5bi&|g\u000e\u000b\u0002R\u001d\"\"\u0001!V.]!\t1\u0016,D\u0001X\u0015\tA6)A\u0005fqR,gn]5p]&\u0011!l\u0016\u0002\u000b\u000bb$XM\u001c3XSRD\u0017!\u0002<bYV,G&A/$\u0003y\u0003\"a\u00183\u000e\u0003\u0001T!AR1\u000b\u0005!\u0013'BA2!\u0003\u001diwnY6ji>L!!\u001a1\u0003!5{7m[5u_\u0016CH/\u001a8tS>t\u0007")
public class CrossrefMappingTest
extends AbstractVocabularyTest {
    private final Logger logger = LoggerFactory.getLogger(Crossref2Oaf$.MODULE$.getClass());
    private final ObjectMapper mapper = new ObjectMapper();

    public Logger logger() {
        return this.logger;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    @BeforeEach
    public void setUp() {
        super.setUpVocabulary();
    }

    @Test
    public void mappingRecord() {
        String input = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/collection/crossref/issn_pub.json"), (String)"utf-8");
        Crossref2Oaf$.MODULE$.convert(input, this.vocabularies, Crossref2Oaf.TransformationType$.MODULE$.All()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ CrossrefMappingTest $outer;

            public final void apply(Oaf record) {
                Assertions.assertNotNull((Object)record);
                Predef$.MODULE$.println((Object)this.$outer.mapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)record));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void mappingAffiliation() {
        String input = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/collection/crossref/affiliationTest.json"), (String)"utf-8");
        List data = Crossref2Oaf$.MODULE$.convert(input, this.vocabularies, Crossref2Oaf.TransformationType$.MODULE$.OnlyResult());
        data.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Oaf record) {
                Assertions.assertNotNull((Object)record);
                Assertions.assertTrue((boolean)(record instanceof Publication));
                Publication publication = (Publication)record;
                ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(publication.getAuthor()).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Author author) {
                        Assertions.assertNotNull((Object)author.getRawAffiliationString());
                        Assertions.assertTrue((author.getRawAffiliationString().size() > 0 ? 1 : 0) != 0);
                    }
                });
            }
        });
        Predef$.MODULE$.println((Object)this.mapper().writerWithDefaultPrettyPrinter().writeValueAsString(data.head()));
    }
}

