/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.crossref;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.collection.DecompressTarGz;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;

public class ExtractCrossrefRecords {
    public static void main(String[] args) throws Exception {
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)ExtractCrossrefRecords.class.getResourceAsStream("/eu/dnetlib/dhp/collection/crossref_dump_reader/crossref_dump_reader.json")));
        parser.parseArgument(args);
        String hdfsServerUri = parser.get("hdfsServerUri");
        String workingPath = hdfsServerUri.concat(parser.get("workingPath"));
        String outputPath = parser.get("outputPath");
        String crossrefFileNameTarGz = parser.get("crossrefFileNameTarGz");
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", workingPath);
        conf.set("fs.hdfs.impl", DistributedFileSystem.class.getName());
        conf.set("fs.file.impl", LocalFileSystem.class.getName());
        FileSystem fs = FileSystem.get((URI)URI.create(workingPath), (Configuration)conf);
        DecompressTarGz.doExtract((FileSystem)fs, (String)outputPath, (String)workingPath.concat("/").concat(crossrefFileNameTarGz));
    }
}

