/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.bio.pubmed;

import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.schema.common.ModelConstants;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.InstanceTypeMapping;
import eu.dnetlib.dhp.schema.oaf.Journal;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.Subject;
import eu.dnetlib.dhp.schema.oaf.utils.GraphCleaningFunctions;
import eu.dnetlib.dhp.schema.oaf.utils.IdentifierFactory;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import eu.dnetlib.dhp.schema.oaf.utils.PidType;
import eu.dnetlib.dhp.sx.bio.pubmed.PMArticle;
import eu.dnetlib.dhp.sx.bio.pubmed.PMAuthor;
import eu.dnetlib.dhp.sx.bio.pubmed.PMJournal;
import eu.dnetlib.dhp.sx.bio.pubmed.PMSubject;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.TraversableForwarder;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;

public final class PubMedToOaf$ {
    public static final PubMedToOaf$ MODULE$;
    private final String SUBJ_CLASS;
    private final String OAI_HEADER;
    private final String OLD_PMC_PREFIX;
    private final Map<String, String> urlMap;
    private final DataInfo dataInfo;
    private final KeyValue collectedFrom;

    static {
        new PubMedToOaf$();
    }

    public String SUBJ_CLASS() {
        return this.SUBJ_CLASS;
    }

    public String OAI_HEADER() {
        return this.OAI_HEADER;
    }

    public String OLD_PMC_PREFIX() {
        return this.OLD_PMC_PREFIX;
    }

    public Map<String, String> urlMap() {
        return this.urlMap;
    }

    public DataInfo dataInfo() {
        return this.dataInfo;
    }

    public KeyValue collectedFrom() {
        return this.collectedFrom;
    }

    public String cleanDoi(String doi) {
        String regex = "^10.\\d{4,9}\\/[\\[\\]\\-\\<\\>._;()\\/:A-Z0-9]+$";
        Pattern pattern = Pattern.compile(regex, 2);
        Matcher matcher = pattern.matcher(doi);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return null;
    }

    public String createOriginalOpenaireId(PMArticle article) {
        String string;
        if (StringUtils.isNotEmpty((CharSequence)article.getPmcId())) {
            String md5 = DHPUtils.md5((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.OAI_HEADER(), article.getPmcId().replace("PMC", "")})));
            string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.OLD_PMC_PREFIX(), md5}));
        } else {
            string = null;
        }
        return string;
    }

    public Result createResult(Qualifier cobjQualifier, VocabularyGroup vocabularies) {
        Qualifier result_typologies = this.getVocabularyTerm("dnet:result_typologies", vocabularies, cobjQualifier.getClassid());
        String string = result_typologies.getClassid();
        Object object = "dataset".equals(string) ? new Dataset() : ("publication".equals(string) ? new Publication() : ("other".equals(string) ? new OtherResearchProduct() : ("software".equals(string) ? new Software() : null)));
        return object;
    }

    /*
     * WARNING - void declaration
     */
    public Journal mapJournal(PMJournal j) {
        void var2_2;
        if (j == null) {
            return null;
        }
        Journal journal = new Journal();
        journal.setDataInfo(this.dataInfo());
        journal.setName(j.getTitle());
        journal.setConferencedate(j.getDate());
        journal.setVol(j.getVolume());
        journal.setIssnPrinted(j.getIssn());
        journal.setIss(j.getIssue());
        return var2_2;
    }

    public Qualifier getVocabularyTerm(String vocabularyName, VocabularyGroup vocabularies, String term) {
        Qualifier a = vocabularies.getSynonymAsQualifier(vocabularyName, term);
        Qualifier b = vocabularies.getTermAsQualifier(vocabularyName, term);
        return a == null ? b : a;
    }

    public Oaf convert(PMArticle article, VocabularyGroup vocabularies) {
        block20: {
            List authors;
            List subjects;
            Qualifier term;
            Instance pubmedInstance;
            StructuredProperty alternateIdentifier;
            ListBuffer pidList;
            block19: {
                block18: {
                    String normalizedPid;
                    if (article.getPublicationTypes() == null) {
                        return null;
                    }
                    pidList = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                    pidList.$plus$eq((Object)OafMapperUtils.structuredProperty((String)article.getPmid(), (String)PidType.pmid.toString(), (String)PidType.pmid.toString(), (String)"dnet:pid_types", (String)"dnet:pid_types", (DataInfo)this.dataInfo()));
                    Object object = StringUtils.isNotBlank((CharSequence)article.getPmcId()) ? pidList.$plus$eq((Object)OafMapperUtils.structuredProperty((String)article.getPmcId(), (String)PidType.pmc.toString(), (String)PidType.pmc.toString(), (String)"dnet:pid_types", (String)"dnet:pid_types", (DataInfo)this.dataInfo())) : BoxedUnit.UNIT;
                    if (pidList == null) {
                        return null;
                    }
                    alternateIdentifier = null;
                    if (article.getDoi() != null && (normalizedPid = this.cleanDoi(article.getDoi())) != null) {
                        alternateIdentifier = OafMapperUtils.structuredProperty((String)normalizedPid, (String)PidType.doi.toString(), (String)PidType.doi.toString(), (String)"dnet:pid_types", (String)"dnet:pid_types", (DataInfo)this.dataInfo());
                    }
                    Option ja = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(article.getPublicationTypes()).asScala()).find((Function1)new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final boolean apply(PMSubject s) {
                            return "Journal Article".equalsIgnoreCase(s.getValue());
                        }
                    });
                    pubmedInstance = new Instance();
                    if (!ja.isDefined()) break block18;
                    Qualifier cojbCategory = this.getVocabularyTerm("dnet:publication_resource", vocabularies, ((PMSubject)ja.get()).getValue());
                    pubmedInstance.setInstancetype(cojbCategory);
                    InstanceTypeMapping itm = new InstanceTypeMapping();
                    itm.setOriginalType(((PMSubject)ja.get()).getValue());
                    itm.setVocabularyName("openaire::coar_resource_types_3_1");
                    pubmedInstance.setInstanceTypeMapping((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InstanceTypeMapping[]{itm}))).asJava());
                    break block19;
                }
                Option i_type = ((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(article.getPublicationTypes()).asScala()).map((Function1)new Serializable(vocabularies){
                    public static final long serialVersionUID = 0L;
                    private final VocabularyGroup vocabularies$1;

                    public final Tuple2<String, Qualifier> apply(PMSubject s) {
                        return new Tuple2((Object)s.getValue(), (Object)PubMedToOaf$.MODULE$.getVocabularyTerm("dnet:publication_resource", this.vocabularies$1, s.getValue()));
                    }
                    {
                        this.vocabularies$1 = vocabularies$1;
                    }
                }, Buffer$.MODULE$.canBuildFrom())).find((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<String, Qualifier> q) {
                        return q._2() != null;
                    }
                });
                if (!i_type.isDefined()) break block20;
                pubmedInstance.setInstancetype((Qualifier)((Tuple2)i_type.get())._2());
                InstanceTypeMapping itm = new InstanceTypeMapping();
                itm.setOriginalType((String)((Tuple2)i_type.get())._1());
                itm.setVocabularyName("openaire::coar_resource_types_3_1");
                pubmedInstance.setInstanceTypeMapping((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InstanceTypeMapping[]{itm}))).asJava());
            }
            Result result = this.createResult(pubmedInstance.getInstancetype(), vocabularies);
            if (result == null) {
                return result;
            }
            result.setDataInfo(this.dataInfo());
            pubmedInstance.setPid((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)pidList).asJava());
            if (alternateIdentifier != null) {
                pubmedInstance.setAlternateIdentifier((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructuredProperty[]{alternateIdentifier}))).asJava());
            }
            result.setInstance((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{pubmedInstance}))).asJava());
            List urlLists = (List)((ListBuffer)((TraversableLike)pidList.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<String, String> apply(StructuredProperty s) {
                    return new Tuple2(PubMedToOaf$.MODULE$.urlMap().getOrElse((Object)s.getQualifier().getClassid(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "";
                        }
                    }), (Object)s.getValue());
                }
            }, ListBuffer$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, String> t) {
                    return new StringOps(Predef$.MODULE$.augmentString((String)t._1())).nonEmpty();
                }
            })).toList().map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<String, String> t) {
                    return new StringBuilder().append((Object)((String)t._1())).append(t._2()).toString();
                }
            }, List$.MODULE$.canBuildFrom());
            if (urlLists != null) {
                pubmedInstance.setUrl((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)urlLists).asJava());
            }
            pubmedInstance.setDateofacceptance(OafMapperUtils.field((Object)GraphCleaningFunctions.cleanDate((String)article.getDate()), (DataInfo)this.dataInfo()));
            pubmedInstance.setCollectedfrom(this.collectedFrom());
            result.setPid((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)pidList).asJava());
            if (article.getJournal() != null && result instanceof Publication) {
                ((Publication)result).setJournal(this.mapJournal(article.getJournal()));
            }
            result.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyValue[]{this.collectedFrom()}))).asJava());
            result.setDateofacceptance(OafMapperUtils.field((Object)GraphCleaningFunctions.cleanDate((String)article.getDate()), (DataInfo)this.dataInfo()));
            if (article.getTitle() == null || article.getTitle().isEmpty()) {
                return null;
            }
            result.setTitle((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructuredProperty[]{OafMapperUtils.structuredProperty((String)article.getTitle(), (Qualifier)ModelConstants.MAIN_TITLE_QUALIFIER, (DataInfo)this.dataInfo())}))).asJava());
            if (article.getDescription() != null && new StringOps(Predef$.MODULE$.augmentString(article.getDescription())).nonEmpty()) {
                result.setDescription((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Field[]{OafMapperUtils.field((Object)article.getDescription(), (DataInfo)this.dataInfo())}))).asJava());
            }
            if (article.getLanguage() != null && (term = vocabularies.getSynonymAsQualifier("dnet:languages", article.getLanguage())) != null) {
                result.setLanguage(term);
            }
            if (article.getSubjects() != null && (subjects = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(article.getSubjects()).asScala()).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Subject apply(PMSubject s) {
                    return OafMapperUtils.subject((String)s.getValue(), (String)PubMedToOaf$.MODULE$.SUBJ_CLASS(), (String)PubMedToOaf$.MODULE$.SUBJ_CLASS(), (String)"dnet:subject_classification_typologies", (String)"dnet:subject_classification_typologies", (DataInfo)PubMedToOaf$.MODULE$.dataInfo());
                }
            }, Buffer$.MODULE$.canBuildFrom())).toList()) != null) {
                result.setSubject((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)subjects).asJava());
            }
            if ((authors = ((TraversableOnce)((TraversableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(article.getAuthors()).asScala()).zipWithIndex(Buffer$.MODULE$.canBuildFrom())).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Author apply(Tuple2<PMAuthor, Object> x0$1) {
                    Tuple2<PMAuthor, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        PMAuthor a = (PMAuthor)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        Author author = new Author();
                        author.setName(a.getForeName());
                        author.setSurname(a.getLastName());
                        author.setFullname(a.getFullName());
                        if (a.getIdentifier() != null) {
                            author.setPid((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructuredProperty[]{OafMapperUtils.structuredProperty((String)a.getIdentifier().getPid(), (Qualifier)OafMapperUtils.qualifier((String)a.getIdentifier().getType(), (String)a.getIdentifier().getType(), (String)"dnet:pid_types", (String)"dnet:pid_types"), (DataInfo)PubMedToOaf$.MODULE$.dataInfo())}))).asJava());
                        }
                        if (a.getAffiliation() != null) {
                            author.setRawAffiliationString((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{a.getAffiliation().getName()}))).asJava());
                        }
                        author.setRank(Predef$.MODULE$.int2Integer(index + 1));
                        Author author2 = author;
                        return author2;
                    }
                    throw new MatchError(tuple2);
                }
            }, Buffer$.MODULE$.canBuildFrom())).toList()) != null && authors.nonEmpty()) {
                result.setAuthor((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)authors).asJava());
            }
            if (StringUtils.isNotEmpty((CharSequence)article.getPmcId())) {
                ListBuffer originalIDS = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
                originalIDS.$plus$eq((Object)this.createOriginalOpenaireId(article));
                ((TraversableForwarder)pidList.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(StructuredProperty s) {
                        return s.getValue();
                    }
                }, ListBuffer$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(originalIDS){
                    public static final long serialVersionUID = 0L;
                    private final ListBuffer originalIDS$1;

                    public final ListBuffer<String> apply(String p) {
                        return this.originalIDS$1.$plus$eq((Object)p);
                    }
                    {
                        this.originalIDS$1 = originalIDS$1;
                    }
                });
                result.setOriginalId((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)originalIDS).asJava());
            } else {
                result.setOriginalId((java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)pidList.map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(StructuredProperty s) {
                        return s.getValue();
                    }
                }, ListBuffer$.MODULE$.canBuildFrom())).asJava());
            }
            result.setId(article.getPmid());
            String id = IdentifierFactory.createIdentifier((OafEntity)result);
            if (article.getPmid().equalsIgnoreCase(id)) {
                return null;
            }
            result.setId(id);
            return result;
        }
        return null;
    }

    private PubMedToOaf$() {
        MODULE$ = this;
        this.SUBJ_CLASS = "keywords";
        this.OAI_HEADER = "oai:pubmedcentral.nih.gov:";
        this.OLD_PMC_PREFIX = "od_______267::";
        this.urlMap = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"pmid"), (Object)"https://pubmed.ncbi.nlm.nih.gov/"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"doi"), (Object)"https://dx.doi.org/")}));
        this.dataInfo = OafMapperUtils.dataInfo((Boolean)Predef$.MODULE$.boolean2Boolean(false), null, (Boolean)Predef$.MODULE$.boolean2Boolean(false), (Boolean)Predef$.MODULE$.boolean2Boolean(false), (Qualifier)ModelConstants.PROVENANCE_ACTION_SET_QUALIFIER, (String)"0.9");
        this.collectedFrom = OafMapperUtils.keyValue((String)"10|opendoar____::8b6dd7db9af49e67306feb59a8bdc52c", (String)"Europe PubMed Central");
    }
}

