/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.usagestats;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.usagestats.SparkAtomicActionUsageJob;
import eu.dnetlib.dhp.schema.action.AtomicAction;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Measure;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.io.Text;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.spark.sql.SparkSession;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkAtomicActionCountJobTest {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static SparkSession spark;
    private static Path workingDir;
    private static final Logger log;

    @BeforeAll
    public static void beforeAll() throws IOException {
        workingDir = Files.createTempDirectory(SparkAtomicActionCountJobTest.class.getSimpleName(), new FileAttribute[0]);
        log.info("using work dir {}", (Object)workingDir);
        SparkConf conf = new SparkConf();
        conf.setAppName(SparkAtomicActionCountJobTest.class.getSimpleName());
        conf.setMaster("local[*]");
        conf.set("spark.driver.host", "localhost");
        conf.set("hive.metastore.local", "true");
        conf.set("spark.ui.enabled", "false");
        conf.set("spark.sql.warehouse.dir", workingDir.toString());
        conf.set("hive.metastore.warehouse.dir", workingDir.resolve("warehouse").toString());
        spark = SparkSession.builder().appName(SparkAtomicActionCountJobTest.class.getSimpleName()).config(conf).getOrCreate();
    }

    @AfterAll
    public static void afterAll() throws IOException {
        FileUtils.deleteDirectory((File)workingDir.toFile());
        spark.stop();
    }

    @Test
    void testUsageStatsDb2() {
        String usageScoresPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/usagestats/test2").getPath();
        SparkAtomicActionUsageJob.writeActionSet((SparkSession)spark, (String)usageScoresPath, (String)(workingDir.toString() + "/actionSet_testUsageStatsDb2"));
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD tmp = sc.sequenceFile(workingDir.toString() + "/actionSet_testUsageStatsDb2", Text.class, Text.class).map((Function & Serializable)usm -> (AtomicAction)OBJECT_MAPPER.readValue(((Text)usm._2).getBytes(), AtomicAction.class));
        Assertions.assertEquals((long)7L, (long)tmp.filter((Function & Serializable)aa -> ((OafEntity)aa.getPayload()).getId().startsWith("50|")).count());
        Assertions.assertEquals((long)9L, (long)tmp.filter((Function & Serializable)aa -> ((OafEntity)aa.getPayload()).getId().startsWith("10|")).count());
        Assertions.assertEquals((long)9L, (long)tmp.filter((Function & Serializable)aa -> ((OafEntity)aa.getPayload()).getId().startsWith("40|")).count());
        tmp.foreach((VoidFunction & Serializable)r -> Assertions.assertEquals((int)2, (int)((OafEntity)r.getPayload()).getMeasures().size()));
        tmp.foreach((VoidFunction & Serializable)r -> ((OafEntity)r.getPayload()).getMeasures().stream().forEach(m -> m.getUnit().stream().forEach(u -> Assertions.assertFalse((boolean)u.getDataInfo().getDeletedbyinference()))));
        tmp.foreach((VoidFunction & Serializable)r -> ((OafEntity)r.getPayload()).getMeasures().stream().forEach(m -> m.getUnit().stream().forEach(u -> Assertions.assertTrue((boolean)u.getDataInfo().getInferred()))));
        tmp.foreach((VoidFunction & Serializable)r -> ((OafEntity)r.getPayload()).getMeasures().stream().forEach(m -> m.getUnit().stream().forEach(u -> Assertions.assertFalse((boolean)u.getDataInfo().getInvisible()))));
        tmp.foreach((VoidFunction & Serializable)r -> ((OafEntity)r.getPayload()).getMeasures().stream().forEach(m -> m.getUnit().stream().forEach(u -> Assertions.assertEquals((Object)"measure:usage_counts", (Object)u.getDataInfo().getProvenanceaction().getClassid()))));
        tmp.foreach((VoidFunction & Serializable)r -> ((OafEntity)r.getPayload()).getMeasures().stream().forEach(m -> m.getUnit().stream().forEach(u -> Assertions.assertEquals((Object)"Inferred by OpenAIRE", (Object)u.getDataInfo().getProvenanceaction().getClassname()))));
        tmp.filter((Function & Serializable)aa -> ((OafEntity)aa.getPayload()).getId().startsWith("40|")).foreach((VoidFunction & Serializable)r -> ((OafEntity)r.getPayload()).getMeasures().stream().forEach(m -> m.getUnit().stream().forEach(u -> Assertions.assertEquals((Object)"count", (Object)u.getKey()))));
        Assertions.assertEquals((long)1L, (long)tmp.filter((Function & Serializable)r -> ((OafEntity)r.getPayload()).getId().equals("50|dedup_wf_001::53575dc69e9ace947e02d47ecd54a7a6")).count());
        OafEntity entity = (OafEntity)((AtomicAction)tmp.filter((Function & Serializable)aa -> ((OafEntity)aa.getPayload()).getId().equals("50|dedup_wf_001::53575dc69e9ace947e02d47ecd54a7a6")).first()).getPayload();
        entity.getMeasures().stream().forEach(m -> Assertions.assertEquals((int)3, (int)m.getUnit().size()));
        Measure downloads = entity.getMeasures().stream().filter(m -> m.getId().equals("downloads")).findFirst().get();
        Assertions.assertEquals((Object)String.valueOf(0), (Object)downloads.getUnit().stream().filter(u -> u.getKey().equals("10|fake1")).findFirst().get().getValue());
        Assertions.assertEquals((Object)String.valueOf(0), (Object)downloads.getUnit().stream().filter(u -> u.getKey().equals("10|fake2")).findFirst().get().getValue());
        Assertions.assertEquals((Object)String.valueOf(1), (Object)downloads.getUnit().stream().filter(u -> u.getKey().equals("10|fake3")).findFirst().get().getValue());
        Measure views = entity.getMeasures().stream().filter(m -> m.getId().equals("views")).findFirst().get();
        Assertions.assertEquals((Object)String.valueOf(5), (Object)views.getUnit().stream().filter(u -> u.getKey().equals("10|fake1")).findFirst().get().getValue());
        Assertions.assertEquals((Object)String.valueOf(1), (Object)views.getUnit().stream().filter(u -> u.getKey().equals("10|fake2")).findFirst().get().getValue());
        Assertions.assertEquals((Object)String.valueOf(3), (Object)views.getUnit().stream().filter(u -> u.getKey().equals("10|fake3")).findFirst().get().getValue());
        tmp.filter((Function & Serializable)aa -> ((OafEntity)aa.getPayload()).getId().startsWith("10|")).foreach((VoidFunction & Serializable)r -> ((OafEntity)r.getPayload()).getMeasures().stream().forEach(m -> m.getUnit().stream().forEach(u -> Assertions.assertEquals((Object)"count", (Object)u.getKey()))));
        Assertions.assertEquals((Object)"0", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("40|f1__________::53575dc69e9ace947e02d47ecd54a7a6")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("downloads")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"5", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("40|f1__________::53575dc69e9ace947e02d47ecd54a7a6")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("views")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"0", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("40|f11_________::17eda2ff77407538fbe5d3d719b9d1c0")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("downloads")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"1", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("40|f11_________::17eda2ff77407538fbe5d3d719b9d1c0")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("views")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"2", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("40|f12_________::3085e4c6e051378ca6157fe7f0430c1f")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("downloads")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"6", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("40|f12_________::3085e4c6e051378ca6157fe7f0430c1f")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("views")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"0", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("10|d1__________::53575dc69e9ace947e02d47ecd54a7a6")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("downloads")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"5", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("10|d1__________::53575dc69e9ace947e02d47ecd54a7a6")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("views")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"0", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("10|d11_________::17eda2ff77407538fbe5d3d719b9d1c0")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("downloads")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"1", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("10|d11_________::17eda2ff77407538fbe5d3d719b9d1c0")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("views")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"2", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("10|d12_________::3085e4c6e051378ca6157fe7f0430c1f")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("downloads")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"6", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("10|d12_________::3085e4c6e051378ca6157fe7f0430c1f")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("views")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
    }

    @Test
    void testMatch() {
        String usageScoresPath = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/usagestats/test1").getPath();
        SparkAtomicActionUsageJob.writeActionSet((SparkSession)spark, (String)usageScoresPath, (String)(workingDir.toString() + "/actionSet_testMatch"));
        JavaSparkContext sc = new JavaSparkContext(spark.sparkContext());
        JavaRDD tmp = sc.sequenceFile(workingDir.toString() + "/actionSet_testMatch", Text.class, Text.class).map((Function & Serializable)usm -> (AtomicAction)OBJECT_MAPPER.readValue(((Text)usm._2).getBytes(), AtomicAction.class));
        Assertions.assertEquals((long)9L, (long)tmp.filter((Function & Serializable)aa -> ((OafEntity)aa.getPayload()).getId().startsWith("50|")).count());
        Assertions.assertEquals((long)9L, (long)tmp.filter((Function & Serializable)aa -> ((OafEntity)aa.getPayload()).getId().startsWith("10|")).count());
        Assertions.assertEquals((long)9L, (long)tmp.filter((Function & Serializable)aa -> ((OafEntity)aa.getPayload()).getId().startsWith("40|")).count());
        tmp.foreach((VoidFunction & Serializable)r -> Assertions.assertEquals((int)2, (int)((OafEntity)r.getPayload()).getMeasures().size()));
        tmp.foreach((VoidFunction & Serializable)r -> ((OafEntity)r.getPayload()).getMeasures().stream().forEach(m -> m.getUnit().stream().forEach(u -> Assertions.assertFalse((boolean)u.getDataInfo().getDeletedbyinference()))));
        tmp.foreach((VoidFunction & Serializable)r -> ((OafEntity)r.getPayload()).getMeasures().stream().forEach(m -> m.getUnit().stream().forEach(u -> Assertions.assertTrue((boolean)u.getDataInfo().getInferred()))));
        tmp.foreach((VoidFunction & Serializable)r -> ((OafEntity)r.getPayload()).getMeasures().stream().forEach(m -> m.getUnit().stream().forEach(u -> Assertions.assertFalse((boolean)u.getDataInfo().getInvisible()))));
        tmp.foreach((VoidFunction & Serializable)r -> ((OafEntity)r.getPayload()).getMeasures().stream().forEach(m -> m.getUnit().stream().forEach(u -> Assertions.assertEquals((Object)"measure:usage_counts", (Object)u.getDataInfo().getProvenanceaction().getClassid()))));
        tmp.foreach((VoidFunction & Serializable)r -> ((OafEntity)r.getPayload()).getMeasures().stream().forEach(m -> m.getUnit().stream().forEach(u -> Assertions.assertEquals((Object)"Inferred by OpenAIRE", (Object)u.getDataInfo().getProvenanceaction().getClassname()))));
        tmp.filter((Function & Serializable)aa -> ((OafEntity)aa.getPayload()).getId().startsWith("40|")).foreach((VoidFunction & Serializable)r -> ((OafEntity)r.getPayload()).getMeasures().stream().forEach(m -> m.getUnit().stream().forEach(u -> Assertions.assertEquals((Object)"count", (Object)u.getKey()))));
        tmp.filter((Function & Serializable)aa -> ((OafEntity)aa.getPayload()).getId().startsWith("50|")).foreach((VoidFunction & Serializable)r -> ((OafEntity)r.getPayload()).getMeasures().stream().forEach(m -> m.getUnit().stream().forEach(u -> Assertions.assertEquals((Object)"10|fake1", (Object)u.getKey()))));
        tmp.filter((Function & Serializable)aa -> ((OafEntity)aa.getPayload()).getId().startsWith("10|")).foreach((VoidFunction & Serializable)r -> ((OafEntity)r.getPayload()).getMeasures().stream().forEach(m -> m.getUnit().stream().forEach(u -> Assertions.assertEquals((Object)"count", (Object)u.getKey()))));
        Assertions.assertEquals((long)1L, (long)tmp.filter((Function & Serializable)r -> ((OafEntity)r.getPayload()).getId().equals("50|dedup_wf_001::53575dc69e9ace947e02d47ecd54a7a6")).count());
        Assertions.assertEquals((Object)"0", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("50|dedup_wf_001::53575dc69e9ace947e02d47ecd54a7a6")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("downloads")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"5", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("50|dedup_wf_001::53575dc69e9ace947e02d47ecd54a7a6")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("views")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"0", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("50|doi_________::17eda2ff77407538fbe5d3d719b9d1c0")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("downloads")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"1", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("50|doi_________::17eda2ff77407538fbe5d3d719b9d1c0")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("views")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"2", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("50|doi_________::3085e4c6e051378ca6157fe7f0430c1f")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("downloads")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"6", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("50|doi_________::3085e4c6e051378ca6157fe7f0430c1f")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("views")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"0", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("40|f1__________::53575dc69e9ace947e02d47ecd54a7a6")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("downloads")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"5", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("40|f1__________::53575dc69e9ace947e02d47ecd54a7a6")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("views")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"0", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("40|f11_________::17eda2ff77407538fbe5d3d719b9d1c0")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("downloads")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"1", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("40|f11_________::17eda2ff77407538fbe5d3d719b9d1c0")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("views")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"2", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("40|f12_________::3085e4c6e051378ca6157fe7f0430c1f")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("downloads")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"6", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("40|f12_________::3085e4c6e051378ca6157fe7f0430c1f")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("views")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"0", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("10|d1__________::53575dc69e9ace947e02d47ecd54a7a6")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("downloads")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"5", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("10|d1__________::53575dc69e9ace947e02d47ecd54a7a6")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("views")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"0", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("10|d11_________::17eda2ff77407538fbe5d3d719b9d1c0")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("downloads")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"1", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("10|d11_________::17eda2ff77407538fbe5d3d719b9d1c0")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("views")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"2", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("10|d12_________::3085e4c6e051378ca6157fe7f0430c1f")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("downloads")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
        Assertions.assertEquals((Object)"6", (Object)((KeyValue)((Measure)((OafEntity)tmp.map((Function & Serializable)r -> (OafEntity)r.getPayload()).filter((Function & Serializable)r -> r.getId().equals("10|d12_________::3085e4c6e051378ca6157fe7f0430c1f")).collect().get(0)).getMeasures().stream().filter(m -> m.getId().equals("views")).collect(Collectors.toList()).get(0)).getUnit().get(0)).getValue());
    }

    static {
        log = LoggerFactory.getLogger(SparkAtomicActionCountJobTest.class);
    }
}

