/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.bipaffiliations;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.actionmanager.bipaffiliations.Constants;
import eu.dnetlib.dhp.actionmanager.ror.GenerateRorActionSetJob;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import eu.dnetlib.dhp.schema.action.AtomicAction;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.utils.DoiCleaningRule;
import eu.dnetlib.dhp.schema.oaf.utils.IdentifierFactory;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.compress.BZip2Codec;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.api.java.function.MapGroupsFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.api.java.UDF1;
import org.apache.spark.sql.functions;
import org.apache.spark.sql.types.DataTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public class PrepareAffiliationRelations
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(PrepareAffiliationRelations.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String ID_PREFIX = "50|doi_________::";
    public static final String BIP_AFFILIATIONS_CLASSID = "result:organization:openaireinference";
    public static final String BIP_AFFILIATIONS_CLASSNAME = "Affiliation relation inferred by OpenAIRE";
    public static final String AFFILIATION_INFERENCE_PROVENANCE = "openaire:affiliation";
    public static final String OPENAIRE_DATASOURCE_ID = "10|infrastruct_::f66f1bd369679b5b077dcdf006089556";
    public static final String OPENAIRE_DATASOURCE_NAME = "OpenAIRE";
    public static final String DOI_URL_PREFIX = "https://doi.org/";
    public static final int DOI_URL_PREFIX_LENGTH = 16;
    private static final Object OPENORGS_NS_PREFIX = "openorgs____";

    public static <I extends Result> void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)PrepareAffiliationRelations.class.getResourceAsStream("/eu/dnetlib/dhp/actionmanager/bipaffiliations/input_actionset_parameter.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = eu.dnetlib.dhp.actionmanager.Constants.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String openapcInputPath = parser.get("openapcInputPath");
        log.info("openapcInputPath: {}", (Object)openapcInputPath);
        String inputPaths = parser.get("inputPaths");
        log.info("inputPaths: {}", (Object)inputPaths);
        Boolean importIIS = Optional.ofNullable(parser.get("importIIS")).map(Boolean::valueOf).orElse(Boolean.FALSE);
        String outputPath = parser.get("outputPath");
        log.info("outputPath: {}", (Object)outputPath);
        SparkConf conf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)conf, (Boolean)isSparkSessionManaged, spark -> {
            eu.dnetlib.dhp.actionmanager.Constants.removeOutputDir(spark, outputPath);
            PrepareAffiliationRelations.createActionSet(spark, openapcInputPath, inputPaths, outputPath, importIIS);
        });
    }

    private static void createActionSet(SparkSession spark, String openapcInputPath, String inputPaths, String outputPath, Boolean importIIS) {
        List collectedfromOpenAIRE = OafMapperUtils.listKeyValues((String[])new String[]{OPENAIRE_DATASOURCE_ID, OPENAIRE_DATASOURCE_NAME});
        Dataset<Relation> crossrefRelations = PrepareAffiliationRelations.prepareAffiliationRelationsGraph(spark, inputPaths + "/crossref", collectedfromOpenAIRE, "openaire:affiliation:crossref");
        Dataset<Relation> pubmedRelations = PrepareAffiliationRelations.prepareAffiliationRelationsGraph(spark, inputPaths + "/pubmed", collectedfromOpenAIRE, "openaire:affiliation:pubmed");
        Dataset<Relation> openAPCRelations = PrepareAffiliationRelations.prepareAffiliationRelationsNewModel(spark, openapcInputPath, collectedfromOpenAIRE, "openaire:affiliation:openapc");
        Dataset<Relation> dataciteRelations = PrepareAffiliationRelations.prepareAffiliationRelationsGraph(spark, inputPaths + "/datacite", collectedfromOpenAIRE, "openaire:affiliation:datacite");
        Dataset<Relation> oalexRelations = PrepareAffiliationRelations.prepareAffiliationRelationsGraph(spark, inputPaths + "/oalex", collectedfromOpenAIRE, "openaire:affiliation:rawaff");
        Dataset<Relation> publisherRelations = PrepareAffiliationRelations.prepareAffiliationRelationsGraph(spark, inputPaths + "/publishers", collectedfromOpenAIRE, "openaire:affiliation:webcrawl");
        Dataset<Relation> oaireRelations = PrepareAffiliationRelations.prepareAffiliationRelationsGraph(spark, inputPaths + "/oaire", collectedfromOpenAIRE, "openaire:affiliation:graph");
        Dataset<Relation> iisRelations = spark.createDataset(Collections.emptyList(), Encoders.bean(Relation.class));
        if (importIIS.booleanValue()) {
            iisRelations = PrepareAffiliationRelations.prepareAffiliationRelationsGraph(spark, inputPaths + "/iis", collectedfromOpenAIRE, "openaire:affiliation:iis");
        }
        crossrefRelations.union(pubmedRelations).union(openAPCRelations).union(dataciteRelations).union(oalexRelations).union(publisherRelations).union(oaireRelations).union(iisRelations).groupByKey((MapFunction & Serializable)r -> r.getSource() + "::" + r.getRelClass() + "::" + r.getTarget(), Encoders.STRING()).mapGroups((MapGroupsFunction & Serializable)(k, it) -> (Relation)it.next(), Encoders.bean(Relation.class)).toJavaRDD().map((Function & Serializable)p -> new AtomicAction(Relation.class, (Oaf)p)).mapToPair((PairFunction & Serializable)aa -> new Tuple2((Object)new Text(aa.getClazz().getCanonicalName()), (Object)new Text(OBJECT_MAPPER.writeValueAsString(aa)))).saveAsHadoopFile(outputPath, Text.class, Text.class, SequenceFileOutputFormat.class, BZip2Codec.class);
    }

    private static List<Relation> getRelationPairs(List<KeyValue> collectedfrom, String resultid, String organizationid, String organizationpid, String dataprovenance, Double confidence) {
        String affId = null;
        affId = organizationpid.equalsIgnoreCase("ROR") ? GenerateRorActionSetJob.calculateOpenaireId(organizationid) : PrepareAffiliationRelations.calculateOpenOrgsId(organizationid);
        Qualifier qualifier = OafMapperUtils.qualifier((String)BIP_AFFILIATIONS_CLASSID, (String)BIP_AFFILIATIONS_CLASSNAME, (String)"dnet:provenanceActions", (String)"dnet:provenanceActions");
        DataInfo dataInfo = OafMapperUtils.dataInfo((Boolean)false, (String)dataprovenance, (Boolean)true, (Boolean)false, (Qualifier)qualifier, (String)Double.toString(confidence));
        return PrepareAffiliationRelations.getAffiliationRelationPair(resultid, affId, collectedfrom, dataInfo);
    }

    private static Dataset<Relation> getRels(Dataset<Row> inputDataset, List<KeyValue> collectedfromOpenAIRE, String dataprovenance) {
        return inputDataset.select(new Column[]{new Column("id").as("id"), new Column("matching.pid").as("pidtype"), new Column("matching.value").as("pidvalue"), new Column("matching.confidence").as("confidence"), new Column("matching.status").as("status"), new Column("matching.name").as("name"), new Column("matching.country").as("country")}).where("status = 'active'").flatMap((FlatMapFunction & Serializable)r -> PrepareAffiliationRelations.getRelationPairs(collectedfromOpenAIRE, (String)r.getAs("id"), (String)r.getAs("pidvalue"), (String)r.getAs("pidtype"), dataprovenance, (Double)r.getAs("confidence")).iterator(), Encoders.bean(Relation.class));
    }

    private static Dataset<Relation> prepareAffiliationRelationsGraph(SparkSession spark, String datasetPath, List<KeyValue> collectedfromOpenAIRE, String dataprovenance) {
        return PrepareAffiliationRelations.getRels((Dataset<Row>)spark.read().schema(Constants.RESULT_MATCHED_SCHEMA).json(datasetPath).select("id", new String[]{"organizations"}).withColumn("matching", functions.explode((Column)new Column("organizations"))), collectedfromOpenAIRE, dataprovenance);
    }

    private static Dataset<Relation> prepareAffiliationRelationsNewModel(SparkSession spark, String inputPath, List<KeyValue> collectedfrom, String dataprovenance) {
        spark.udf().register("md5HashWithPrefix", (UDF1 & Serializable)doi -> ID_PREFIX + IdentifierFactory.md5((String)DoiCleaningRule.clean((String)PrepareAffiliationRelations.removePrefix(doi))), DataTypes.StringType);
        return PrepareAffiliationRelations.getRels((Dataset<Row>)spark.read().schema(Constants.OPENAPC_INPUT_SCHEMA).json(inputPath).where("doi is not null").withColumn("id", functions.expr((String)"md5HashWithPrefix(doi)")).withColumn("matching", functions.explode((Column)new Column("matchings"))), collectedfrom, dataprovenance);
    }

    private static String calculateOpenOrgsId(String pidvalue) {
        return String.format("20|%s::%s", OPENORGS_NS_PREFIX, DHPUtils.md5((String)pidvalue));
    }

    private static String removePrefix(String doi) {
        if (doi.startsWith(DOI_URL_PREFIX)) {
            return doi.substring(16);
        }
        return doi;
    }

    private static List<Relation> getAffiliationRelationPair(String paperId, String affId, List<KeyValue> collectedfrom, DataInfo dataInfo) {
        return Arrays.asList(OafMapperUtils.getRelation((String)paperId, (String)affId, (String)"resultOrganization", (String)"affiliation", (String)"hasAuthorInstitution", collectedfrom, (DataInfo)dataInfo, null), OafMapperUtils.getRelation((String)affId, (String)paperId, (String)"resultOrganization", (String)"affiliation", (String)"isAuthorInstitutionOf", collectedfrom, (DataInfo)dataInfo, null));
    }
}

