/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.collection.ApiDescriptor;
import eu.dnetlib.dhp.collection.CollectorWorker;
import eu.dnetlib.dhp.collection.UnknownCollectorPluginException;
import eu.dnetlib.dhp.common.aggregation.AggregatorReport;
import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.common.collection.HttpClientParams;
import eu.dnetlib.dhp.message.MessageSender;
import eu.dnetlib.dhp.schema.mdstore.MDStoreVersion;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectorWorkerApplication {
    private static final Logger log = LoggerFactory.getLogger(CollectorWorkerApplication.class);
    private final FileSystem fileSystem;

    public CollectorWorkerApplication(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public static void main(String[] args) throws ParseException, IOException, UnknownCollectorPluginException, CollectorException {
        ArgumentApplicationParser argumentParser = new ArgumentApplicationParser(IOUtils.toString((InputStream)CollectorWorkerApplication.class.getResourceAsStream("/eu/dnetlib/dhp/collection/collector_worker_input_parameter.json")));
        argumentParser.parseArgument(args);
        log.info("Java Xmx: {}m", (Object)(Runtime.getRuntime().maxMemory() / 0x100000L));
        String hdfsuri = argumentParser.get("namenode");
        log.info("hdfsURI is {}", (Object)hdfsuri);
        String apiDescriptor = argumentParser.get("apidescriptor");
        log.info("apiDescriptor is {}", (Object)apiDescriptor);
        String mdStoreVersion = argumentParser.get("mdStoreVersion");
        log.info("mdStoreVersion is {}", (Object)mdStoreVersion);
        String dnetMessageManagerURL = argumentParser.get("dnetMessageManagerURL");
        log.info("dnetMessageManagerURL is {}", (Object)dnetMessageManagerURL);
        String workflowId = argumentParser.get("workflowId");
        log.info("workflowId is {}", (Object)workflowId);
        HttpClientParams clientParams = CollectorWorkerApplication.getClientParams(argumentParser);
        ApiDescriptor api = (ApiDescriptor)DHPUtils.MAPPER.readValue(apiDescriptor, ApiDescriptor.class);
        FileSystem fileSystem = FileSystem.get((Configuration)DHPUtils.getHadoopConfiguration((String)hdfsuri));
        new CollectorWorkerApplication(fileSystem).run(mdStoreVersion, clientParams, api, dnetMessageManagerURL, workflowId);
    }

    protected void run(String mdStoreVersion, HttpClientParams clientParams, ApiDescriptor api, String dnetMessageManagerURL, String workflowId) throws IOException, CollectorException, UnknownCollectorPluginException {
        MDStoreVersion currentVersion = (MDStoreVersion)DHPUtils.MAPPER.readValue(mdStoreVersion, MDStoreVersion.class);
        MessageSender ms = new MessageSender(dnetMessageManagerURL, workflowId);
        try (AggregatorReport report = new AggregatorReport(ms);){
            new CollectorWorker(api, this.fileSystem, currentVersion, clientParams, report).collect();
        }
    }

    private static HttpClientParams getClientParams(ArgumentApplicationParser argumentParser) {
        HttpClientParams clientParams = new HttpClientParams();
        clientParams.setMaxNumberOfRetry(Optional.ofNullable(argumentParser.get("maxNumberOfRetry")).map(Integer::parseInt).orElse(HttpClientParams._maxNumberOfRetry).intValue());
        log.info("maxNumberOfRetry is {}", (Object)clientParams.getMaxNumberOfRetry());
        clientParams.setRequestDelay(Optional.ofNullable(argumentParser.get("requestDelay")).map(Integer::parseInt).orElse(HttpClientParams._requestDelay).intValue());
        log.info("requestDelay is {}", (Object)clientParams.getRequestDelay());
        clientParams.setRetryDelay(Optional.ofNullable(argumentParser.get("retryDelay")).map(Integer::parseInt).orElse(HttpClientParams._retryDelay).intValue());
        log.info("retryDelay is {}", (Object)clientParams.getRetryDelay());
        clientParams.setConnectTimeOut(Optional.ofNullable(argumentParser.get("connectTimeOut")).map(Integer::parseInt).orElse(HttpClientParams._connectTimeOut).intValue());
        log.info("connectTimeOut is {}", (Object)clientParams.getConnectTimeOut());
        clientParams.setReadTimeOut(Optional.ofNullable(argumentParser.get("readTimeOut")).map(Integer::parseInt).orElse(HttpClientParams._readTimeOut).intValue());
        log.info("readTimeOut is {}", (Object)clientParams.getReadTimeOut());
        return clientParams;
    }
}

