/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.sftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import com.jcraft.jsch.SftpException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSftpIterator
implements Iterator<String> {
    private static final Logger log = LoggerFactory.getLogger(AbstractSftpIterator.class);
    private static final String END_MESSAGE = "___END___";
    private static final String FAIL_MESSAGE = "___FAIL___";
    private final String sftpURIScheme;
    private final String sftpServerAddress;
    private final String remoteSftpBasePath;
    private final int port;
    private final String username;
    private final boolean isRecursive;
    private final Set<String> extensionsSet;
    private final boolean incremental;
    private Session sftpSession;
    private ChannelSftp sftpChannel;
    private final LinkedBlockingQueue<String> queue = new LinkedBlockingQueue();
    private String nextElement = null;
    private LocalDate fromDate = null;
    private final DateTimeFormatter simpleDateTimeFormatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    public AbstractSftpIterator(String baseUrl, int port, String username, boolean isRecursive, Set<String> extensionsSet, String fromDate) {
        this.port = port;
        this.username = username;
        this.isRecursive = isRecursive;
        this.extensionsSet = extensionsSet;
        this.incremental = StringUtils.isNotBlank((CharSequence)fromDate);
        if (this.incremental) {
            this.fromDate = LocalDate.parse(fromDate, this.simpleDateTimeFormatter);
            log.debug("fromDate string: " + fromDate + " -- parsed: " + this.fromDate.toString());
        }
        try {
            URI sftpServer = new URI(baseUrl);
            this.sftpURIScheme = sftpServer.getScheme();
            this.sftpServerAddress = sftpServer.getHost();
            this.remoteSftpBasePath = sftpServer.getPath();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Bad syntax in the URL " + baseUrl);
        }
    }

    protected void init() {
        log.info(String.format("SFTP collector plugin collecting from %s with recursion = %s, incremental = %s with fromDate=%s", this.remoteSftpBasePath, this.isRecursive, this.incremental, this.fromDate));
        new Thread(() -> {
            try {
                this.connectToSftpServer();
                this.listDirectoryRecursive(".");
                this.queue.add(END_MESSAGE);
            }
            catch (Throwable e) {
                log.error("Error in SFTP thread", e);
                this.queue.add(FAIL_MESSAGE);
            }
            finally {
                this.disconnectFromSftpServer();
            }
        }).start();
        try {
            this.nextElement = this.queue.take();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private void connectToSftpServer() {
        try {
            this.sftpSession = this.createSession(this.sftpServerAddress, this.port, this.username);
            this.sftpSession.connect();
            log.debug("SFTP session connected");
            Channel channel = this.sftpSession.openChannel(this.sftpURIScheme);
            channel.connect();
            this.sftpChannel = (ChannelSftp)channel;
            String pwd = this.sftpChannel.pwd();
            log.debug("PWD from server: " + pwd);
            String fullPath = pwd + this.remoteSftpBasePath;
            this.sftpChannel.cd(fullPath);
            log.debug("PWD from server 2 after 'cd " + fullPath + "' : " + this.sftpChannel.pwd());
            log.info("Connected to SFTP server " + this.sftpServerAddress);
        }
        catch (JSchException e) {
            log.error("Unable to connect to remote SFTP server.", (Throwable)e);
            throw new RuntimeException("Unable to connect to remote SFTP server.", e);
        }
        catch (SftpException e) {
            log.error("Unable to access the base remote path on the SFTP server.", (Throwable)e);
            throw new RuntimeException("Unable to access the base remote path on the SFTP server.", e);
        }
    }

    protected abstract Session createSession(String var1, int var2, String var3) throws JSchException;

    private void disconnectFromSftpServer() {
        if (this.sftpChannel != null && !this.sftpChannel.isClosed()) {
            this.sftpChannel.exit();
        }
        if (this.sftpSession != null && this.sftpSession.isConnected()) {
            this.sftpSession.disconnect();
            log.info("Disconnected from SFTP server " + this.sftpServerAddress);
        }
    }

    private void listDirectoryRecursive(String dir) throws Exception {
        log.debug("DIR TO LIST: " + dir);
        for (Object o : this.sftpChannel.ls(dir)) {
            ChannelSftp.LsEntry entry = (ChannelSftp.LsEntry)o;
            String fn = entry.getFilename();
            SftpATTRS attrs = entry.getAttrs();
            if (".".equals(fn) || "..".equals(fn)) continue;
            if (this.isValidFile(fn, attrs) && (!this.incremental || this.incremental && this.isRecent(attrs))) {
                this.queue.add(this.getFileContent(dir + "/" + fn));
                continue;
            }
            if (!attrs.isDir() || !this.isRecursive) continue;
            this.listDirectoryRecursive(dir + "/" + fn);
        }
    }

    private boolean isValidFile(String fn, SftpATTRS attrs) {
        if (attrs.isDir()) {
            return false;
        }
        for (String ext : this.extensionsSet) {
            if (!fn.endsWith(ext)) continue;
            return true;
        }
        return false;
    }

    private boolean isRecent(SftpATTRS attrs) {
        int mTime = attrs.getMTime();
        LocalDateTime dt = LocalDateTime.ofInstant(Instant.ofEpochMilli((long)mTime * 1000L), TimeZone.getDefault().toZoneId());
        return dt.isAfter(this.fromDate.atStartOfDay());
    }

    private String getFileContent(String filePath) throws Exception {
        if (log.isDebugEnabled()) {
            log.debug("Collecing file from SFTP: " + filePath);
        }
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            this.sftpChannel.get(filePath, (OutputStream)baos);
            String string = baos.toString();
            return string;
        }
    }

    @Override
    public boolean hasNext() {
        if (FAIL_MESSAGE.equals(this.nextElement)) {
            throw new RuntimeException("Collection failed");
        }
        return !END_MESSAGE.equals(this.nextElement);
    }

    @Override
    public String next() {
        try {
            String string = this.nextElement;
            return string;
        }
        finally {
            try {
                this.nextElement = this.queue.take();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

