/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.bio;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import eu.dnetlib.dhp.aggregation.AbstractVocabularyTest;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.utils.PidType;
import eu.dnetlib.dhp.sx.bio.BioDBToOAF;
import eu.dnetlib.dhp.sx.bio.BioDBToOAF$;
import eu.dnetlib.dhp.sx.bio.BioScholixTest$;
import eu.dnetlib.dhp.sx.bio.BioScholixTest$$anonfun$parse_ebi_links$2$;
import eu.dnetlib.dhp.sx.bio.BioScholixTest$$anonfun$parse_ebi_links$2$$anonfun$apply$4$;
import eu.dnetlib.dhp.sx.bio.BioScholixTest$$anonfun$parse_ebi_links$2$$anonfun$apply$4$$anonfun$apply$6$;
import eu.dnetlib.dhp.sx.bio.BioScholixTest$$anonfun$parse_ebi_links$2$$anonfun$apply$4$$anonfun$apply$6$$anonfun$apply$8$;
import eu.dnetlib.dhp.sx.bio.BioScholixTest$$anonfun$parse_ebi_links$2$$anonfun$apply$4$$anonfun$apply$6$$anonfun$apply$8$$anonfun$apply$10$;
import eu.dnetlib.dhp.sx.bio.BioScholixTest$$anonfun$parse_ebi_links$2$$anonfun$apply$4$$anonfun$apply$6$$anonfun$apply$8$$anonfun$apply$10$$anonfun$apply$12$;
import eu.dnetlib.dhp.sx.bio.BioScholixTest$$anonfun$parse_ebi_links$2$$anonfun$apply$4$$anonfun$apply$6$$anonfun$apply$8$$anonfun$apply$10$$anonfun$apply$12$$anonfun$apply$14$;
import eu.dnetlib.dhp.sx.bio.BioScholixTest$AuthorPID$;
import eu.dnetlib.dhp.sx.bio.BioScholixTest$EBILinks$;
import eu.dnetlib.dhp.sx.bio.BioScholixTest$GzFileIterator$;
import eu.dnetlib.dhp.sx.bio.ebi.SparkCreatePubmedDump;
import eu.dnetlib.dhp.sx.bio.pubmed.PMArticle;
import eu.dnetlib.dhp.sx.bio.pubmed.PMAuthor;
import eu.dnetlib.dhp.sx.bio.pubmed.PMIdentifier;
import eu.dnetlib.dhp.sx.bio.pubmed.PMParser;
import eu.dnetlib.dhp.sx.bio.pubmed.PMParser2;
import eu.dnetlib.dhp.sx.bio.pubmed.PMSubject;
import eu.dnetlib.dhp.sx.bio.pubmed.PubMedToOaf$;
import java.io.BufferedReader;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import org.apache.commons.io.IOUtils;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.io.Codec$;
import scala.io.Source$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.VolatileByteRef;

@ExtendWith(value={MockitoExtension.class})
@ScalaSignature(bytes="\u0006\u0001\r\u0005e\u0001B\u0001\u0003\u00015\u0011aBQ5p'\u000eDw\u000e\\5y)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019!-[8\u000b\u0005\u00151\u0011AA:y\u0015\t9\u0001\"A\u0002eQBT!!\u0003\u0006\u0002\u000f\u0011tW\r\u001e7jE*\t1\"\u0001\u0002fk\u000e\u00011C\u0001\u0001\u000f!\ty!#D\u0001\u0011\u0015\t\tb!A\u0006bO\u001e\u0014XmZ1uS>t\u0017BA\n\u0011\u0005Y\t%m\u001d;sC\u000e$hk\\2bEVd\u0017M]=UKN$\b\"B\u000b\u0001\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\u0018!\tA\u0002!D\u0001\u0003\u0011\u001dQ\u0002A1A\u0005\u0002m\ta!\\1qa\u0016\u0014X#\u0001\u000f\u0011\u0005u1S\"\u0001\u0010\u000b\u0005}\u0001\u0013\u0001\u00033bi\u0006\u0014\u0017N\u001c3\u000b\u0005\u0005\u0012\u0013a\u00026bG.\u001cxN\u001c\u0006\u0003G\u0011\n\u0011BZ1ti\u0016\u0014\b0\u001c7\u000b\u0003\u0015\n1aY8n\u0013\t9cD\u0001\u0007PE*,7\r^'baB,'\u000f\u0003\u0004*\u0001\u0001\u0006I\u0001H\u0001\b[\u0006\u0004\b/\u001a:!\u0011\u0015Y\u0003\u0001\"\u0001-\u0003\u0015\u0019X\r^+q)\u0005i\u0003C\u0001\u00182\u001b\u0005y#\"\u0001\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005Iz#\u0001B+oSRD#A\u000b\u001b\u0011\u0005UrT\"\u0001\u001c\u000b\u0005]B\u0014aA1qS*\u0011\u0011HO\u0001\bUV\u0004\u0018\u000e^3s\u0015\tYD(A\u0003kk:LGOC\u0001>\u0003\ry'oZ\u0005\u0003\u007fY\u0012!BQ3g_J,W)Y2i\r\u0011\t\u0005\u0001\u0001\"\u0003-\t+hMZ3sK\u0012\u0014V-\u00193fe&#XM]1u_J\u001c2\u0001Q\"G!\tqC)\u0003\u0002F_\t1\u0011I\\=SK\u001a\u00042aR(S\u001d\tAUJ\u0004\u0002J\u00196\t!J\u0003\u0002L\u0019\u00051AH]8pizJ\u0011\u0001M\u0005\u0003\u001d>\nq\u0001]1dW\u0006<W-\u0003\u0002Q#\nA\u0011\n^3sCR|'O\u0003\u0002O_A\u00111K\u0016\b\u0003]QK!!V\u0018\u0002\rA\u0013X\rZ3g\u0013\t9\u0006L\u0001\u0004TiJLgn\u001a\u0006\u0003+>B\u0001B\u0017!\u0003\u0002\u0003\u0006IaW\u0001\u0007e\u0016\fG-\u001a:\u0011\u0005q\u000bW\"A/\u000b\u0005y{\u0016AA5p\u0015\u0005\u0001\u0017\u0001\u00026bm\u0006L!AY/\u0003\u001d\t+hMZ3sK\u0012\u0014V-\u00193fe\")Q\u0003\u0011C\u0001IR\u0011Qm\u001a\t\u0003M\u0002k\u0011\u0001\u0001\u0005\u00065\u000e\u0004\ra\u0017\u0005\u0006S\u0002#\tE[\u0001\bQ\u0006\u001ch*\u001a=u)\u0005Y\u0007C\u0001\u0018m\u0013\tiwFA\u0004C_>dW-\u00198\t\u000b=\u0004E\u0011\t9\u0002\t9,\u0007\u0010\u001e\u000b\u0002cB\u0011!/^\u0007\u0002g*\u0011AoX\u0001\u0005Y\u0006tw-\u0003\u0002Xg\u001e)q\u000f\u0001E\u0001q\u0006qqI\u001f$jY\u0016LE/\u001a:bi>\u0014\bC\u00014z\r\u0015Q\b\u0001#\u0001|\u000599%PR5mK&#XM]1u_J\u001c\"!_\"\t\u000bUIH\u0011A?\u0015\u0003aDaa`=\u0005\u0002\u0005\u0005\u0011!B1qa2LH#B3\u0002\u0004\u00055\u0001bBA\u0003}\u0002\u0007\u0011qA\u0001\u0003SN\u00042\u0001XA\u0005\u0013\r\tY!\u0018\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW\u000e\u0003\u0004\u0002\u0010y\u0004\rAU\u0001\tK:\u001cw\u000eZ5oO\"1\u00111\u0003\u0001\u0005\u00021\nq\u0001^3tiBKG\r\u000b\u0003\u0002\u0012\u0005]\u0001cA\u001b\u0002\u001a%\u0019\u00111\u0004\u001c\u0003\tQ+7\u000f\u001e\u0005\b\u0003?\u0001A\u0011AA\u0011\u0003I)\u0007\u0010\u001e:bGR\feMZ5mS\u0006$\u0018n\u001c8\u0015\t\u0005\r\u0012\u0011\u0006\t\u0005\u000f\u0006\u0015\"+C\u0002\u0002(E\u0013A\u0001T5ti\"9\u00111FA\u000f\u0001\u0004\u0011\u0016!A:\u0007\r\u0005=\u0002\u0001QA\u0019\u0005%\tU\u000f\u001e5peBKEiE\u0004\u0002.\r\u000b\u0019$!\u000f\u0011\u00079\n)$C\u0002\u00028=\u0012q\u0001\u0015:pIV\u001cG\u000fE\u0002/\u0003wI1!!\u00100\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011-\t\t%!\f\u0003\u0016\u0004%\t!a\u0011\u0002\u000fALG\rV=qKV\t!\u000b\u0003\u0006\u0002H\u00055\"\u0011#Q\u0001\nI\u000b\u0001\u0002]5e)f\u0004X\r\t\u0005\f\u0003\u0017\niC!f\u0001\n\u0003\t\u0019%A\u0002qS\u0012D!\"a\u0014\u0002.\tE\t\u0015!\u0003S\u0003\u0011\u0001\u0018\u000e\u001a\u0011\t\u000fU\ti\u0003\"\u0001\u0002TQ1\u0011QKA,\u00033\u00022AZA\u0017\u0011\u001d\t\t%!\u0015A\u0002ICq!a\u0013\u0002R\u0001\u0007!\u000b\u0003\u0006\u0002^\u00055\u0012\u0011!C\u0001\u0003?\nAaY8qsR1\u0011QKA1\u0003GB\u0011\"!\u0011\u0002\\A\u0005\t\u0019\u0001*\t\u0013\u0005-\u00131\fI\u0001\u0002\u0004\u0011\u0006BCA4\u0003[\t\n\u0011\"\u0001\u0002j\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\nTCAA6U\r\u0011\u0016QN\u0016\u0003\u0003_\u0002B!!\u001d\u0002|5\u0011\u00111\u000f\u0006\u0005\u0003k\n9(A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011P\u0018\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002~\u0005M$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"Q\u0011\u0011QA\u0017#\u0003%\t!!\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%e!Q\u0011QQA\u0017\u0003\u0003%\t%a\"\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\u0005\t\bBCAF\u0003[\t\t\u0011\"\u0001\u0002\u000e\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u0011q\u0012\t\u0004]\u0005E\u0015bAAJ_\t\u0019\u0011J\u001c;\t\u0015\u0005]\u0015QFA\u0001\n\u0003\tI*\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005m\u0015\u0011\u0015\t\u0004]\u0005u\u0015bAAP_\t\u0019\u0011I\\=\t\u0015\u0005\r\u0016QSA\u0001\u0002\u0004\ty)A\u0002yIEB!\"a*\u0002.\u0005\u0005I\u0011IAU\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAV!\u0019\ti+a-\u0002\u001c6\u0011\u0011q\u0016\u0006\u0004\u0003c{\u0013AC2pY2,7\r^5p]&\u0019\u0001+a,\t\u0015\u0005]\u0016QFA\u0001\n\u0003\tI,\u0001\u0005dC:,\u0015/^1m)\rY\u00171\u0018\u0005\u000b\u0003G\u000b),!AA\u0002\u0005m\u0005BCA`\u0003[\t\t\u0011\"\u0011\u0002B\u0006A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\u0010\"I\u0011QYA\u0017\u0003\u0003%\t\u0005]\u0001\ti>\u001cFO]5oO\"Q\u0011\u0011ZA\u0017\u0003\u0003%\t%a3\u0002\r\u0015\fX/\u00197t)\rY\u0017Q\u001a\u0005\u000b\u0003G\u000b9-!AA\u0002\u0005mu!CAi\u0001\u0005\u0005\t\u0012AAj\u0003%\tU\u000f\u001e5peBKE\tE\u0002g\u0003+4\u0011\"a\f\u0001\u0003\u0003E\t!a6\u0014\r\u0005U\u0017\u0011\\A\u001d!!\tY.!9S%\u0006USBAAo\u0015\r\tynL\u0001\beVtG/[7f\u0013\u0011\t\u0019/!8\u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t'\u0007C\u0004\u0016\u0003+$\t!a:\u0015\u0005\u0005M\u0007\"CAc\u0003+\f\t\u0011\"\u0012q\u0011%y\u0018Q[A\u0001\n\u0003\u000bi\u000f\u0006\u0004\u0002V\u0005=\u0018\u0011\u001f\u0005\b\u0003\u0003\nY\u000f1\u0001S\u0011\u001d\tY%a;A\u0002IC!\"!>\u0002V\u0006\u0005I\u0011QA|\u0003\u001d)h.\u00199qYf$B!!?\u0003\u0006A)a&a?\u0002\u0000&\u0019\u0011Q`\u0018\u0003\r=\u0003H/[8o!\u0015q#\u0011\u0001*S\u0013\r\u0011\u0019a\f\u0002\u0007)V\u0004H.\u001a\u001a\t\u0015\t\u001d\u00111_A\u0001\u0002\u0004\t)&A\u0002yIABqAa\u0003\u0001\t\u0003\u0011i!A\ffqR\u0014\u0018m\u0019;BkRDwN]%eK:$\u0018NZ5feR!!q\u0002B\t!\u00159\u0015QEA+\u0011\u001d\tYC!\u0003A\u0002ICaA!\u0006\u0001\t\u0003a\u0013A\u0005;fgR\u0004\u0016M]:j]\u001e\u0004VOY7fIJBCAa\u0005\u0002\u0018!1!1\u0004\u0001\u0005\u00021\n1\u0002^3ti\u0016\u0013\u0015\nR1uC\"\"!\u0011DA\f\u0011\u0019\u0011\t\u0003\u0001C\u0001Y\u0005yA/Z:u!V\u0014W.\u001a3U_>\u000bg\r\u000b\u0003\u0003 \u0005]\u0001b\u0002B\u0014\u0001\u0011%!\u0011F\u0001\u000fG\",7m\u001b)N\u0003J$\u0018n\u00197f)\ri#1\u0006\u0005\t\u0005[\u0011)\u00031\u0001\u00030\u00059\u0011M\u001d;jG2,\u0007\u0003\u0002B\u0019\u0005oi!Aa\r\u000b\u0007\tU\"!\u0001\u0004qk\nlW\rZ\u0005\u0005\u0005s\u0011\u0019DA\u0005Q\u001b\u0006\u0013H/[2mK\"1!Q\b\u0001\u0005\u00021\nA\u0003^3tiB\u000b'o]5oOB+(-\\3e16c\u0005\u0006\u0002B\u001e\u0003/AqAa\u0011\u0001\t\u0013\u0011)%\u0001\fdQ\u0016\u001c7\u000eU;c[\u0016$\u0007+\u001e2mS\u000e\fG/[8o)\ri#q\t\u0005\t\u0005\u0013\u0012\t\u00051\u0001\u0003L\u0005\tq\u000e\u0005\u0003\u0003N\t]SB\u0001B(\u0015\u0011\u0011\tFa\u0015\u0002\u0007=\fgMC\u0002\u0003V\u0019\taa]2iK6\f\u0017\u0002\u0002B-\u0005\u001f\u00121aT1g\u0011\u0019\u0011i\u0006\u0001C\u0001Y\u0005\u0019B/Z:u!V\u0014W.\u001a3Ta2LG\u000f^5oO\"1!\u0011\r\u0001\u0005\u00021\nA\u0003^3tiB+(-\\3e\u001fJLw-\u001b8bY&#\u0005\u0006\u0002B0\u0003/AaAa\u001a\u0001\t\u0003a\u0013!\u0005;fgR\u0004VOY7fI6\u000b\u0007\u000f]5oO\"\"!QMA\f\u0011\u0019\u0011i\u0007\u0001C\u0001Y\u0005aA/Z:u!\u0012\u0013Ek\\(B\r\"\"!1NA\f\u0011\u0019\u0011\u0019\b\u0001C\u0001Y\u0005\u0001B/Z:u+:K\u0005O]8u)>|\u0015I\u0012\u0015\u0005\u0005c\n9B\u0002\u0004\u0003z\u0001\u0001%1\u0010\u0002\t\u000b\nKE*\u001b8lgN9!qO\"\u00024\u0005e\u0002b\u0003B@\u0005o\u0012)\u001a!C\u0001\u0003\u0007\nqA]3m)f\u0004X\r\u0003\u0006\u0003\u0004\n]$\u0011#Q\u0001\nI\u000b\u0001B]3m)f\u0004X\r\t\u0005\f\u0005\u000f\u00139H!f\u0001\n\u0003\t\u0019%\u0001\u0003eCR,\u0007B\u0003BF\u0005o\u0012\t\u0012)A\u0005%\u0006)A-\u0019;fA!Y!q\u0012B<\u0005+\u0007I\u0011AA\"\u0003\u0015!\u0018\u000e\u001e7f\u0011)\u0011\u0019Ja\u001e\u0003\u0012\u0003\u0006IAU\u0001\u0007i&$H.\u001a\u0011\t\u0017\t]%q\u000fBK\u0002\u0013\u0005\u00111I\u0001\u0005a6LG\r\u0003\u0006\u0003\u001c\n]$\u0011#Q\u0001\nI\u000bQ\u0001]7jI\u0002B1Ba(\u0003x\tU\r\u0011\"\u0001\u0002D\u0005IA/\u0019:hKR\u0004\u0016\u000e\u001a\u0005\u000b\u0005G\u00139H!E!\u0002\u0013\u0011\u0016A\u0003;be\u001e,G\u000fU5eA!Y!q\u0015B<\u0005+\u0007I\u0011AA\"\u00035!\u0018M]4fiBKG\rV=qK\"Q!1\u0016B<\u0005#\u0005\u000b\u0011\u0002*\u0002\u001dQ\f'oZ3u!&$G+\u001f9fA!9QCa\u001e\u0005\u0002\t=FC\u0004BY\u0005g\u0013)La.\u0003:\nm&Q\u0018\t\u0004M\n]\u0004b\u0002B@\u0005[\u0003\rA\u0015\u0005\b\u0005\u000f\u0013i\u000b1\u0001S\u0011\u001d\u0011yI!,A\u0002ICqAa&\u0003.\u0002\u0007!\u000bC\u0004\u0003 \n5\u0006\u0019\u0001*\t\u000f\t\u001d&Q\u0016a\u0001%\"Q\u0011Q\fB<\u0003\u0003%\tA!1\u0015\u001d\tE&1\u0019Bc\u0005\u000f\u0014IMa3\u0003N\"I!q\u0010B`!\u0003\u0005\rA\u0015\u0005\n\u0005\u000f\u0013y\f%AA\u0002IC\u0011Ba$\u0003@B\u0005\t\u0019\u0001*\t\u0013\t]%q\u0018I\u0001\u0002\u0004\u0011\u0006\"\u0003BP\u0005\u007f\u0003\n\u00111\u0001S\u0011%\u00119Ka0\u0011\u0002\u0003\u0007!\u000b\u0003\u0006\u0002h\t]\u0014\u0013!C\u0001\u0003SB!\"!!\u0003xE\u0005I\u0011AA5\u0011)\u0011)Na\u001e\u0012\u0002\u0013\u0005\u0011\u0011N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011)\u0011INa\u001e\u0012\u0002\u0013\u0005\u0011\u0011N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00135\u0011)\u0011iNa\u001e\u0012\u0002\u0013\u0005\u0011\u0011N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00136\u0011)\u0011\tOa\u001e\u0012\u0002\u0013\u0005\u0011\u0011N\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137\u0011)\t)Ia\u001e\u0002\u0002\u0013\u0005\u0013q\u0011\u0005\u000b\u0003\u0017\u00139(!A\u0005\u0002\u00055\u0005BCAL\u0005o\n\t\u0011\"\u0001\u0003jR!\u00111\u0014Bv\u0011)\t\u0019Ka:\u0002\u0002\u0003\u0007\u0011q\u0012\u0005\u000b\u0003O\u00139(!A\u0005B\u0005%\u0006BCA\\\u0005o\n\t\u0011\"\u0001\u0003rR\u00191Na=\t\u0015\u0005\r&q^A\u0001\u0002\u0004\tY\n\u0003\u0006\u0002@\n]\u0014\u0011!C!\u0003\u0003D\u0011\"!2\u0003x\u0005\u0005I\u0011\t9\t\u0015\u0005%'qOA\u0001\n\u0003\u0012Y\u0010F\u0002l\u0005{D!\"a)\u0003z\u0006\u0005\t\u0019AAN\u000f%\u0019\t\u0001AA\u0001\u0012\u0003\u0019\u0019!\u0001\u0005F\u0005&c\u0015N\\6t!\r17Q\u0001\u0004\n\u0005s\u0002\u0011\u0011!E\u0001\u0007\u000f\u0019ba!\u0002\u0004\n\u0005e\u0002\u0003DAn\u0007\u0017\u0011&K\u0015*S%\nE\u0016\u0002BB\u0007\u0003;\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c87\u0011\u001d)2Q\u0001C\u0001\u0007#!\"aa\u0001\t\u0013\u0005\u00157QAA\u0001\n\u000b\u0002\b\"C@\u0004\u0006\u0005\u0005I\u0011QB\f)9\u0011\tl!\u0007\u0004\u001c\ru1qDB\u0011\u0007GAqAa \u0004\u0016\u0001\u0007!\u000bC\u0004\u0003\b\u000eU\u0001\u0019\u0001*\t\u000f\t=5Q\u0003a\u0001%\"9!qSB\u000b\u0001\u0004\u0011\u0006b\u0002BP\u0007+\u0001\rA\u0015\u0005\b\u0005O\u001b)\u00021\u0001S\u0011)\t)p!\u0002\u0002\u0002\u0013\u00055q\u0005\u000b\u0005\u0007S\u0019\t\u0004E\u0003/\u0003w\u001cY\u0003E\u0005/\u0007[\u0011&K\u0015*S%&\u00191qF\u0018\u0003\rQ+\b\u000f\\37\u0011)\u00119a!\n\u0002\u0002\u0003\u0007!\u0011\u0017\u0005\b\u0007k\u0001A\u0011AB\u001c\u0003=\u0001\u0018M]:f?\u0016\u0014\u0017n\u00187j].\u001cH\u0003BB\u001d\u0007w\u0001RaRA\u0013\u0005cCqa!\u0010\u00044\u0001\u0007!+A\u0003j]B,H\u000f\u0003\u0004\u0004B\u0001!\t\u0001L\u0001\u0012i\u0016\u001cH/\u0012\"J\u0019&t7n\u001d+p\u001f\u00063\u0005\u0006BB \u0003/AAba\u0012\u0001!\u0003\u0005\t\u0011!C\u0001\u0007\u0013\na\u0003\u001d:pi\u0016\u001cG/\u001a3%m>\u001c\u0017MY;mCJLWm\u001d\u000b\u0005\u0007\u0017\u001aY\u0006\u0005\u0003\u0004N\r]SBAB(\u0015\u0011\u0019\tfa\u0015\u0002\u0015Y|7-\u00192vY\u0006\u0014\u0018PC\u0002\u0004V\u0019\taaY8n[>t\u0017\u0002BB-\u0007\u001f\u0012qBV8dC\n,H.\u0019:z\u000fJ|W\u000f\u001d\u0005\n\u0003G\u001b)%!AA\u0002]As\u0001AB0\u0007W\u001ai\u0007\u0005\u0003\u0004b\r\u001dTBAB2\u0015\r\u0019)GN\u0001\nKb$XM\\:j_:LAa!\u001b\u0004d\tQQ\t\u001f;f]\u0012<\u0016\u000e\u001e5\u0002\u000bY\fG.^3-\u0005\r=4EAB9!\u0011\u0019\u0019h! \u000e\u0005\rU$bA\u001d\u0004x)\u00191h!\u001f\u000b\u0007\rmD(A\u0004n_\u000e\\\u0017\u000e^8\n\t\r}4Q\u000f\u0002\u0011\u001b>\u001c7.\u001b;p\u000bb$XM\\:j_:\u0004")
public class BioScholixTest
extends AbstractVocabularyTest {
    private final ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
    private volatile BioScholixTest$GzFileIterator$ GzFileIterator$module;
    private volatile BioScholixTest$AuthorPID$ AuthorPID$module;
    private volatile BioScholixTest$EBILinks$ EBILinks$module;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BioScholixTest$GzFileIterator$ GzFileIterator$lzycompute() {
        BioScholixTest bioScholixTest = this;
        synchronized (bioScholixTest) {
            if (this.GzFileIterator$module != null) return this.GzFileIterator$module;
            this.GzFileIterator$module = new BioScholixTest$GzFileIterator$(this);
            return this.GzFileIterator$module;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BioScholixTest$AuthorPID$ AuthorPID$lzycompute() {
        BioScholixTest bioScholixTest = this;
        synchronized (bioScholixTest) {
            if (this.AuthorPID$module != null) return this.AuthorPID$module;
            this.AuthorPID$module = new BioScholixTest$AuthorPID$(this);
            return this.AuthorPID$module;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private BioScholixTest$EBILinks$ EBILinks$lzycompute() {
        BioScholixTest bioScholixTest = this;
        synchronized (bioScholixTest) {
            if (this.EBILinks$module != null) return this.EBILinks$module;
            this.EBILinks$module = new BioScholixTest$EBILinks$(this);
            return this.EBILinks$module;
        }
    }

    public /* synthetic */ VocabularyGroup protected$vocabularies(BioScholixTest x$1) {
        return x$1.vocabularies;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    @BeforeEach
    public void setUp() {
        super.setUpVocabulary();
    }

    public BioScholixTest$GzFileIterator$ GzFileIterator() {
        return this.GzFileIterator$module == null ? this.GzFileIterator$lzycompute() : this.GzFileIterator$module;
    }

    @Test
    public void testPid() {
        List pids = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0000000163025705", "000000018494732X", "0000000308873343", "0000000335964515", "0000000333457333", "0000000335964515", "0000000302921949", "http://orcid.org/0000-0001-8567-3543", "http://orcid.org/0000-0001-7868-8528", "0000-0001-9189-1440", "0000-0003-3727-9247", "0000-0001-7246-1058", "000000033962389X", "0000000330371470", "0000000171236123", "0000000272569752", "0000000293231371", "http://orcid.org/0000-0003-3345-7333", "0000000340145688", "http://orcid.org/0000-0003-4894-1689"}));
        pids.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String pid) {
                String pidCleaned = new PMIdentifier(pid, "ORCID").getPid();
                Predef$.MODULE$.println((Object)pidCleaned);
                Assertions.assertTrue((boolean)pidCleaned.matches("[0-9]{4}-[0-9]{4}-[0-9]{4}-[0-9]{3}[0-9X]"));
            }
        });
    }

    public List<String> extractAffiliation(String s) {
        String regex = "<Affiliation>(.*)<\\/Affiliation>";
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(s);
        ListBuffer l = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (matcher.find()) {
            l.$plus$eq((Object)matcher.group(1));
        }
        return l.toList();
    }

    public BioScholixTest$AuthorPID$ AuthorPID() {
        return this.AuthorPID$module == null ? this.AuthorPID$lzycompute() : this.AuthorPID$module;
    }

    public List<AuthorPID> extractAuthorIdentifier(String s) {
        String regex = "<Identifier Source=\"(.*)\">(.*)<\\/Identifier>";
        Pattern pattern = Pattern.compile(regex, 8);
        Matcher matcher = pattern.matcher(s);
        ListBuffer l = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        while (matcher.find()) {
            l.$plus$eq((Object)new AuthorPID(this, matcher.group(1), matcher.group(2)));
        }
        return l.toList();
    }

    @Test
    public void testParsingPubmed2() {
        ObjectMapper mapper = new ObjectMapper();
        String xml = IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/single_pubmed.xml"));
        PMParser2 parser = new PMParser2();
        PMArticle article = parser.parse(xml);
        Predef$.MODULE$.println((Object)mapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)PubMedToOaf$.MODULE$.convert(article, this.vocabularies)));
    }

    @Test
    public void testEBIData() {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader xml = inputFactory.createXMLEventReader(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pubmed.xml"));
        new PMParser(xml).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BioScholixTest $outer;

            public final void apply(PMArticle s) {
                Predef$.MODULE$.println((Object)this.$outer.mapper().writeValueAsString((Object)s));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testPubmedToOaf() {
        Assertions.assertNotNull((Object)this.vocabularies);
        Assertions.assertTrue((boolean)this.vocabularies.vocabularyExists("dnet:publication_resource"));
        String records = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pubmed_dump"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        List r = (List)((List)new StringOps(Predef$.MODULE$.augmentString(records)).linesWithSeparators().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String l) {
                return new StringOps(Predef$.MODULE$.augmentString(l)).stripLineEnd();
            }
        }).toList().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BioScholixTest $outer;

            public final PMArticle apply(String s) {
                return (PMArticle)this.$outer.mapper().readValue(s, PMArticle.class);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BioScholixTest $outer;

            public final Oaf apply(PMArticle a) {
                return PubMedToOaf$.MODULE$.convert(a, this.$outer.protected$vocabularies(this.$outer));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom());
        Assertions.assertEquals((int)10, (int)r.size());
        Assertions.assertTrue((boolean)((LinearSeqOptimized)((List)r.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Result apply(Oaf p) {
                return (Result)p;
            }
        }, List$.MODULE$.canBuildFrom())).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Buffer<String> apply(Result p) {
                return (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getInstance()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Instance i) {
                        return i.getInstancetype().getClassid();
                    }
                }, Buffer$.MODULE$.canBuildFrom());
            }
        }, List$.MODULE$.canBuildFrom())).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String p) {
                return "0037".equalsIgnoreCase(p);
            }
        }));
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(r.head()));
    }

    public void eu$dnetlib$dhp$sx$bio$BioScholixTest$$checkPMArticle(PMArticle article) {
        Assertions.assertNotNull((Object)article.getPmid());
        Assertions.assertNotNull((Object)article.getTitle());
        Assertions.assertNotNull((Object)article.getAuthors());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(article.getAuthors()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(PMAuthor a) {
                Assertions.assertNotNull((Object)a);
                Assertions.assertNotNull((Object)a.getFullName());
            }
        });
    }

    @Test
    public void testParsingPubmedXML() {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader xml = inputFactory.createXMLEventReader(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pubmed.xml"));
        PMParser parser = new PMParser(xml);
        parser.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BioScholixTest $outer;

            public final void apply(PMArticle article) {
                this.$outer.eu$dnetlib$dhp$sx$bio$BioScholixTest$$checkPMArticle(article);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void eu$dnetlib$dhp$sx$bio$BioScholixTest$$checkPubmedPublication(Oaf o) {
        Assertions.assertTrue((boolean)(o instanceof Publication));
        Publication p = (Publication)o;
        Assertions.assertNotNull((Object)p.getId());
        Assertions.assertNotNull((Object)p.getTitle());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getTitle()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(StructuredProperty t) {
                Assertions.assertNotNull((Object)t.getValue());
            }
        });
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getAuthor()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Author a) {
                Assertions.assertNotNull((Object)a.getFullname());
            }
        });
        Assertions.assertNotNull((Object)p.getInstance());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getInstance()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Instance i) {
                Assertions.assertNotNull((Object)i.getCollectedfrom());
                Assertions.assertNotNull((Object)i.getPid());
                Assertions.assertNotNull((Object)i.getInstancetype());
            }
        });
        Assertions.assertNotNull((Object)p.getOriginalId());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getOriginalId()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String oId) {
                Assertions.assertNotNull((Object)oId);
            }
        });
        boolean hasPMC = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getInstance()).asScala()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(i.getPid()).asScala()).exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(StructuredProperty pid) {
                        return pid.getQualifier().getClassid().equalsIgnoreCase(PidType.pmc.toString());
                    }
                });
            }
        });
        if (hasPMC) {
            Assertions.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(p.getOriginalId()).asScala()).exists((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(String oId) {
                    return oId.startsWith("od_______267::");
                }
            }));
        }
    }

    public void testPubmedSplitting() {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("test").master("local").getOrCreate();
        new SparkCreatePubmedDump("", (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class)), LoggerFactory.getLogger(this.getClass())).createPubmedDump(spark, "/home/sandro/Downloads/pubmed", "/home/sandro/Downloads/pubmed_mapped", this.vocabularies);
    }

    @Test
    public void testPubmedOriginalID() {
        PMArticle article = new PMArticle();
        article.setPmid("1234");
        article.setTitle("a Title");
        article.getPublicationTypes().add(new PMSubject("article", null, null));
        Publication publication = (Publication)PubMedToOaf$.MODULE$.convert(article, this.vocabularies);
        Assertions.assertNotNull((Object)publication);
        Assertions.assertEquals((Object)"50|pmid________::81dc9bdb52d04dc20036dbd8313ed055", (Object)publication.getId());
        article.setPmcId("PMC1517292");
        publication = (Publication)PubMedToOaf$.MODULE$.convert(article, this.vocabularies);
        Assertions.assertNotNull((Object)publication);
        Assertions.assertEquals((Object)"50|pmid________::81dc9bdb52d04dc20036dbd8313ed055", (Object)publication.getId());
        String oldOpenaireID = "od_______267::0000072375bc0e68fa09d4e6b7658248";
        boolean hasOldOpenAIREID = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(publication.getOriginalId()).asScala()).exists((Function1)new Serializable(this, oldOpenaireID){
            public static final long serialVersionUID = 0L;
            private final String oldOpenaireID$1;

            public final boolean apply(String o) {
                return o.equalsIgnoreCase(this.oldOpenaireID$1);
            }
            {
                this.oldOpenaireID$1 = oldOpenaireID$1;
            }
        });
        Assertions.assertTrue((boolean)hasOldOpenAIREID);
    }

    @Test
    public void testPubmedMapping() {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        XMLEventReader xml = inputFactory.createXMLEventReader(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pubmed.xml"));
        PMParser parser = new PMParser(xml);
        ListBuffer results = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        parser.foreach((Function1)new Serializable(this, results){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BioScholixTest $outer;
            private final ListBuffer results$1;

            public final ListBuffer<Oaf> apply(PMArticle x) {
                return this.results$1.$plus$eq((Object)PubMedToOaf$.MODULE$.convert(x, this.$outer.protected$vocabularies(this.$outer)));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.results$1 = results$1;
            }
        });
        results.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BioScholixTest $outer;

            public final void apply(Oaf o) {
                this.$outer.eu$dnetlib$dhp$sx$bio$BioScholixTest$$checkPubmedPublication(o);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testPDBToOAF() {
        Assertions.assertNotNull((Object)this.vocabularies);
        Assertions.assertTrue((boolean)this.vocabularies.vocabularyExists("dnet:publication_resource"));
        String records = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/pdb_dump"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        new StringOps(Predef$.MODULE$.augmentString(records)).linesWithSeparators().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String l) {
                return new StringOps(Predef$.MODULE$.augmentString(l)).stripLineEnd();
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String s) {
                Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString(s)).nonEmpty());
            }
        });
        List result = (List)new StringOps(Predef$.MODULE$.augmentString(records)).linesWithSeparators().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String l) {
                return new StringOps(Predef$.MODULE$.augmentString(l)).stripLineEnd();
            }
        }).toList().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BioScholixTest $outer;

            public final List<Oaf> apply(String o) {
                return BioDBToOAF$.MODULE$.pdbTOOaf(o, this.$outer.protected$vocabularies(this.$outer));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom());
        Assertions.assertTrue((boolean)result.nonEmpty());
        result.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Oaf r) {
                Assertions.assertNotNull((Object)r);
            }
        });
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToInteger((int)result.count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf o) {
                return o instanceof Relation;
            }
        })));
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(result.head()));
    }

    @Test
    public void testUNIprotToOAF() {
        Assertions.assertNotNull((Object)this.vocabularies);
        Assertions.assertTrue((boolean)this.vocabularies.vocabularyExists("dnet:publication_resource"));
        String records = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/uniprot_dump"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        new StringOps(Predef$.MODULE$.augmentString(records)).linesWithSeparators().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String l) {
                return new StringOps(Predef$.MODULE$.augmentString(l)).stripLineEnd();
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String s) {
                Assertions.assertTrue((boolean)new StringOps(Predef$.MODULE$.augmentString(s)).nonEmpty());
            }
        });
        List result = (List)new StringOps(Predef$.MODULE$.augmentString(records)).linesWithSeparators().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String l) {
                return new StringOps(Predef$.MODULE$.augmentString(l)).stripLineEnd();
            }
        }).toList().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BioScholixTest $outer;

            public final List<Oaf> apply(String o) {
                return BioDBToOAF$.MODULE$.uniprotToOAF(o, this.$outer.protected$vocabularies(this.$outer));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, List$.MODULE$.canBuildFrom());
        Assertions.assertTrue((boolean)result.nonEmpty());
        result.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Oaf r) {
                Assertions.assertNotNull((Object)r);
            }
        });
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToInteger((int)result.count((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf o) {
                return o instanceof Relation;
            }
        })));
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(result.head()));
    }

    public BioScholixTest$EBILinks$ EBILinks() {
        return this.EBILinks$module == null ? this.EBILinks$lzycompute() : this.EBILinks$module;
    }

    public List<EBILinks> parse_ebi_links(String input) {
        ObjectRef formats$lzy = ObjectRef.zero();
        ObjectRef json$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        String pmid = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(this.json$1(input, json$lzy, bitmap$0)).$bslash("publication")).$bslash("pmid")).extract((Formats)this.formats$1(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class));
        return package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(this.json$1(input, json$lzy, bitmap$0)).$bslash$bslash("Link")).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(JsonAST.JValue check$ifrefutable$1) {
                JsonAST.JValue jValue = check$ifrefutable$1;
                boolean bl = jValue instanceof JsonAST.JObject;
                return bl;
            }
        }).flatMap((Function1)new Serializable(this, pmid){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BioScholixTest $outer;
            public final String pmid$1;

            public final List<EBILinks> apply(JsonAST.JValue x$9) {
                JsonAST.JValue jValue = x$9;
                if (jValue instanceof JsonAST.JObject) {
                    JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                    List link = jObject.obj();
                    List list = (List)link.withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean apply(Tuple2<String, JsonAST.JValue> check$ifrefutable$2) {
                            Tuple2<String, JsonAST.JValue> tuple2 = check$ifrefutable$2;
                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                            if (option.isEmpty()) return false;
                            String string = (String)((Tuple2)option.get())._1();
                            JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                            if (!"Target".equals(string)) return false;
                            if (!(jValue instanceof JsonAST.JObject)) return false;
                            return true;
                        }
                    }).flatMap((Function1)new Serializable(this, link){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$parse_ebi_links$2 $outer;
                        public final List link$1;

                        public final List<EBILinks> apply(Tuple2<String, JsonAST.JValue> x$8) {
                            Tuple2<String, JsonAST.JValue> tuple2 = x$8;
                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                            if (!option.isEmpty()) {
                                String string = (String)((Tuple2)option.get())._1();
                                JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                if ("Target".equals(string) && jValue instanceof JsonAST.JObject) {
                                    JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                                    List target = jObject.obj();
                                    List list = (List)this.link$1.withFilter((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        /*
                                         * Enabled force condition propagation
                                         * Lifted jumps to return sites
                                         */
                                        public final boolean apply(Tuple2<String, JsonAST.JValue> check$ifrefutable$3) {
                                            Tuple2<String, JsonAST.JValue> tuple2 = check$ifrefutable$3;
                                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                            if (option.isEmpty()) return false;
                                            String string = (String)((Tuple2)option.get())._1();
                                            JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                            if (!"RelationshipType".equals(string)) return false;
                                            if (!(jValue instanceof JsonAST.JObject)) return false;
                                            return true;
                                        }
                                    }).flatMap((Function1)new Serializable(this, target){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ $anonfun$parse_ebi_links$2$$anonfun$apply$4 $outer;
                                        public final List target$1;

                                        public final List<EBILinks> apply(Tuple2<String, JsonAST.JValue> x$7) {
                                            Tuple2<String, JsonAST.JValue> tuple2 = x$7;
                                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                            if (!option.isEmpty()) {
                                                String string = (String)((Tuple2)option.get())._1();
                                                JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                                if ("RelationshipType".equals(string) && jValue instanceof JsonAST.JObject) {
                                                    JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                                                    List relType = jObject.obj();
                                                    List list = (List)relType.withFilter((Function1)new Serializable(this){
                                                        public static final long serialVersionUID = 0L;

                                                        /*
                                                         * Enabled force condition propagation
                                                         * Lifted jumps to return sites
                                                         */
                                                        public final boolean apply(Tuple2<String, JsonAST.JValue> check$ifrefutable$4) {
                                                            Tuple2<String, JsonAST.JValue> tuple2 = check$ifrefutable$4;
                                                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                            if (option.isEmpty()) return false;
                                                            String string = (String)((Tuple2)option.get())._1();
                                                            JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                                            if (!"Name".equals(string)) return false;
                                                            if (!(jValue instanceof JsonAST.JString)) return false;
                                                            return true;
                                                        }
                                                    }).flatMap((Function1)new Serializable(this){
                                                        public static final long serialVersionUID = 0L;
                                                        private final /* synthetic */ $anonfun$parse_ebi_links$2$$anonfun$apply$4$$anonfun$apply$6 $outer;

                                                        public final List<EBILinks> apply(Tuple2<String, JsonAST.JValue> x$6) {
                                                            Tuple2<String, JsonAST.JValue> tuple2 = x$6;
                                                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                            if (!option.isEmpty()) {
                                                                String string = (String)((Tuple2)option.get())._1();
                                                                JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                                                if ("Name".equals(string) && jValue instanceof JsonAST.JString) {
                                                                    JsonAST.JString jString = (JsonAST.JString)jValue;
                                                                    String relation = jString.s();
                                                                    List list = (List)this.$outer.eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$$outer().link$1.withFilter((Function1)new Serializable(this){
                                                                        public static final long serialVersionUID = 0L;

                                                                        /*
                                                                         * Enabled force condition propagation
                                                                         * Lifted jumps to return sites
                                                                         */
                                                                        public final boolean apply(Tuple2<String, JsonAST.JValue> check$ifrefutable$5) {
                                                                            Tuple2<String, JsonAST.JValue> tuple2 = check$ifrefutable$5;
                                                                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                                            if (option.isEmpty()) return false;
                                                                            String string = (String)((Tuple2)option.get())._1();
                                                                            JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                                                            if (!"PublicationDate".equals(string)) return false;
                                                                            if (!(jValue instanceof JsonAST.JString)) return false;
                                                                            return true;
                                                                        }
                                                                    }).flatMap((Function1)new Serializable(this, relation){
                                                                        public static final long serialVersionUID = 0L;
                                                                        private final /* synthetic */ $anonfun$parse_ebi_links$2$$anonfun$apply$4$$anonfun$apply$6$$anonfun$apply$8 $outer;
                                                                        public final String relation$1;

                                                                        public final List<EBILinks> apply(Tuple2<String, JsonAST.JValue> x$5) {
                                                                            Tuple2<String, JsonAST.JValue> tuple2 = x$5;
                                                                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                                            if (!option.isEmpty()) {
                                                                                String string = (String)((Tuple2)option.get())._1();
                                                                                JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                                                                if ("PublicationDate".equals(string) && jValue instanceof JsonAST.JString) {
                                                                                    JsonAST.JString jString = (JsonAST.JString)jValue;
                                                                                    String publicationDate = jString.s();
                                                                                    List list = (List)this.$outer.eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().target$1.withFilter((Function1)new Serializable(this){
                                                                                        public static final long serialVersionUID = 0L;

                                                                                        /*
                                                                                         * Enabled force condition propagation
                                                                                         * Lifted jumps to return sites
                                                                                         */
                                                                                        public final boolean apply(Tuple2<String, JsonAST.JValue> check$ifrefutable$6) {
                                                                                            Tuple2<String, JsonAST.JValue> tuple2 = check$ifrefutable$6;
                                                                                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                                                            if (option.isEmpty()) return false;
                                                                                            String string = (String)((Tuple2)option.get())._1();
                                                                                            JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                                                                            if (!"Title".equals(string)) return false;
                                                                                            if (!(jValue instanceof JsonAST.JString)) return false;
                                                                                            return true;
                                                                                        }
                                                                                    }).flatMap((Function1)new Serializable(this, publicationDate){
                                                                                        public static final long serialVersionUID = 0L;
                                                                                        private final /* synthetic */ $anonfun$parse_ebi_links$2$$anonfun$apply$4$$anonfun$apply$6$$anonfun$apply$8$$anonfun$apply$10 $outer;
                                                                                        public final String publicationDate$1;

                                                                                        public final List<EBILinks> apply(Tuple2<String, JsonAST.JValue> x$4) {
                                                                                            Tuple2<String, JsonAST.JValue> tuple2 = x$4;
                                                                                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                                                            if (!option.isEmpty()) {
                                                                                                String string = (String)((Tuple2)option.get())._1();
                                                                                                JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                                                                                if ("Title".equals(string) && jValue instanceof JsonAST.JString) {
                                                                                                    JsonAST.JString jString = (JsonAST.JString)jValue;
                                                                                                    String title = jString.s();
                                                                                                    List list = (List)this.$outer.eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().target$1.withFilter((Function1)new Serializable(this){
                                                                                                        public static final long serialVersionUID = 0L;

                                                                                                        /*
                                                                                                         * Enabled force condition propagation
                                                                                                         * Lifted jumps to return sites
                                                                                                         */
                                                                                                        public final boolean apply(Tuple2<String, JsonAST.JValue> check$ifrefutable$7) {
                                                                                                            Tuple2<String, JsonAST.JValue> tuple2 = check$ifrefutable$7;
                                                                                                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                                                                            if (option.isEmpty()) return false;
                                                                                                            String string = (String)((Tuple2)option.get())._1();
                                                                                                            JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                                                                                            if (!"Identifier".equals(string)) return false;
                                                                                                            if (!(jValue instanceof JsonAST.JObject)) return false;
                                                                                                            return true;
                                                                                                        }
                                                                                                    }).flatMap((Function1)new Serializable(this, title){
                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                        private final /* synthetic */ $anonfun$parse_ebi_links$2$$anonfun$apply$4$$anonfun$apply$6$$anonfun$apply$8$$anonfun$apply$10$$anonfun$apply$12 $outer;
                                                                                                        public final String title$1;

                                                                                                        public final List<EBILinks> apply(Tuple2<String, JsonAST.JValue> x$3) {
                                                                                                            Tuple2<String, JsonAST.JValue> tuple2 = x$3;
                                                                                                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                                                                            if (!option.isEmpty()) {
                                                                                                                String string = (String)((Tuple2)option.get())._1();
                                                                                                                JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                                                                                                if ("Identifier".equals(string) && jValue instanceof JsonAST.JObject) {
                                                                                                                    JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                                                                                                                    List identifier = jObject.obj();
                                                                                                                    List list = (List)identifier.withFilter((Function1)new Serializable(this){
                                                                                                                        public static final long serialVersionUID = 0L;

                                                                                                                        /*
                                                                                                                         * Enabled force condition propagation
                                                                                                                         * Lifted jumps to return sites
                                                                                                                         */
                                                                                                                        public final boolean apply(Tuple2<String, JsonAST.JValue> check$ifrefutable$8) {
                                                                                                                            Tuple2<String, JsonAST.JValue> tuple2 = check$ifrefutable$8;
                                                                                                                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                                                                                            if (option.isEmpty()) return false;
                                                                                                                            String string = (String)((Tuple2)option.get())._1();
                                                                                                                            JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                                                                                                            if (!"IDScheme".equals(string)) return false;
                                                                                                                            if (!(jValue instanceof JsonAST.JString)) return false;
                                                                                                                            return true;
                                                                                                                        }
                                                                                                                    }).flatMap((Function1)new Serializable(this, identifier){
                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                        private final /* synthetic */ $anonfun$parse_ebi_links$2$$anonfun$apply$4$$anonfun$apply$6$$anonfun$apply$8$$anonfun$apply$10$$anonfun$apply$12$$anonfun$apply$14 $outer;
                                                                                                                        private final List identifier$1;

                                                                                                                        public final List<EBILinks> apply(Tuple2<String, JsonAST.JValue> x$2) {
                                                                                                                            Tuple2<String, JsonAST.JValue> tuple2 = x$2;
                                                                                                                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                                                                                            if (!option.isEmpty()) {
                                                                                                                                String string = (String)((Tuple2)option.get())._1();
                                                                                                                                JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                                                                                                                if ("IDScheme".equals(string) && jValue instanceof JsonAST.JString) {
                                                                                                                                    JsonAST.JString jString = (JsonAST.JString)jValue;
                                                                                                                                    String idScheme = jString.s();
                                                                                                                                    List list = (List)this.identifier$1.withFilter((Function1)new Serializable(this){
                                                                                                                                        public static final long serialVersionUID = 0L;

                                                                                                                                        /*
                                                                                                                                         * Enabled force condition propagation
                                                                                                                                         * Lifted jumps to return sites
                                                                                                                                         */
                                                                                                                                        public final boolean apply(Tuple2<String, JsonAST.JValue> check$ifrefutable$9) {
                                                                                                                                            Tuple2<String, JsonAST.JValue> tuple2 = check$ifrefutable$9;
                                                                                                                                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                                                                                                            if (option.isEmpty()) return false;
                                                                                                                                            String string = (String)((Tuple2)option.get())._1();
                                                                                                                                            JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                                                                                                                            if (!"ID".equals(string)) return false;
                                                                                                                                            if (!(jValue instanceof JsonAST.JString)) return false;
                                                                                                                                            return true;
                                                                                                                                        }
                                                                                                                                    }).map((Function1)new Serializable(this, idScheme){
                                                                                                                                        public static final long serialVersionUID = 0L;
                                                                                                                                        private final /* synthetic */ $anonfun$parse_ebi_links$2$$anonfun$apply$4$$anonfun$apply$6$$anonfun$apply$8$$anonfun$apply$10$$anonfun$apply$12$$anonfun$apply$14$$anonfun$apply$16 $outer;
                                                                                                                                        private final String idScheme$1;

                                                                                                                                        public final EBILinks apply(Tuple2<String, JsonAST.JValue> x$1) {
                                                                                                                                            Tuple2<String, JsonAST.JValue> tuple2 = x$1;
                                                                                                                                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                                                                                                            if (!option.isEmpty()) {
                                                                                                                                                String string = (String)((Tuple2)option.get())._1();
                                                                                                                                                JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                                                                                                                                if ("ID".equals(string) && jValue instanceof JsonAST.JString) {
                                                                                                                                                    JsonAST.JString jString = (JsonAST.JString)jValue;
                                                                                                                                                    String id = jString.s();
                                                                                                                                                    EBILinks eBILinks = new EBILinks(this.$outer.eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$$outer().eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$$outer().eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$$outer(), this.$outer.eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().relation$1, this.$outer.eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().publicationDate$1, this.$outer.eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().title$1, this.$outer.eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$$outer().eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$$outer().pmid$1, id, this.idScheme$1);
                                                                                                                                                    return eBILinks;
                                                                                                                                                }
                                                                                                                                            }
                                                                                                                                            throw new MatchError(tuple2);
                                                                                                                                        }
                                                                                                                                        {
                                                                                                                                            if ($outer == null) {
                                                                                                                                                throw null;
                                                                                                                                            }
                                                                                                                                            this.$outer = $outer;
                                                                                                                                            this.idScheme$1 = idScheme$1;
                                                                                                                                        }
                                                                                                                                    }, List$.MODULE$.canBuildFrom());
                                                                                                                                    return list;
                                                                                                                                }
                                                                                                                            }
                                                                                                                            throw new MatchError(tuple2);
                                                                                                                        }

                                                                                                                        public /* synthetic */ $anonfun$parse_ebi_links$2$$anonfun$apply$4$$anonfun$apply$6$$anonfun$apply$8$$anonfun$apply$10$$anonfun$apply$12$$anonfun$apply$14 eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer() {
                                                                                                                            return this.$outer;
                                                                                                                        }
                                                                                                                        {
                                                                                                                            if ($outer == null) {
                                                                                                                                throw null;
                                                                                                                            }
                                                                                                                            this.$outer = $outer;
                                                                                                                            this.identifier$1 = identifier$1;
                                                                                                                        }
                                                                                                                    }, List$.MODULE$.canBuildFrom());
                                                                                                                    return list;
                                                                                                                }
                                                                                                            }
                                                                                                            throw new MatchError(tuple2);
                                                                                                        }

                                                                                                        public /* synthetic */ $anonfun$parse_ebi_links$2$$anonfun$apply$4$$anonfun$apply$6$$anonfun$apply$8$$anonfun$apply$10$$anonfun$apply$12 eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer() {
                                                                                                            return this.$outer;
                                                                                                        }
                                                                                                        {
                                                                                                            if ($outer == null) {
                                                                                                                throw null;
                                                                                                            }
                                                                                                            this.$outer = $outer;
                                                                                                            this.title$1 = title$1;
                                                                                                        }
                                                                                                    }, List$.MODULE$.canBuildFrom());
                                                                                                    return list;
                                                                                                }
                                                                                            }
                                                                                            throw new MatchError(tuple2);
                                                                                        }

                                                                                        public /* synthetic */ $anonfun$parse_ebi_links$2$$anonfun$apply$4$$anonfun$apply$6$$anonfun$apply$8$$anonfun$apply$10 eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer() {
                                                                                            return this.$outer;
                                                                                        }
                                                                                        {
                                                                                            if ($outer == null) {
                                                                                                throw null;
                                                                                            }
                                                                                            this.$outer = $outer;
                                                                                            this.publicationDate$1 = publicationDate$1;
                                                                                        }
                                                                                    }, List$.MODULE$.canBuildFrom());
                                                                                    return list;
                                                                                }
                                                                            }
                                                                            throw new MatchError(tuple2);
                                                                        }

                                                                        public /* synthetic */ $anonfun$parse_ebi_links$2$$anonfun$apply$4$$anonfun$apply$6$$anonfun$apply$8 eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer() {
                                                                            return this.$outer;
                                                                        }
                                                                        {
                                                                            if ($outer == null) {
                                                                                throw null;
                                                                            }
                                                                            this.$outer = $outer;
                                                                            this.relation$1 = relation$1;
                                                                        }
                                                                    }, List$.MODULE$.canBuildFrom());
                                                                    return list;
                                                                }
                                                            }
                                                            throw new MatchError(tuple2);
                                                        }

                                                        public /* synthetic */ $anonfun$parse_ebi_links$2$$anonfun$apply$4$$anonfun$apply$6 eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$anonfun$$$outer() {
                                                            return this.$outer;
                                                        }
                                                        {
                                                            if ($outer == null) {
                                                                throw null;
                                                            }
                                                            this.$outer = $outer;
                                                        }
                                                    }, List$.MODULE$.canBuildFrom());
                                                    return list;
                                                }
                                            }
                                            throw new MatchError(tuple2);
                                        }

                                        public /* synthetic */ $anonfun$parse_ebi_links$2$$anonfun$apply$4 eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$anonfun$$$outer() {
                                            return this.$outer;
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.target$1 = target$1;
                                        }
                                    }, List$.MODULE$.canBuildFrom());
                                    return list;
                                }
                            }
                            throw new MatchError(tuple2);
                        }

                        public /* synthetic */ $anonfun$parse_ebi_links$2 eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.link$1 = link$1;
                        }
                    }, List$.MODULE$.canBuildFrom());
                    return list;
                }
                throw new MatchError((Object)jValue);
            }

            public /* synthetic */ BioScholixTest eu$dnetlib$dhp$sx$bio$BioScholixTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.pmid$1 = pmid$1;
            }
        });
    }

    @Test
    public void testEBILinksToOAF() {
        BufferedReaderIterator iterator = this.GzFileIterator().apply(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/graph/bio/ebi_links.gz"), "UTF-8");
        String data = iterator.next();
        List res = (List)((List)BioDBToOAF$.MODULE$.parse_ebi_links(BioDBToOAF$.MODULE$.extractEBILinksFromDump(data).links()).filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(BioDBToOAF.EBILinks input) {
                return BioDBToOAF$.MODULE$.EBITargetLinksFilter(input);
            }
        })).flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final List<Oaf> apply(BioDBToOAF.EBILinks input) {
                return BioDBToOAF$.MODULE$.convertEBILinksToOaf(input);
            }
        }, List$.MODULE$.canBuildFrom());
        Predef$.MODULE$.print((Object)BoxesRunTime.boxToInteger((int)res.length()));
        Predef$.MODULE$.println((Object)this.mapper().writeValueAsString(res.head()));
    }

    private final DefaultFormats$ formats$lzycompute$1(ObjectRef formats$lzy$1, VolatileByteRef bitmap$0$1) {
        BioScholixTest bioScholixTest = this;
        synchronized (bioScholixTest) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                formats$lzy$1.elem = DefaultFormats$.MODULE$;
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (DefaultFormats$)formats$lzy$1.elem;
        }
    }

    private final DefaultFormats$ formats$1(ObjectRef formats$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.formats$lzycompute$1(formats$lzy$1, bitmap$0$1) : (DefaultFormats$)formats$lzy$1.elem;
    }

    private final JsonAST.JValue json$lzycompute$1(String input$1, ObjectRef json$lzy$1, VolatileByteRef bitmap$0$1) {
        BioScholixTest bioScholixTest = this;
        synchronized (bioScholixTest) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                json$lzy$1.elem = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(input$1), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return (JsonAST.JValue)json$lzy$1.elem;
        }
    }

    private final JsonAST.JValue json$1(String input$1, ObjectRef json$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? this.json$lzycompute$1(input$1, json$lzy$1, bitmap$0$1) : (JsonAST.JValue)json$lzy$1.elem;
    }

    public BioScholixTest() {
        this.mapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public class EBILinks
    implements Product,
    Serializable {
        private final String relType;
        private final String date;
        private final String title;
        private final String pmid;
        private final String targetPid;
        private final String targetPidType;
        public final /* synthetic */ BioScholixTest $outer;

        public String relType() {
            return this.relType;
        }

        public String date() {
            return this.date;
        }

        public String title() {
            return this.title;
        }

        public String pmid() {
            return this.pmid;
        }

        public String targetPid() {
            return this.targetPid;
        }

        public String targetPidType() {
            return this.targetPidType;
        }

        public EBILinks copy(String relType, String date, String title, String pmid, String targetPid, String targetPidType) {
            return new EBILinks(this.eu$dnetlib$dhp$sx$bio$BioScholixTest$EBILinks$$$outer(), relType, date, title, pmid, targetPid, targetPidType);
        }

        public String copy$default$1() {
            return this.relType();
        }

        public String copy$default$2() {
            return this.date();
        }

        public String copy$default$3() {
            return this.title();
        }

        public String copy$default$4() {
            return this.pmid();
        }

        public String copy$default$5() {
            return this.targetPid();
        }

        public String copy$default$6() {
            return this.targetPidType();
        }

        public String productPrefix() {
            return "EBILinks";
        }

        public int productArity() {
            return 6;
        }

        public Object productElement(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 5: {
                    string = this.targetPidType();
                    break;
                }
                case 4: {
                    string = this.targetPid();
                    break;
                }
                case 3: {
                    string = this.pmid();
                    break;
                }
                case 2: {
                    string = this.title();
                    break;
                }
                case 1: {
                    string = this.date();
                    break;
                }
                case 0: {
                    string = this.relType();
                }
            }
            return string;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof EBILinks;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof EBILinks)) return false;
            if (((EBILinks)object).eu$dnetlib$dhp$sx$bio$BioScholixTest$EBILinks$$$outer() != this.eu$dnetlib$dhp$sx$bio$BioScholixTest$EBILinks$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            EBILinks eBILinks = (EBILinks)x$1;
            String string = this.relType();
            String string2 = eBILinks.relType();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.date();
            String string4 = eBILinks.date();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            String string5 = this.title();
            String string6 = eBILinks.title();
            if (string5 == null) {
                if (string6 != null) {
                    return false;
                }
            } else if (!string5.equals(string6)) return false;
            String string7 = this.pmid();
            String string8 = eBILinks.pmid();
            if (string7 == null) {
                if (string8 != null) {
                    return false;
                }
            } else if (!string7.equals(string8)) return false;
            String string9 = this.targetPid();
            String string10 = eBILinks.targetPid();
            if (string9 == null) {
                if (string10 != null) {
                    return false;
                }
            } else if (!string9.equals(string10)) return false;
            String string11 = this.targetPidType();
            String string12 = eBILinks.targetPidType();
            if (string11 == null) {
                if (string12 != null) {
                    return false;
                }
            } else if (!string11.equals(string12)) return false;
            if (!eBILinks.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ BioScholixTest eu$dnetlib$dhp$sx$bio$BioScholixTest$EBILinks$$$outer() {
            return this.$outer;
        }

        public EBILinks(BioScholixTest $outer, String relType, String date, String title, String pmid, String targetPid, String targetPidType) {
            this.relType = relType;
            this.date = date;
            this.title = title;
            this.pmid = pmid;
            this.targetPid = targetPid;
            this.targetPidType = targetPidType;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }

    public class AuthorPID
    implements Product,
    Serializable {
        private final String pidType;
        private final String pid;
        public final /* synthetic */ BioScholixTest $outer;

        public String pidType() {
            return this.pidType;
        }

        public String pid() {
            return this.pid;
        }

        public AuthorPID copy(String pidType, String pid) {
            return new AuthorPID(this.eu$dnetlib$dhp$sx$bio$BioScholixTest$AuthorPID$$$outer(), pidType, pid);
        }

        public String copy$default$1() {
            return this.pidType();
        }

        public String copy$default$2() {
            return this.pid();
        }

        public String productPrefix() {
            return "AuthorPID";
        }

        public int productArity() {
            return 2;
        }

        public Object productElement(int x$1) {
            String string;
            int n = x$1;
            switch (n) {
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
                case 1: {
                    string = this.pid();
                    break;
                }
                case 0: {
                    string = this.pidType();
                }
            }
            return string;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof AuthorPID;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof AuthorPID)) return false;
            if (((AuthorPID)object).eu$dnetlib$dhp$sx$bio$BioScholixTest$AuthorPID$$$outer() != this.eu$dnetlib$dhp$sx$bio$BioScholixTest$AuthorPID$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            AuthorPID authorPID = (AuthorPID)x$1;
            String string = this.pidType();
            String string2 = authorPID.pidType();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            String string3 = this.pid();
            String string4 = authorPID.pid();
            if (string3 == null) {
                if (string4 != null) {
                    return false;
                }
            } else if (!string3.equals(string4)) return false;
            if (!authorPID.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ BioScholixTest eu$dnetlib$dhp$sx$bio$BioScholixTest$AuthorPID$$$outer() {
            return this.$outer;
        }

        public AuthorPID(BioScholixTest $outer, String pidType, String pid) {
            this.pidType = pidType;
            this.pid = pid;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.class.$init$((Product)this);
        }
    }

    public class BufferedReaderIterator
    implements Iterator<String> {
        private final BufferedReader reader;
        public final /* synthetic */ BioScholixTest $outer;

        public Iterator<String> seq() {
            return Iterator.class.seq((Iterator)this);
        }

        public boolean isEmpty() {
            return Iterator.class.isEmpty((Iterator)this);
        }

        public boolean isTraversableAgain() {
            return Iterator.class.isTraversableAgain((Iterator)this);
        }

        public boolean hasDefiniteSize() {
            return Iterator.class.hasDefiniteSize((Iterator)this);
        }

        public Iterator<String> take(int n) {
            return Iterator.class.take((Iterator)this, (int)n);
        }

        public Iterator<String> drop(int n) {
            return Iterator.class.drop((Iterator)this, (int)n);
        }

        public Iterator<String> slice(int from, int until) {
            return Iterator.class.slice((Iterator)this, (int)from, (int)until);
        }

        public <B> Iterator<B> map(Function1<String, B> f) {
            return Iterator.class.map((Iterator)this, f);
        }

        public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
            return Iterator.class.$plus$plus((Iterator)this, that);
        }

        public <B> Iterator<B> flatMap(Function1<String, GenTraversableOnce<B>> f) {
            return Iterator.class.flatMap((Iterator)this, f);
        }

        public Iterator<String> filter(Function1<String, Object> p) {
            return Iterator.class.filter((Iterator)this, p);
        }

        public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<String, B, Object> p) {
            return Iterator.class.corresponds((Iterator)this, that, p);
        }

        public Iterator<String> withFilter(Function1<String, Object> p) {
            return Iterator.class.withFilter((Iterator)this, p);
        }

        public Iterator<String> filterNot(Function1<String, Object> p) {
            return Iterator.class.filterNot((Iterator)this, p);
        }

        public <B> Iterator<B> collect(PartialFunction<String, B> pf) {
            return Iterator.class.collect((Iterator)this, pf);
        }

        public <B> Iterator<B> scanLeft(B z, Function2<B, String, B> op) {
            return Iterator.class.scanLeft((Iterator)this, z, op);
        }

        public <B> Iterator<B> scanRight(B z, Function2<String, B, B> op) {
            return Iterator.class.scanRight((Iterator)this, z, op);
        }

        public Iterator<String> takeWhile(Function1<String, Object> p) {
            return Iterator.class.takeWhile((Iterator)this, p);
        }

        public Tuple2<Iterator<String>, Iterator<String>> partition(Function1<String, Object> p) {
            return Iterator.class.partition((Iterator)this, p);
        }

        public Tuple2<Iterator<String>, Iterator<String>> span(Function1<String, Object> p) {
            return Iterator.class.span((Iterator)this, p);
        }

        public Iterator<String> dropWhile(Function1<String, Object> p) {
            return Iterator.class.dropWhile((Iterator)this, p);
        }

        public <B> Iterator<Tuple2<String, B>> zip(Iterator<B> that) {
            return Iterator.class.zip((Iterator)this, that);
        }

        public <A1> Iterator<A1> padTo(int len, A1 elem) {
            return Iterator.class.padTo((Iterator)this, (int)len, elem);
        }

        public Iterator<Tuple2<String, Object>> zipWithIndex() {
            return Iterator.class.zipWithIndex((Iterator)this);
        }

        public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
            return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
        }

        public <U> void foreach(Function1<String, U> f) {
            Iterator.class.foreach((Iterator)this, f);
        }

        public boolean forall(Function1<String, Object> p) {
            return Iterator.class.forall((Iterator)this, p);
        }

        public boolean exists(Function1<String, Object> p) {
            return Iterator.class.exists((Iterator)this, p);
        }

        public boolean contains(Object elem) {
            return Iterator.class.contains((Iterator)this, (Object)elem);
        }

        public Option<String> find(Function1<String, Object> p) {
            return Iterator.class.find((Iterator)this, p);
        }

        public int indexWhere(Function1<String, Object> p) {
            return Iterator.class.indexWhere((Iterator)this, p);
        }

        public <B> int indexOf(B elem) {
            return Iterator.class.indexOf((Iterator)this, elem);
        }

        public BufferedIterator<String> buffered() {
            return Iterator.class.buffered((Iterator)this);
        }

        public <B> Iterator.GroupedIterator<B> grouped(int size) {
            return Iterator.class.grouped((Iterator)this, (int)size);
        }

        public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
            return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
        }

        public int length() {
            return Iterator.class.length((Iterator)this);
        }

        public Tuple2<Iterator<String>, Iterator<String>> duplicate() {
            return Iterator.class.duplicate((Iterator)this);
        }

        public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
            return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
        }

        public <B> void copyToArray(Object xs, int start, int len) {
            Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
        }

        public boolean sameElements(Iterator<?> that) {
            return Iterator.class.sameElements((Iterator)this, that);
        }

        public Traversable<String> toTraversable() {
            return Iterator.class.toTraversable((Iterator)this);
        }

        public Iterator<String> toIterator() {
            return Iterator.class.toIterator((Iterator)this);
        }

        public Stream<String> toStream() {
            return Iterator.class.toStream((Iterator)this);
        }

        public String toString() {
            return Iterator.class.toString((Iterator)this);
        }

        public <B> int sliding$default$2() {
            return Iterator.class.sliding$default$2((Iterator)this);
        }

        public List<String> reversed() {
            return TraversableOnce.class.reversed((TraversableOnce)this);
        }

        public int size() {
            return TraversableOnce.class.size((TraversableOnce)this);
        }

        public boolean nonEmpty() {
            return TraversableOnce.class.nonEmpty((TraversableOnce)this);
        }

        public int count(Function1<String, Object> p) {
            return TraversableOnce.class.count((TraversableOnce)this, p);
        }

        public <B> Option<B> collectFirst(PartialFunction<String, B> pf) {
            return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
        }

        public <B> B $div$colon(B z, Function2<B, String, B> op) {
            return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
        }

        public <B> B $colon$bslash(B z, Function2<String, B, B> op) {
            return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
        }

        public <B> B foldLeft(B z, Function2<B, String, B> op) {
            return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
        }

        public <B> B foldRight(B z, Function2<String, B, B> op) {
            return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
        }

        public <B> B reduceLeft(Function2<B, String, B> op) {
            return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
        }

        public <B> B reduceRight(Function2<String, B, B> op) {
            return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceLeftOption(Function2<B, String, B> op) {
            return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
        }

        public <B> Option<B> reduceRightOption(Function2<String, B, B> op) {
            return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
        }

        public <A1> A1 reduce(Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
        }

        public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
            return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
        }

        public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
            return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
        }

        public <B> B aggregate(Function0<B> z, Function2<B, String, B> seqop, Function2<B, B, B> combop) {
            return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
        }

        public <B> B sum(Numeric<B> num) {
            return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
        }

        public <B> B product(Numeric<B> num) {
            return (B)TraversableOnce.class.product((TraversableOnce)this, num);
        }

        public Object min(Ordering cmp) {
            return TraversableOnce.class.min((TraversableOnce)this, (Ordering)cmp);
        }

        public Object max(Ordering cmp) {
            return TraversableOnce.class.max((TraversableOnce)this, (Ordering)cmp);
        }

        public Object maxBy(Function1 f, Ordering cmp) {
            return TraversableOnce.class.maxBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public Object minBy(Function1 f, Ordering cmp) {
            return TraversableOnce.class.minBy((TraversableOnce)this, (Function1)f, (Ordering)cmp);
        }

        public <B> void copyToBuffer(Buffer<B> dest) {
            TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
        }

        public <B> void copyToArray(Object xs, int start) {
            TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
        }

        public <B> void copyToArray(Object xs) {
            TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
        }

        public <B> Object toArray(ClassTag<B> evidence$1) {
            return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
        }

        public List<String> toList() {
            return TraversableOnce.class.toList((TraversableOnce)this);
        }

        public Iterable<String> toIterable() {
            return TraversableOnce.class.toIterable((TraversableOnce)this);
        }

        public Seq<String> toSeq() {
            return TraversableOnce.class.toSeq((TraversableOnce)this);
        }

        public IndexedSeq<String> toIndexedSeq() {
            return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
        }

        public <B> Buffer<B> toBuffer() {
            return TraversableOnce.class.toBuffer((TraversableOnce)this);
        }

        public <B> Set<B> toSet() {
            return TraversableOnce.class.toSet((TraversableOnce)this);
        }

        public Vector<String> toVector() {
            return TraversableOnce.class.toVector((TraversableOnce)this);
        }

        public <Col> Col to(CanBuildFrom<Nothing$, String, Col> cbf) {
            return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
        }

        public <T, U> Map<T, U> toMap(Predef$.less.colon.less<String, Tuple2<T, U>> ev) {
            return TraversableOnce.class.toMap((TraversableOnce)this, ev);
        }

        public String mkString(String start, String sep, String end) {
            return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
        }

        public String mkString(String sep) {
            return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
        }

        public String mkString() {
            return TraversableOnce.class.mkString((TraversableOnce)this);
        }

        public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
            return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
        }

        public StringBuilder addString(StringBuilder b, String sep) {
            return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
        }

        public StringBuilder addString(StringBuilder b) {
            return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
        }

        public boolean hasNext() {
            return this.reader.ready();
        }

        public String next() {
            return this.reader.readLine();
        }

        public /* synthetic */ BioScholixTest eu$dnetlib$dhp$sx$bio$BioScholixTest$BufferedReaderIterator$$$outer() {
            return this.$outer;
        }

        public BufferedReaderIterator(BioScholixTest $outer, BufferedReader reader) {
            this.reader = reader;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            TraversableOnce.class.$init$((TraversableOnce)this);
            Iterator.class.$init$((Iterator)this);
        }
    }
}

