/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.datacite;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import eu.dnetlib.dhp.aggregation.AbstractVocabularyTest;
import eu.dnetlib.dhp.datacite.DataciteToOAFTransformation$;
import eu.dnetlib.dhp.datacite.DataciteUtilityTest$;
import eu.dnetlib.dhp.datacite.GenerateDataciteDatasetSpark;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.Relation;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.io.FileUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.junit.jupiter.MockitoExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ExtendWith(value={MockitoExtension.class})
@ScalaSignature(bytes="\u0006\u0001]4A!\u0001\u0002\u0001\u0017\t\tB)\u0019;bG&$X\rV8P\u0003\u001a#Vm\u001d;\u000b\u0005\r!\u0011\u0001\u00033bi\u0006\u001c\u0017\u000e^3\u000b\u0005\u00151\u0011a\u00013ia*\u0011q\u0001C\u0001\bI:,G\u000f\\5c\u0015\u0005I\u0011AA3v\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0005=!\u0011aC1hOJ,w-\u0019;j_:L!!\u0005\b\u0003-\u0005\u00137\u000f\u001e:bGR4vnY1ck2\f'/\u001f+fgRDQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001\u0001\u0019!C\u00053\u0005Qqo\u001c:lS:<G)\u001b:\u0016\u0003i\u0001\"a\u0007\u0012\u000e\u0003qQ!!\b\u0010\u0002\t\u0019LG.\u001a\u0006\u0003?\u0001\n1A\\5p\u0015\u0005\t\u0013\u0001\u00026bm\u0006L!a\t\u000f\u0003\tA\u000bG\u000f\u001b\u0005\bK\u0001\u0001\r\u0011\"\u0003'\u000399xN]6j]\u001e$\u0015N]0%KF$\"aJ\u0017\u0011\u0005!ZS\"A\u0015\u000b\u0003)\nQa]2bY\u0006L!\u0001L\u0015\u0003\tUs\u0017\u000e\u001e\u0005\b]\u0011\n\t\u00111\u0001\u001b\u0003\rAH%\r\u0005\u0007a\u0001\u0001\u000b\u0015\u0002\u000e\u0002\u0017]|'o[5oO\u0012K'\u000f\t\u0005\be\u0001\u0011\r\u0011\"\u00014\u0003\rawnZ\u000b\u0002iA\u0011QGO\u0007\u0002m)\u0011q\u0007O\u0001\u0006g24GG\u001b\u0006\u0002s\u0005\u0019qN]4\n\u0005m2$A\u0002'pO\u001e,'\u000f\u0003\u0004>\u0001\u0001\u0006I\u0001N\u0001\u0005Y><\u0007\u0005C\u0003@\u0001\u0011\u0005\u0001)A\u0003tKR,\u0006\u000fF\u0001(Q\tq$\t\u0005\u0002D\u00156\tAI\u0003\u0002F\r\u0006\u0019\u0011\r]5\u000b\u0005\u001dC\u0015a\u00026va&$XM\u001d\u0006\u0003\u0013b\nQA[;oSRL!a\u0013#\u0003\u0015\t+gm\u001c:f\u000b\u0006\u001c\u0007\u000eC\u0003N\u0001\u0011\u0005\u0001)\u0001\u0005uK\u0006\u0014Hi\\<oQ\tau\n\u0005\u0002D!&\u0011\u0011\u000b\u0012\u0002\n\u0003\u001a$XM]#bG\"DQa\u0015\u0001\u0005\u0002Q\u000bq\u0002^3ti\u0012\u000bG/Z'baBLgnZ\u000b\u0002O!\u0012!K\u0016\t\u0003\u0007^K!\u0001\u0017#\u0003\tQ+7\u000f\u001e\u0005\u00065\u0002!\t\u0001Q\u0001\fi\u0016\u001cHoQ8om\u0016\u0014H\u000f\u000b\u0002Z-\")Q\f\u0001C\u0001\u0001\u0006YA/Z:u\u001b\u0006\u0004\b/\u001b8hQ\taf\u000bC\u0003a\u0001\u0011\u0005\u0001)\u0001\u0006uKN$h)\u001b7uKJD#a\u0018,\t\u000b\r\u0004A\u0011\u0001!\u0002-Q,7\u000f\u001e*fY\u0006$\u0018n\u001c8HK:,'/\u0019;j_:D#A\u0019,)\t\u00011G.\u001c\t\u0003O*l\u0011\u0001\u001b\u0006\u0003S\u0012\u000b\u0011\"\u001a=uK:\u001c\u0018n\u001c8\n\u0005-D'AC#yi\u0016tGmV5uQ\u0006)a/\u00197vK2\nanI\u0001p!\t\u0001X/D\u0001r\u0015\t9%O\u0003\u0002Jg*\u0011A\u000fO\u0001\b[>\u001c7.\u001b;p\u0013\t1\u0018O\u0001\tN_\u000e\\\u0017\u000e^8FqR,gn]5p]\u0002")
public class DataciteToOAFTest
extends AbstractVocabularyTest {
    private Path workingDir = null;
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    private Path workingDir() {
        return this.workingDir;
    }

    private void workingDir_$eq(Path x$1) {
        this.workingDir = x$1;
    }

    public Logger log() {
        return this.log;
    }

    @BeforeEach
    public void setUp() {
        this.workingDir_$eq(Files.createTempDirectory(this.getClass().getSimpleName(), new FileAttribute[0]));
        super.setUpVocabulary();
    }

    @AfterEach
    public void tearDown() {
        FileUtils.deleteDirectory((File)this.workingDir().toFile());
    }

    @Test
    public void testDateMapping() {
        String inputDate = "2021-07-14T11:52:54+0000";
        SimpleDateFormat ISO8601FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
        Date dt = ISO8601FORMAT.parse(inputDate);
        Predef$.MODULE$.println((Object)BoxesRunTime.boxToLong((long)dt.getTime()));
    }

    @Test
    public void testConvert() {
        String path = this.getClass().getResource("/eu/dnetlib/dhp/actionmanager/datacite/dataset").getPath();
        SparkConf conf = new SparkConf();
        conf.set("spark.driver.host", "localhost");
        conf.set("spark.ui.enabled", "false");
        SparkSession spark = SparkSession$.MODULE$.builder().config(conf).appName(this.getClass().getSimpleName()).master("local[*]").getOrCreate();
        Encoder oafEncoder = Encoders$.MODULE$.kryo(ClassTag$.MODULE$.apply(Oaf.class));
        GenerateDataciteDatasetSpark instance = new GenerateDataciteDatasetSpark(null, null, this.log());
        String targetPath = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/result"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.workingDir()}));
        instance.generateDataciteDataset(path, true, this.vocabularies, targetPath, spark);
        long nativeSize = spark.read().text(path).count();
        Assertions.assertEquals((long)1502L, (long)nativeSize);
        Dataset relDs = spark.read().schema("source STRING, target STRING, relClass STRING").json(path).where("relClass IS NOT NULL");
        relDs.show(false);
        Dataset result = spark.read().text(targetPath).as(spark.implicits().newStringEncoder()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String input) {
                return DataciteUtilityTest$.MODULE$.convertToOAF(input);
            }
        }, Encoders$.MODULE$.STRING());
        result.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("value").alias("class")})).agg(functions$.MODULE$.count("value").alias("Total"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).show(false);
        long t = spark.read().text(targetPath).as(spark.implicits().newStringEncoder()).count();
        Assertions.assertTrue((t > 0L ? 1 : 0) != 0);
        spark.stop();
    }

    @Test
    public void testMapping() {
        String record = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/actionmanager/datacite/record.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        List res = DataciteToOAFTransformation$.MODULE$.generateOAF(record, 0L, 0L, this.vocabularies, true);
        res.foreach((Function1)new Serializable(this, mapper){
            public static final long serialVersionUID = 0L;
            private final ObjectMapper mapper$1;

            public final void apply(Oaf r) {
                Predef$.MODULE$.println((Object)this.mapper$1.writeValueAsString((Object)r));
                Predef$.MODULE$.println((Object)"----------------------------");
            }
            {
                this.mapper$1 = mapper$1;
            }
        });
    }

    @Test
    public void testFilter() {
        String record = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/actionmanager/datacite/record_fairsharing.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        ObjectMapper mapper = new ObjectMapper().enable(SerializationFeature.INDENT_OUTPUT);
        List res = DataciteToOAFTransformation$.MODULE$.generateOAF(record, 0L, 0L, this.vocabularies, true);
        Assertions.assertTrue((boolean)res.isEmpty());
    }

    @Test
    public void testRelationGeneration() {
        String record = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("/eu/dnetlib/dhp/actionmanager/datacite/record.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        List res = DataciteToOAFTransformation$.MODULE$.generateOAF(record, 0L, 0L, this.vocabularies, true);
        ((List)((List)res.filter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Oaf s) {
                return s instanceof Relation;
            }
        })).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Relation apply(Oaf s) {
                return (Relation)s;
            }
        }, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Relation r) {
                Assertions.assertNotNull((Object)r.getSource());
                Assertions.assertNotNull((Object)r.getTarget());
                Assertions.assertNotNull((Object)r.getRelClass());
                Assertions.assertNotNull((Object)r.getCollectedfrom());
                Assertions.assertTrue((boolean)r.getSource().startsWith("50|"));
                Assertions.assertTrue((boolean)r.getTarget().startsWith("50|"));
            }
        });
    }
}

