/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.researchfi;

import eu.dnetlib.dhp.collection.ApiDescriptor;
import eu.dnetlib.dhp.collection.plugin.CollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.researchfi.ResearchFiIterator;
import eu.dnetlib.dhp.common.aggregation.AggregatorReport;
import eu.dnetlib.dhp.common.collection.CollectorException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResearchFiCollectorPlugin
implements CollectorPlugin {
    private static final Logger log = LoggerFactory.getLogger(ResearchFiCollectorPlugin.class);

    @Override
    public Stream<String> collect(ApiDescriptor api, AggregatorReport report) throws CollectorException {
        String authUrl = (String)api.getParams().get("auth_url");
        String clientId = (String)api.getParams().get("auth_client_id");
        String clientSecret = (String)api.getParams().get("auth_client_secret");
        String authToken = this.authenticate(authUrl, clientId, clientSecret);
        ResearchFiIterator iter = new ResearchFiIterator(api.getBaseUrl(), authToken);
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(iter, 16), false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String authenticate(String authUrl, String clientId, String clientSecret) throws CollectorException {
        try (CloseableHttpClient client = HttpClients.createDefault();){
            HttpPost req = new HttpPost(authUrl);
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("grant_type", "client_credentials"));
            params.add(new BasicNameValuePair("client_id", clientId));
            params.add(new BasicNameValuePair("client_secret", clientSecret));
            req.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            try (CloseableHttpResponse response = client.execute((HttpUriRequest)req);){
                String content = IOUtils.toString((InputStream)response.getEntity().getContent());
                JSONObject obj = new JSONObject(content);
                String token = obj.getString("access_token");
                if (!StringUtils.isNotBlank((CharSequence)token)) throw new CollectorException("Access token is missing");
                String string = token;
                return string;
            }
        }
        catch (Throwable e) {
            log.warn("Error obtaining access token", e);
            throw new CollectorException("Error obtaining access token", e);
        }
    }
}

