/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.datacite;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.common.vocabulary.VocabularyGroup;
import eu.dnetlib.dhp.datacite.CreatorType;
import eu.dnetlib.dhp.datacite.DataciteModelConstants$;
import eu.dnetlib.dhp.datacite.DataciteToOAFTransformation;
import eu.dnetlib.dhp.datacite.DataciteToOAFTransformation$;
import eu.dnetlib.dhp.datacite.DataciteToOAFTransformation$$anonfun$35$;
import eu.dnetlib.dhp.datacite.DataciteToOAFTransformation$$anonfun$35$$anonfun$apply$10$;
import eu.dnetlib.dhp.datacite.DateType;
import eu.dnetlib.dhp.datacite.DescriptionType;
import eu.dnetlib.dhp.datacite.NameIdentifiersType;
import eu.dnetlib.dhp.datacite.OAFRelations;
import eu.dnetlib.dhp.datacite.RelatedIdentifierType;
import eu.dnetlib.dhp.datacite.SubjectType;
import eu.dnetlib.dhp.datacite.TitleType;
import eu.dnetlib.dhp.schema.action.AtomicAction;
import eu.dnetlib.dhp.schema.common.ModelConstants;
import eu.dnetlib.dhp.schema.oaf.AccessRight;
import eu.dnetlib.dhp.schema.oaf.Author;
import eu.dnetlib.dhp.schema.oaf.DataInfo;
import eu.dnetlib.dhp.schema.oaf.Dataset;
import eu.dnetlib.dhp.schema.oaf.Field;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.InstanceTypeMapping;
import eu.dnetlib.dhp.schema.oaf.KeyValue;
import eu.dnetlib.dhp.schema.oaf.Oaf;
import eu.dnetlib.dhp.schema.oaf.OafEntity;
import eu.dnetlib.dhp.schema.oaf.OtherResearchProduct;
import eu.dnetlib.dhp.schema.oaf.Publication;
import eu.dnetlib.dhp.schema.oaf.Qualifier;
import eu.dnetlib.dhp.schema.oaf.Relation;
import eu.dnetlib.dhp.schema.oaf.Result;
import eu.dnetlib.dhp.schema.oaf.Software;
import eu.dnetlib.dhp.schema.oaf.StructuredProperty;
import eu.dnetlib.dhp.schema.oaf.Subject;
import eu.dnetlib.dhp.schema.oaf.utils.IdentifierFactory;
import eu.dnetlib.dhp.schema.oaf.utils.OafMapperUtils;
import eu.dnetlib.dhp.schema.oaf.utils.PidCleaner;
import eu.dnetlib.dhp.utils.DHPUtils;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.chrono.ThaiBuddhistDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.json4s.DefaultFormats$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.json4s.package$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.runtime.ObjectRef;
import scala.runtime.VolatileByteRef;

public final class DataciteToOAFTransformation$ {
    public static final DataciteToOAFTransformation$ MODULE$;
    private final String DOI_PREFIX;
    private final ObjectMapper mapper;
    private final DataciteToOAFTransformation.HostedByMapType unknown_repository;
    private final Map<String, DataciteToOAFTransformation.HostedByMapType> hostedByMap;

    static {
        new DataciteToOAFTransformation$();
    }

    public String DOI_PREFIX() {
        return this.DOI_PREFIX;
    }

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public DataciteToOAFTransformation.HostedByMapType unknown_repository() {
        return this.unknown_repository;
    }

    public Map<String, DataciteToOAFTransformation.HostedByMapType> hostedByMap() {
        return this.hostedByMap;
    }

    public boolean skip_record(String record, JsonAST.JValue json) {
        ObjectRef formats$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        return DataciteModelConstants$.MODULE$.datacite_filter().exists((Function1)new Serializable(record){
            public static final long serialVersionUID = 0L;
            private final String record$1;

            public final boolean apply(String f) {
                return this.record$1.contains(f);
            }
            {
                this.record$1 = record$1;
            }
        }) || ((String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(json).$bslash$bslash("publisher")).extractOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }, (Formats)this.formats$2(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class))).equalsIgnoreCase("FAIRsharing");
    }

    public Tuple2<String, String> toActionSet(Oaf item) {
        Tuple2 tuple2;
        ObjectMapper mapper = new ObjectMapper();
        Oaf oaf = item;
        if (oaf instanceof Dataset) {
            Dataset dataset = (Dataset)oaf;
            AtomicAction a = new AtomicAction();
            a.setClazz(Dataset.class);
            a.setPayload((Oaf)dataset);
            tuple2 = new Tuple2((Object)dataset.getClass().getCanonicalName(), (Object)mapper.writeValueAsString((Object)a));
        } else if (oaf instanceof Publication) {
            Publication publication = (Publication)oaf;
            AtomicAction a = new AtomicAction();
            a.setClazz(Publication.class);
            a.setPayload((Oaf)publication);
            tuple2 = new Tuple2((Object)publication.getClass().getCanonicalName(), (Object)mapper.writeValueAsString((Object)a));
        } else if (oaf instanceof Software) {
            Software software = (Software)oaf;
            AtomicAction a = new AtomicAction();
            a.setClazz(Software.class);
            a.setPayload((Oaf)software);
            tuple2 = new Tuple2((Object)software.getClass().getCanonicalName(), (Object)mapper.writeValueAsString((Object)a));
        } else if (oaf instanceof OtherResearchProduct) {
            OtherResearchProduct otherResearchProduct = (OtherResearchProduct)oaf;
            AtomicAction a = new AtomicAction();
            a.setClazz(OtherResearchProduct.class);
            a.setPayload((Oaf)otherResearchProduct);
            tuple2 = new Tuple2((Object)otherResearchProduct.getClass().getCanonicalName(), (Object)mapper.writeValueAsString((Object)a));
        } else if (oaf instanceof Relation) {
            Relation relation2 = (Relation)oaf;
            AtomicAction a = new AtomicAction();
            a.setClazz(Relation.class);
            a.setPayload((Oaf)relation2);
            tuple2 = new Tuple2((Object)relation2.getClass().getCanonicalName(), (Object)mapper.writeValueAsString((Object)a));
        } else {
            tuple2 = null;
        }
        return tuple2;
    }

    public boolean embargo_end(String embargo_end_date) {
        LocalDate dt = LocalDate.parse(embargo_end_date, DateTimeFormatter.ofPattern("[yyyy-MM-dd]"));
        LocalDate td = LocalDate.now();
        return td.isAfter(dt);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<String> extract_date(String input) {
        Option d = ((LinearSeqOptimized)DataciteModelConstants$.MODULE$.Date_regex().map((Function1)new Serializable(input){
            public static final long serialVersionUID = 0L;
            private final String input$1;

            public final String apply(Pattern pattern) {
                Matcher matcher = pattern.matcher(this.input$1);
                return matcher.find() ? matcher.group(0) : null;
            }
            {
                this.input$1 = input$1;
            }
        }, List$.MODULE$.canBuildFrom())).find((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String s) {
                return s != null;
            }
        });
        if (!d.isDefined()) void var2_2;
        return var2_2;
        String a_date = ((String)d.get()).length() == 4 ? new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"01-01-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{d.get()})) : (String)d.get();
        try {
            return new Some((Object)LocalDate.parse(a_date, DataciteModelConstants$.MODULE$.df_en()).toString());
        }
        catch (Throwable throwable) {
            try {
                return new Some((Object)LocalDate.parse(a_date, DataciteModelConstants$.MODULE$.df_it()).toString());
            }
            catch (Throwable throwable2) {
                return None$.MODULE$;
            }
        }
    }

    public String fix_thai_date(String input, String format) {
        String string;
        try {
            LocalDate a_date = LocalDate.parse(input, DateTimeFormatter.ofPattern(format));
            ThaiBuddhistDate d = ThaiBuddhistDate.of(a_date.getYear(), a_date.getMonth().getValue(), a_date.getDayOfMonth());
            string = LocalDate.from(d).toString();
        }
        catch (Throwable throwable) {
            string = "";
        }
        return string;
    }

    public Tuple3<Qualifier, Qualifier, String> getTypeQualifier(String resourceType, String resourceTypeGeneral, String schemaOrg, VocabularyGroup vocabularies) {
        Qualifier typeQualifier;
        Qualifier typeQualifier2;
        Qualifier typeQualifier3;
        if (resourceType != null && new StringOps(Predef$.MODULE$.augmentString(resourceType)).nonEmpty() && (typeQualifier3 = vocabularies.getSynonymAsQualifier("dnet:publication_resource", resourceType)) != null) {
            return new Tuple3((Object)typeQualifier3, (Object)vocabularies.getSynonymAsQualifier("dnet:result_typologies", typeQualifier3.getClassid()), (Object)resourceType);
        }
        if (schemaOrg != null && new StringOps(Predef$.MODULE$.augmentString(schemaOrg)).nonEmpty() && (typeQualifier2 = vocabularies.getSynonymAsQualifier("dnet:publication_resource", schemaOrg)) != null) {
            return new Tuple3((Object)typeQualifier2, (Object)vocabularies.getSynonymAsQualifier("dnet:result_typologies", typeQualifier2.getClassid()), (Object)schemaOrg);
        }
        if (resourceTypeGeneral != null && new StringOps(Predef$.MODULE$.augmentString(resourceTypeGeneral)).nonEmpty() && (typeQualifier = vocabularies.getSynonymAsQualifier("dnet:publication_resource", resourceTypeGeneral)) != null) {
            return new Tuple3((Object)typeQualifier, (Object)vocabularies.getSynonymAsQualifier("dnet:result_typologies", typeQualifier.getClassid()), (Object)resourceTypeGeneral);
        }
        return null;
    }

    public Result getResult(String resourceType, String resourceTypeGeneral, String schemaOrg, VocabularyGroup vocabularies) {
        Tuple3<Qualifier, Qualifier, String> typeQualifiers = this.getTypeQualifier(resourceType, resourceTypeGeneral, schemaOrg, vocabularies);
        if (typeQualifiers == null) {
            return null;
        }
        Instance i = new Instance();
        i.setInstancetype((Qualifier)typeQualifiers._1());
        InstanceTypeMapping itm = new InstanceTypeMapping();
        itm.setOriginalType((String)typeQualifiers._3());
        itm.setVocabularyName("openaire::coar_resource_types_3_1");
        i.setInstanceTypeMapping((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InstanceTypeMapping[]{itm}))).asJava());
        String string = ((Qualifier)typeQualifiers._2()).getClassname();
        if ("dataset".equals(string)) {
            Dataset r = new Dataset();
            r.setInstance((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{i}))).asJava());
            return r;
        }
        if ("publication".equals(string)) {
            Publication r = new Publication();
            r.setInstance((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{i}))).asJava());
            return r;
        }
        if ("software".equals(string)) {
            Software r = new Software();
            r.setInstance((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{i}))).asJava());
            return r;
        }
        if ("other".equals(string)) {
            OtherResearchProduct r = new OtherResearchProduct();
            r.setInstance((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Instance[]{i}))).asJava());
            return r;
        }
        throw new MatchError((Object)string);
    }

    public boolean available_date(String input) {
        ObjectRef formats$lzy = ObjectRef.zero();
        ObjectRef json$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        List l = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(this.json$2(input, json$lzy, bitmap$0)).$bslash$bslash("dates")).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(JsonAST.JValue check$ifrefutable$1) {
                JsonAST.JValue jValue = check$ifrefutable$1;
                boolean bl = jValue instanceof JsonAST.JObject;
                return bl;
            }
        }).flatMap((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<String> apply(JsonAST.JValue x$2) {
                JsonAST.JValue jValue = x$2;
                if (jValue instanceof JsonAST.JObject) {
                    JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                    List dates = jObject.obj();
                    List list = (List)dates.withFilter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean apply(Tuple2<String, JsonAST.JValue> check$ifrefutable$2) {
                            Tuple2<String, JsonAST.JValue> tuple2 = check$ifrefutable$2;
                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                            if (option.isEmpty()) return false;
                            String string = (String)((Tuple2)option.get())._1();
                            JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                            if (!"dateType".equals(string)) return false;
                            if (!(jValue instanceof JsonAST.JString)) return false;
                            return true;
                        }
                    }).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply(Tuple2<String, JsonAST.JValue> x$1) {
                            Tuple2<String, JsonAST.JValue> tuple2 = x$1;
                            Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                            if (!option.isEmpty()) {
                                String string = (String)((Tuple2)option.get())._1();
                                JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                if ("dateType".equals(string) && jValue instanceof JsonAST.JString) {
                                    String dateTypes;
                                    JsonAST.JString jString = (JsonAST.JString)jValue;
                                    String string2 = dateTypes = jString.s();
                                    return string2;
                                }
                            }
                            throw new MatchError(tuple2);
                        }
                    }, List$.MODULE$.canBuildFrom());
                    return list;
                }
                throw new MatchError((Object)jValue);
            }
        });
        return l.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String p) {
                return p.equalsIgnoreCase("available");
            }
        });
    }

    public void fix_figshare(Result r) {
        boolean hosted_by_figshare;
        if (r.getInstance() != null && (hosted_by_figshare = ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(r.getInstance()).asScala()).exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Instance i) {
                return i.getHostedby() != null && "figshare".equalsIgnoreCase(i.getHostedby().getValue());
            }
        }))) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(r.getInstance()).asScala()).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Instance i) {
                    i.setAccessright(ModelConstants.OPEN_ACCESS_RIGHT());
                }
            });
            Nil$ l = Nil$.MODULE$;
            r.setSubject((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)l).asJava());
        }
    }

    public String createDNetTargetIdentifier(String pid, String pidType, String idPrefix) {
        String f_part = (String)new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "|", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{idPrefix, pidType.toLowerCase()})))).padTo(15, (Object)BoxesRunTime.boxToCharacter((char)'_'), Predef$.MODULE$.StringCanBuildFrom());
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "::", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{f_part, IdentifierFactory.md5((String)pid.toLowerCase())}));
    }

    public StructuredProperty generateOAFDate(String dt, Qualifier q) {
        return OafMapperUtils.structuredProperty((String)dt, (Qualifier)q, null);
    }

    public Relation generateRelation(String sourceId, String targetId, String relClass, KeyValue cf, DataInfo di) {
        Relation r = new Relation();
        r.setSource(sourceId);
        r.setTarget(targetId);
        r.setRelType("resultProject");
        r.setRelClass(relClass);
        r.setSubRelType("outcome");
        r.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyValue[]{cf}))).asJava());
        r.setDataInfo(di);
        return r;
    }

    public List<Relation> get_projectRelation(String awardUri, String sourceId) {
        Nil$ nil$;
        Option match_pattern = DataciteModelConstants$.MODULE$.funder_regex().find((Function1)new Serializable(awardUri){
            public static final long serialVersionUID = 0L;
            private final String awardUri$1;

            public final boolean apply(Tuple2<Pattern, String> s) {
                return ((Pattern)s._1()).matcher(this.awardUri$1).find();
            }
            {
                this.awardUri$1 = awardUri$1;
            }
        });
        if (match_pattern.isDefined()) {
            Pattern m = (Pattern)((Tuple2)match_pattern.get())._1();
            String p = (String)((Tuple2)match_pattern.get())._2();
            String grantId = m.matcher(awardUri).replaceAll("$2");
            String targetId = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{p, DHPUtils.md5((String)grantId)}));
            nil$ = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Relation[]{this.generateRelation(sourceId, targetId, "isProducedBy", DataciteModelConstants$.MODULE$.DATACITE_COLLECTED_FROM(), DataciteModelConstants$.MODULE$.dataInfo())}));
        } else {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    public List<Oaf> generateOAF(String input, long ts, long dateOfCollection, VocabularyGroup vocabularies, boolean exportLinks) {
        VolatileByteRef bitmap$0;
        ObjectRef formats$lzy = ObjectRef.zero();
        ObjectRef json$lzy = ObjectRef.zero();
        if (this.skip_record(input, this.json$3(input, json$lzy, bitmap$0 = VolatileByteRef.create((byte)0)))) {
            return Nil$.MODULE$;
        }
        String resourceType = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(this.json$3(input, json$lzy, bitmap$0)).$bslash("attributes")).$bslash("types")).$bslash("resourceType")).extractOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        }, (Formats)this.formats$4(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class));
        String resourceTypeGeneral = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(this.json$3(input, json$lzy, bitmap$0)).$bslash("attributes")).$bslash("types")).$bslash("resourceTypeGeneral")).extractOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        }, (Formats)this.formats$4(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class));
        String schemaOrg = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(this.json$3(input, json$lzy, bitmap$0)).$bslash("attributes")).$bslash("types")).$bslash("schemaOrg")).extractOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        }, (Formats)this.formats$4(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class));
        String doi = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(this.json$3(input, json$lzy, bitmap$0)).$bslash("attributes")).$bslash("doi")).extract((Formats)this.formats$4(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class));
        if (doi.isEmpty()) {
            return Nil$.MODULE$;
        }
        Result result = this.getResult(resourceType, resourceTypeGeneral, schemaOrg, vocabularies);
        if (result == null) {
            return Nil$.MODULE$;
        }
        Qualifier doi_q = OafMapperUtils.qualifier((String)"doi", (String)"doi", (String)"dnet:pid_types", (String)"dnet:pid_types");
        StructuredProperty pid = OafMapperUtils.structuredProperty((String)doi, (Qualifier)doi_q, (DataInfo)DataciteModelConstants$.MODULE$.dataInfo());
        result.setPid((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new StructuredProperty[]{pid}))).asJava());
        result.setId(OafMapperUtils.createOpenaireId((int)50, (String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"datacite____::", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{doi})), (boolean)true));
        result.setOriginalId((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{doi}))).asJava());
        Date d = new Date(dateOfCollection * 1000L);
        SimpleDateFormat ISO8601FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
        result.setDateofcollection(ISO8601FORMAT.format(d));
        result.setDateoftransformation(ISO8601FORMAT.format(d));
        result.setDataInfo(DataciteModelConstants$.MODULE$.dataInfo());
        List creators = (List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(this.json$3(input, json$lzy, bitmap$0)).$bslash$bslash("creators")).extractOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final List<Nothing$> apply() {
                return Nil$.MODULE$;
            }
        }, (Formats)this.formats$4(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(CreatorType.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
        List authors = (List)((List)creators.zipWithIndex(List$.MODULE$.canBuildFrom())).map((Function1)new Serializable(vocabularies){
            public static final long serialVersionUID = 0L;
            public final VocabularyGroup vocabularies$1;

            public final Author apply(Tuple2<CreatorType, Object> x0$1) {
                Tuple2<CreatorType, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    CreatorType c = (CreatorType)tuple2._1();
                    int idx = tuple2._2$mcI$sp();
                    Author a = new Author();
                    a.setFullname((String)c.name().orNull(Predef$.MODULE$.$conforms()));
                    a.setName((String)c.givenName().orNull(Predef$.MODULE$.$conforms()));
                    a.setSurname((String)c.familyName().orNull(Predef$.MODULE$.$conforms()));
                    if (c.nameIdentifiers() != null && c.nameIdentifiers().isDefined() && c.nameIdentifiers().get() != null) {
                        a.setPid((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)c.nameIdentifiers().get()).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.11 $outer;

                            public final StructuredProperty apply(NameIdentifiersType ni) {
                                Qualifier q = ni.nameIdentifierScheme().isDefined() ? this.$outer.vocabularies$1.getTermAsQualifier("dnet:pid_types", ((String)ni.nameIdentifierScheme().get()).toLowerCase()) : null;
                                return ni.nameIdentifier() != null && ni.nameIdentifier().isDefined() ? OafMapperUtils.structuredProperty((String)((String)ni.nameIdentifier().get()), (Qualifier)q, (DataInfo)DataciteModelConstants$.MODULE$.dataInfo()) : null;
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }, List$.MODULE$.canBuildFrom())).asJava());
                    }
                    if (c.affiliation().isDefined()) {
                        a.setRawAffiliationString((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)c.affiliation().get()).filter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(String af) {
                                return new StringOps(Predef$.MODULE$.augmentString(af)).nonEmpty();
                            }
                        })).asJava());
                    }
                    a.setRank(Predef$.MODULE$.int2Integer(idx + 1));
                    Author author = a;
                    return author;
                }
                throw new MatchError(tuple2);
            }
            {
                this.vocabularies$1 = vocabularies$1;
            }
        }, List$.MODULE$.canBuildFrom());
        if (authors != null && !authors.isEmpty() && authors.exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Author a) {
                return a != null;
            }
        })) {
            List list;
            AccessRight access_rights_qualifier;
            String language;
            result.setAuthor((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)authors).asJava());
            List titles = (List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(this.json$3(input, json$lzy, bitmap$0)).$bslash$bslash("titles")).extractOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final List<Nothing$> apply() {
                    return Nil$.MODULE$;
                }
            }, (Formats)this.formats$4(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(TitleType.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
            result.setTitle((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)titles.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(TitleType t) {
                    return t.title().nonEmpty();
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final StructuredProperty apply(TitleType t) {
                    return t.titleType().isEmpty() ? OafMapperUtils.structuredProperty((String)((String)t.title().get()), (Qualifier)ModelConstants.MAIN_TITLE_QUALIFIER, null) : OafMapperUtils.structuredProperty((String)((String)t.title().get()), (String)((String)t.titleType().get()), (String)((String)t.titleType().get()), (String)"dnet:dataCite_title", (String)"dnet:dataCite_title", null);
                }
            }, List$.MODULE$.canBuildFrom())).asJava());
            List dates = (List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(this.json$3(input, json$lzy, bitmap$0)).$bslash$bslash("dates")).extract((Formats)this.formats$4(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(DateType.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
            String publication_year = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(this.json$3(input, json$lzy, bitmap$0)).$bslash$bslash("publicationYear")).extractOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            }, (Formats)this.formats$4(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class));
            Option i_date = ((LinearSeqOptimized)dates.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(DateType d) {
                    return d.date().isDefined() && d.dateType().isDefined();
                }
            })).find((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(DateType d) {
                    return ((String)d.dateType().get()).equalsIgnoreCase("issued");
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply(DateType d) {
                    return DataciteToOAFTransformation$.MODULE$.extract_date((String)d.date().get());
                }
            });
            Option a_date = ((LinearSeqOptimized)((List)dates.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(DateType d) {
                    return d.date().isDefined() && d.dateType().isDefined() && ((String)d.dateType().get()).equalsIgnoreCase("available");
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Option<String> apply(DateType d) {
                    return DataciteToOAFTransformation$.MODULE$.extract_date((String)d.date().get());
                }
            }, List$.MODULE$.canBuildFrom())).find((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Option<String> d) {
                    return d != null && d.isDefined();
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Option<String> d) {
                    return (String)d.get();
                }
            });
            if (a_date.isDefined()) {
                if (doi.startsWith("10.14457")) {
                    result.setEmbargoenddate(OafMapperUtils.field((Object)this.fix_thai_date((String)a_date.get(), "[yyyy-MM-dd]"), null));
                } else {
                    result.setEmbargoenddate(OafMapperUtils.field((Object)a_date.get(), null));
                }
            }
            if (i_date.isDefined() && ((Option)i_date.get()).isDefined()) {
                if (doi.startsWith("10.14457")) {
                    result.setDateofacceptance(OafMapperUtils.field((Object)this.fix_thai_date((String)((Option)i_date.get()).get(), "[yyyy-MM-dd]"), null));
                    ((Instance)result.getInstance().get(0)).setDateofacceptance(OafMapperUtils.field((Object)this.fix_thai_date((String)((Option)i_date.get()).get(), "[yyyy-MM-dd]"), null));
                } else {
                    result.setDateofacceptance(OafMapperUtils.field((Object)((Option)i_date.get()).get(), null));
                    ((Instance)result.getInstance().get(0)).setDateofacceptance(OafMapperUtils.field((Object)((Option)i_date.get()).get(), null));
                }
            } else if (publication_year != null) {
                if (doi.startsWith("10.14457")) {
                    result.setDateofacceptance(OafMapperUtils.field((Object)this.fix_thai_date(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"01-01-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{publication_year})), "[dd-MM-yyyy]"), null));
                    ((Instance)result.getInstance().get(0)).setDateofacceptance(OafMapperUtils.field((Object)this.fix_thai_date(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"01-01-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{publication_year})), "[dd-MM-yyyy]"), null));
                } else {
                    result.setDateofacceptance(OafMapperUtils.field((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"01-01-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{publication_year})), null));
                    ((Instance)result.getInstance().get(0)).setDateofacceptance(OafMapperUtils.field((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"01-01-", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{publication_year})), null));
                }
            }
            result.setRelevantdate((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)((TraversableLike)((List)((TraversableLike)((List)dates.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(DateType d) {
                    return d.date().isDefined() && d.dateType().isDefined();
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Option<String>, String> apply(DateType d) {
                    return new Tuple2(DataciteToOAFTransformation$.MODULE$.extract_date((String)d.date().get()), d.dateType().get());
                }
            }, List$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Option<String>, String> d) {
                    return ((Option)d._1()).isDefined();
                }
            })).map((Function1)new Serializable(vocabularies){
                public static final long serialVersionUID = 0L;
                private final VocabularyGroup vocabularies$1;

                public final Tuple2<String, Qualifier> apply(Tuple2<Option<String>, String> d) {
                    return new Tuple2(((Option)d._1()).get(), (Object)this.vocabularies$1.getTermAsQualifier("dnet:dataCite_date", ((String)d._2()).toLowerCase()));
                }
                {
                    this.vocabularies$1 = vocabularies$1;
                }
            }, List$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, Qualifier> d) {
                    return d._2() != null;
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final StructuredProperty apply(Tuple2<String, Qualifier> d) {
                    return DataciteToOAFTransformation$.MODULE$.generateOAFDate((String)d._1(), (Qualifier)d._2());
                }
            }, List$.MODULE$.canBuildFrom())).asJava());
            List subjects = (List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(this.json$3(input, json$lzy, bitmap$0)).$bslash$bslash("subjects")).extract((Formats)this.formats$4(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(SubjectType.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
            result.setSubject((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((List)subjects.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(SubjectType s) {
                    return s.subject().nonEmpty();
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Subject apply(SubjectType s) {
                    return OafMapperUtils.subject((String)((String)s.subject().get()), (String)DataciteModelConstants$.MODULE$.SUBJ_CLASS(), (String)DataciteModelConstants$.MODULE$.SUBJ_CLASS(), (String)"dnet:subject_classification_typologies", (String)"dnet:subject_classification_typologies", null);
                }
            }, List$.MODULE$.canBuildFrom())).asJava());
            result.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyValue[]{DataciteModelConstants$.MODULE$.DATACITE_COLLECTED_FROM()}))).asJava());
            List descriptions = (List)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(this.json$3(input, json$lzy, bitmap$0)).$bslash$bslash("descriptions")).extract((Formats)this.formats$4(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(List.class, ManifestFactory$.MODULE$.classType(DescriptionType.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[0])));
            result.setDescription((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)((TraversableLike)((List)descriptions.filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(DescriptionType d) {
                    return d.description().isDefined();
                }
            })).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Field<String> apply(DescriptionType d) {
                    return OafMapperUtils.field((Object)d.description().get(), null);
                }
            }, List$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Field<String> s) {
                    return s != null;
                }
            })).asJava());
            String publisher = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(this.json$3(input, json$lzy, bitmap$0)).$bslash$bslash("publisher")).extractOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            }, (Formats)this.formats$4(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class));
            if (publisher != null) {
                result.setPublisher(OafMapperUtils.field((Object)publisher, null));
            }
            if ((language = (String)package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(this.json$3(input, json$lzy, bitmap$0)).$bslash$bslash("language")).extractOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Null$ apply() {
                    return null;
                }
            }, (Formats)this.formats$4(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class))) != null) {
                result.setLanguage(vocabularies.getSynonymAsQualifier("dnet:languages", language));
            }
            Instance instance = (Instance)result.getInstance().get(0);
            Option client = package$.MODULE$.jvalue2extractable(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(this.json$3(input, json$lzy, bitmap$0)).$bslash("relationships")).$bslash("client")).$bslash$bslash("id")).extractOpt((Formats)this.formats$4(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(String.class));
            List accessRights = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(this.json$3(input, json$lzy, bitmap$0)).$bslash$bslash("rightsList")).withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(JsonAST.JValue check$ifrefutable$3) {
                    JsonAST.JValue jValue = check$ifrefutable$3;
                    boolean bl = jValue instanceof JsonAST.JObject;
                    return bl;
                }
            }).flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final List<String> apply(JsonAST.JValue x$4) {
                    JsonAST.JValue jValue = x$4;
                    if (jValue instanceof JsonAST.JObject) {
                        JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                        List rightsList = jObject.obj();
                        List list = (List)rightsList.withFilter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final boolean apply(Tuple2<String, JsonAST.JValue> check$ifrefutable$4) {
                                Tuple2<String, JsonAST.JValue> tuple2 = check$ifrefutable$4;
                                Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                if (option.isEmpty()) return false;
                                String string = (String)((Tuple2)option.get())._1();
                                JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                if (!"rightsUri".equals(string)) return false;
                                if (!(jValue instanceof JsonAST.JString)) return false;
                                return true;
                            }
                        }).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(Tuple2<String, JsonAST.JValue> x$3) {
                                Tuple2<String, JsonAST.JValue> tuple2 = x$3;
                                Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                if (!option.isEmpty()) {
                                    String string = (String)((Tuple2)option.get())._1();
                                    JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                    if ("rightsUri".equals(string) && jValue instanceof JsonAST.JString) {
                                        String rightsUri;
                                        JsonAST.JString jString = (JsonAST.JString)jValue;
                                        String string2 = rightsUri = jString.s();
                                        return string2;
                                    }
                                }
                                throw new MatchError(tuple2);
                            }
                        }, List$.MODULE$.canBuildFrom());
                        return list;
                    }
                    throw new MatchError((Object)jValue);
                }
            });
            Option aRights = ((LinearSeqOptimized)accessRights.map((Function1)new Serializable(vocabularies){
                public static final long serialVersionUID = 0L;
                private final VocabularyGroup vocabularies$1;

                public final Qualifier apply(String r) {
                    return this.vocabularies$1.getSynonymAsQualifier("dnet:access_modes", r);
                }
                {
                    this.vocabularies$1 = vocabularies$1;
                }
            }, List$.MODULE$.canBuildFrom())).find((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Qualifier q) {
                    return q != null;
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                /*
                 * WARNING - void declaration
                 */
                public final AccessRight apply(Qualifier q) {
                    void var2_2;
                    AccessRight a = new AccessRight();
                    a.setClassid(q.getClassid());
                    a.setClassname(q.getClassname());
                    a.setSchemeid(q.getSchemeid());
                    a.setSchemename(q.getSchemename());
                    return var2_2;
                }
            });
            AccessRight accessRight = access_rights_qualifier = aRights.isDefined() ? (AccessRight)aRights.get() : OafMapperUtils.accessRight((String)"UNKNOWN", (String)"not available", (String)"dnet:access_modes", (String)"dnet:access_modes");
            if (client.isDefined()) {
                DataciteToOAFTransformation.HostedByMapType hb = (DataciteToOAFTransformation.HostedByMapType)this.hostedByMap().getOrElse((Object)((String)client.get()).toUpperCase(), (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final DataciteToOAFTransformation.HostedByMapType apply() {
                        return DataciteToOAFTransformation$.MODULE$.unknown_repository();
                    }
                });
                instance.setHostedby(OafMapperUtils.keyValue((String)this.generateDSId(hb.openaire_id()), (String)hb.official_name()));
                instance.setCollectedfrom(DataciteModelConstants$.MODULE$.DATACITE_COLLECTED_FROM());
                instance.setUrl((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"https://dx.doi.org/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{doi}))}))).asJava());
                instance.setAccessright(access_rights_qualifier);
                instance.setPid(result.getPid());
                Option license = accessRights.find((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String r) {
                        return r.startsWith("http") && r.matches(".*(/licenses|/publicdomain|unlicense\\.org/|/legal-and-data-protection-notices|/download/license|/open-government-licence).*");
                    }
                });
                if (license.isDefined()) {
                    instance.setLicense(OafMapperUtils.field((Object)license.get(), null));
                }
            }
            List awardUris = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(this.json$3(input, json$lzy, bitmap$0)).$bslash$bslash("fundingReferences")).withFilter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(JsonAST.JValue check$ifrefutable$5) {
                    JsonAST.JValue jValue = check$ifrefutable$5;
                    boolean bl = jValue instanceof JsonAST.JObject;
                    return bl;
                }
            }).flatMap((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final List<String> apply(JsonAST.JValue x$6) {
                    JsonAST.JValue jValue = x$6;
                    if (jValue instanceof JsonAST.JObject) {
                        JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                        List fundingReferences = jObject.obj();
                        List list = (List)fundingReferences.withFilter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            /*
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final boolean apply(Tuple2<String, JsonAST.JValue> check$ifrefutable$6) {
                                Tuple2<String, JsonAST.JValue> tuple2 = check$ifrefutable$6;
                                Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                if (option.isEmpty()) return false;
                                String string = (String)((Tuple2)option.get())._1();
                                JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                if (!"awardUri".equals(string)) return false;
                                if (!(jValue instanceof JsonAST.JString)) return false;
                                return true;
                            }
                        }).map((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply(Tuple2<String, JsonAST.JValue> x$5) {
                                Tuple2<String, JsonAST.JValue> tuple2 = x$5;
                                Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                if (!option.isEmpty()) {
                                    String string = (String)((Tuple2)option.get())._1();
                                    JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                    if ("awardUri".equals(string) && jValue instanceof JsonAST.JString) {
                                        String awardUri;
                                        JsonAST.JString jString = (JsonAST.JString)jValue;
                                        String string2 = awardUri = jString.s();
                                        return string2;
                                    }
                                }
                                throw new MatchError(tuple2);
                            }
                        }, List$.MODULE$.canBuildFrom());
                        return list;
                    }
                    throw new MatchError((Object)jValue);
                }
            });
            String oid = result.getId();
            result.setId(IdentifierFactory.createIdentifier((OafEntity)result));
            if (!result.getId().equalsIgnoreCase(oid)) {
                String string = oid;
                result.setOriginalId((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{doi})).$colon$colon((Object)string)).asJava());
            }
            List relations = (List)((TraversableLike)awardUris.flatMap((Function1)new Serializable(result){
                public static final long serialVersionUID = 0L;
                private final Result result$1;

                public final List<Relation> apply(String a) {
                    return DataciteToOAFTransformation$.MODULE$.get_projectRelation(a, this.result$1.getId());
                }
                {
                    this.result$1 = result$1;
                }
            }, List$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Relation r) {
                    return r != null;
                }
            });
            this.fix_figshare(result);
            if (result.getId() == null) {
                return Nil$.MODULE$;
            }
            if (exportLinks) {
                List rels = package$.MODULE$.jvalue2monadic(package$.MODULE$.jvalue2monadic(this.json$3(input, json$lzy, bitmap$0)).$bslash$bslash("relatedIdentifiers")).withFilter((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(JsonAST.JValue check$ifrefutable$7) {
                        JsonAST.JValue jValue = check$ifrefutable$7;
                        boolean bl = jValue instanceof JsonAST.JObject;
                        return bl;
                    }
                }).flatMap((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final List<RelatedIdentifierType> apply(JsonAST.JValue x$11) {
                        JsonAST.JValue jValue = x$11;
                        if (jValue instanceof JsonAST.JObject) {
                            JsonAST.JObject jObject = (JsonAST.JObject)jValue;
                            List relIdentifier = jObject.obj();
                            List list = (List)relIdentifier.withFilter((Function1)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                /*
                                 * Enabled force condition propagation
                                 * Lifted jumps to return sites
                                 */
                                public final boolean apply(Tuple2<String, JsonAST.JValue> check$ifrefutable$8) {
                                    Tuple2<String, JsonAST.JValue> tuple2 = check$ifrefutable$8;
                                    Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                    if (option.isEmpty()) return false;
                                    String string = (String)((Tuple2)option.get())._1();
                                    JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                    if (!"relationType".equals(string)) return false;
                                    if (!(jValue instanceof JsonAST.JString)) return false;
                                    return true;
                                }
                            }).flatMap((Function1)new Serializable(this, relIdentifier){
                                public static final long serialVersionUID = 0L;
                                public final List relIdentifier$1;

                                public final List<RelatedIdentifierType> apply(Tuple2<String, JsonAST.JValue> x$10) {
                                    Tuple2<String, JsonAST.JValue> tuple2 = x$10;
                                    Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                    if (!option.isEmpty()) {
                                        String string = (String)((Tuple2)option.get())._1();
                                        JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                        if ("relationType".equals(string) && jValue instanceof JsonAST.JString) {
                                            JsonAST.JString jString = (JsonAST.JString)jValue;
                                            String relationType = jString.s();
                                            List list = (List)this.relIdentifier$1.withFilter((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;

                                                /*
                                                 * Enabled force condition propagation
                                                 * Lifted jumps to return sites
                                                 */
                                                public final boolean apply(Tuple2<String, JsonAST.JValue> check$ifrefutable$9) {
                                                    Tuple2<String, JsonAST.JValue> tuple2 = check$ifrefutable$9;
                                                    Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                    if (option.isEmpty()) return false;
                                                    String string = (String)((Tuple2)option.get())._1();
                                                    JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                                    if (!"relatedIdentifierType".equals(string)) return false;
                                                    if (!(jValue instanceof JsonAST.JString)) return false;
                                                    return true;
                                                }
                                            }).flatMap((Function1)new Serializable(this, relationType){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ anonfun$35$$anonfun$apply$10 $outer;
                                                public final String relationType$1;

                                                public final List<RelatedIdentifierType> apply(Tuple2<String, JsonAST.JValue> x$9) {
                                                    Tuple2<String, JsonAST.JValue> tuple2 = x$9;
                                                    Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                    if (!option.isEmpty()) {
                                                        String string = (String)((Tuple2)option.get())._1();
                                                        JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                                        if ("relatedIdentifierType".equals(string) && jValue instanceof JsonAST.JString) {
                                                            JsonAST.JString jString = (JsonAST.JString)jValue;
                                                            String relatedIdentifierType = jString.s();
                                                            List list = (List)this.$outer.relIdentifier$1.withFilter((Function1)new Serializable(this){
                                                                public static final long serialVersionUID = 0L;

                                                                /*
                                                                 * Enabled force condition propagation
                                                                 * Lifted jumps to return sites
                                                                 */
                                                                public final boolean apply(Tuple2<String, JsonAST.JValue> check$ifrefutable$10) {
                                                                    Tuple2<String, JsonAST.JValue> tuple2 = check$ifrefutable$10;
                                                                    Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                                    if (option.isEmpty()) return false;
                                                                    String string = (String)((Tuple2)option.get())._1();
                                                                    JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                                                    if (!"relatedIdentifier".equals(string)) return false;
                                                                    if (!(jValue instanceof JsonAST.JString)) return false;
                                                                    return true;
                                                                }
                                                            }).map((Function1)new Serializable(this, relatedIdentifierType){
                                                                public static final long serialVersionUID = 0L;
                                                                private final /* synthetic */ anonfun$35$$anonfun$apply$10$$anonfun$apply$12 $outer;
                                                                private final String relatedIdentifierType$1;

                                                                public final RelatedIdentifierType apply(Tuple2<String, JsonAST.JValue> x$8) {
                                                                    Tuple2<String, JsonAST.JValue> tuple2 = x$8;
                                                                    Option option = JsonAST.JField$.MODULE$.unapply(tuple2);
                                                                    if (!option.isEmpty()) {
                                                                        String string = (String)((Tuple2)option.get())._1();
                                                                        JsonAST.JValue jValue = (JsonAST.JValue)((Tuple2)option.get())._2();
                                                                        if ("relatedIdentifier".equals(string) && jValue instanceof JsonAST.JString) {
                                                                            JsonAST.JString jString = (JsonAST.JString)jValue;
                                                                            String relatedIdentifier = jString.s();
                                                                            RelatedIdentifierType relatedIdentifierType = new RelatedIdentifierType(this.$outer.relationType$1, relatedIdentifier, this.relatedIdentifierType$1);
                                                                            return relatedIdentifierType;
                                                                        }
                                                                    }
                                                                    throw new MatchError(tuple2);
                                                                }
                                                                {
                                                                    if ($outer == null) {
                                                                        throw null;
                                                                    }
                                                                    this.$outer = $outer;
                                                                    this.relatedIdentifierType$1 = relatedIdentifierType$1;
                                                                }
                                                            }, List$.MODULE$.canBuildFrom());
                                                            return list;
                                                        }
                                                    }
                                                    throw new MatchError(tuple2);
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                    this.relationType$1 = relationType$1;
                                                }
                                            }, List$.MODULE$.canBuildFrom());
                                            return list;
                                        }
                                    }
                                    throw new MatchError(tuple2);
                                }
                                {
                                    this.relIdentifier$1 = relIdentifier$1;
                                }
                            }, List$.MODULE$.canBuildFrom());
                            return list;
                        }
                        throw new MatchError((Object)jValue);
                    }
                });
                List list2 = relations;
                relations = this.generateRelations((List<RelatedIdentifierType>)rels, result.getId(), i_date.isDefined() && ((Option)i_date.get()).isDefined() ? (String)((Option)i_date.get()).get() : null).$colon$colon$colon(list2);
            }
            if (relations != null && relations.nonEmpty()) {
                List list3 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Result[]{result}));
                list = relations.$colon$colon$colon(list3);
            } else {
                list = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Result[]{result}));
            }
            return list;
        }
        return Nil$.MODULE$;
    }

    private List<Relation> generateRelations(List<RelatedIdentifierType> rels, String id, String date) {
        List citationRels;
        List bidirectionalRels = (List)((List)rels.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RelatedIdentifierType r) {
                return DataciteModelConstants$.MODULE$.subRelTypeMapping().contains((Object)r.relationType()) && r.relatedIdentifierType().equalsIgnoreCase("doi");
            }
        })).map((Function1)new Serializable(id, date){
            public static final long serialVersionUID = 0L;
            private final String id$1;
            private final String date$1;

            public final Relation apply(RelatedIdentifierType r) {
                String subRelType = ((OAFRelations)DataciteModelConstants$.MODULE$.subRelTypeMapping().apply((Object)r.relationType())).relType();
                String targetPid = PidCleaner.normalizePidValue((String)r.relatedIdentifierType(), (String)r.relatedIdentifier());
                String target = DHPUtils.generateIdentifier((String)targetPid, (String)DataciteToOAFTransformation$.MODULE$.DOI_PREFIX());
                return DataciteToOAFTransformation$.MODULE$.relation(this.id$1, target, subRelType, r.relationType(), this.date$1);
            }
            {
                this.id$1 = id$1;
                this.date$1 = date$1;
            }
        }, List$.MODULE$.canBuildFrom());
        List list = citationRels = (List)((List)rels.filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(RelatedIdentifierType r) {
                return r.relatedIdentifierType().equalsIgnoreCase("doi") && (r.relationType().toLowerCase().contains("cite") || r.relationType().toLowerCase().contains("reference"));
            }
        })).map((Function1)new Serializable(id, date){
            public static final long serialVersionUID = 0L;
            private final String id$1;
            private final String date$1;

            public final Relation apply(RelatedIdentifierType r) {
                String string;
                block4: {
                    Relation relation2;
                    block3: {
                        String relatedID;
                        block2: {
                            String targetPid = PidCleaner.normalizePidValue((String)r.relatedIdentifierType(), (String)r.relatedIdentifier());
                            relatedID = DHPUtils.generateIdentifier((String)targetPid, (String)DataciteToOAFTransformation$.MODULE$.DOI_PREFIX());
                            string = r.relationType();
                            boolean bl = "Cites".equals(string) ? true : "References".equals(string);
                            if (!bl) break block2;
                            relation2 = DataciteToOAFTransformation$.MODULE$.relation(this.id$1, relatedID, "citation", "Cites", this.date$1);
                            break block3;
                        }
                        boolean bl = "IsCitedBy".equals(string) ? true : "IsReferencedBy".equals(string);
                        if (!bl) break block4;
                        relation2 = DataciteToOAFTransformation$.MODULE$.relation(relatedID, this.id$1, "citation", "Cites", this.date$1);
                    }
                    return relation2;
                }
                throw new MatchError((Object)string);
            }
            {
                this.id$1 = id$1;
                this.date$1 = date$1;
            }
        }, List$.MODULE$.canBuildFrom());
        return bidirectionalRels.$colon$colon$colon(list);
    }

    public Relation relation(String source, String target, String subRelType, String relClass, String date) {
        Relation rel = new Relation();
        rel.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyValue[]{DataciteModelConstants$.MODULE$.DATACITE_COLLECTED_FROM()}))).asJava());
        rel.setDataInfo(DataciteModelConstants$.MODULE$.dataInfo());
        rel.setRelType(DataciteModelConstants$.MODULE$.REL_TYPE_VALUE());
        rel.setSubRelType(subRelType);
        rel.setRelClass(relClass);
        KeyValue dateProps = OafMapperUtils.keyValue((String)DataciteModelConstants$.MODULE$.DATE_RELATION_KEY(), (String)date);
        rel.setProperties((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyValue[]{dateProps}))).asJava());
        rel.setSource(source);
        rel.setTarget(target);
        rel.setCollectedfrom((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyValue[]{DataciteModelConstants$.MODULE$.DATACITE_COLLECTED_FROM()}))).asJava());
        ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(rel.getCollectedfrom()).asScala()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(KeyValue c) {
                return c.getValue();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toList();
        return rel;
    }

    public String generateDSId(String input) {
        String b = StringUtils.substringBefore((String)input, (String)"::");
        String a = StringUtils.substringAfter((String)input, (String)"::");
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"10|", "::", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{b, DHPUtils.md5((String)a)}));
    }

    private final DefaultFormats$ formats$lzycompute$1(ObjectRef formats$lzy$1, VolatileByteRef bitmap$0$1) {
        DataciteToOAFTransformation$ dataciteToOAFTransformation$ = this;
        synchronized (dataciteToOAFTransformation$) {
            if ((byte)(bitmap$0$1.elem & 1) == 0) {
                formats$lzy$1.elem = DefaultFormats$.MODULE$;
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 1);
            }
            return (DefaultFormats$)formats$lzy$1.elem;
        }
    }

    private final DefaultFormats$ formats$1(ObjectRef formats$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 1) == 0 ? this.formats$lzycompute$1(formats$lzy$1, bitmap$0$1) : (DefaultFormats$)formats$lzy$1.elem;
    }

    private final JsonAST.JValue json$lzycompute$1(String s$1, ObjectRef json$lzy$1, VolatileByteRef bitmap$0$1) {
        DataciteToOAFTransformation$ dataciteToOAFTransformation$ = this;
        synchronized (dataciteToOAFTransformation$) {
            if ((byte)(bitmap$0$1.elem & 2) == 0) {
                json$lzy$1.elem = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(s$1), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
                bitmap$0$1.elem = (byte)(bitmap$0$1.elem | 2);
            }
            return (JsonAST.JValue)json$lzy$1.elem;
        }
    }

    private final JsonAST.JValue json$1(String s$1, ObjectRef json$lzy$1, VolatileByteRef bitmap$0$1) {
        return (byte)(bitmap$0$1.elem & 2) == 0 ? this.json$lzycompute$1(s$1, json$lzy$1, bitmap$0$1) : (JsonAST.JValue)json$lzy$1.elem;
    }

    private final DefaultFormats$ formats$lzycompute$2(ObjectRef formats$lzy$2, VolatileByteRef bitmap$0$2) {
        DataciteToOAFTransformation$ dataciteToOAFTransformation$ = this;
        synchronized (dataciteToOAFTransformation$) {
            if ((byte)(bitmap$0$2.elem & 1) == 0) {
                formats$lzy$2.elem = DefaultFormats$.MODULE$;
                bitmap$0$2.elem = (byte)(bitmap$0$2.elem | 1);
            }
            return (DefaultFormats$)formats$lzy$2.elem;
        }
    }

    private final DefaultFormats$ formats$2(ObjectRef formats$lzy$2, VolatileByteRef bitmap$0$2) {
        return (byte)(bitmap$0$2.elem & 1) == 0 ? this.formats$lzycompute$2(formats$lzy$2, bitmap$0$2) : (DefaultFormats$)formats$lzy$2.elem;
    }

    private final DefaultFormats$ formats$lzycompute$3(ObjectRef formats$lzy$3, VolatileByteRef bitmap$0$3) {
        DataciteToOAFTransformation$ dataciteToOAFTransformation$ = this;
        synchronized (dataciteToOAFTransformation$) {
            if ((byte)(bitmap$0$3.elem & 1) == 0) {
                formats$lzy$3.elem = DefaultFormats$.MODULE$;
                bitmap$0$3.elem = (byte)(bitmap$0$3.elem | 1);
            }
            return (DefaultFormats$)formats$lzy$3.elem;
        }
    }

    private final DefaultFormats$ formats$3(ObjectRef formats$lzy$3, VolatileByteRef bitmap$0$3) {
        return (byte)(bitmap$0$3.elem & 1) == 0 ? this.formats$lzycompute$3(formats$lzy$3, bitmap$0$3) : (DefaultFormats$)formats$lzy$3.elem;
    }

    private final JsonAST.JValue json$lzycompute$2(String input$2, ObjectRef json$lzy$2, VolatileByteRef bitmap$0$3) {
        DataciteToOAFTransformation$ dataciteToOAFTransformation$ = this;
        synchronized (dataciteToOAFTransformation$) {
            if ((byte)(bitmap$0$3.elem & 2) == 0) {
                json$lzy$2.elem = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(input$2), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
                bitmap$0$3.elem = (byte)(bitmap$0$3.elem | 2);
            }
            return (JsonAST.JValue)json$lzy$2.elem;
        }
    }

    private final JsonAST.JValue json$2(String input$2, ObjectRef json$lzy$2, VolatileByteRef bitmap$0$3) {
        return (byte)(bitmap$0$3.elem & 2) == 0 ? this.json$lzycompute$2(input$2, json$lzy$2, bitmap$0$3) : (JsonAST.JValue)json$lzy$2.elem;
    }

    private final DefaultFormats$ formats$lzycompute$4(ObjectRef formats$lzy$4, VolatileByteRef bitmap$0$4) {
        DataciteToOAFTransformation$ dataciteToOAFTransformation$ = this;
        synchronized (dataciteToOAFTransformation$) {
            if ((byte)(bitmap$0$4.elem & 1) == 0) {
                formats$lzy$4.elem = DefaultFormats$.MODULE$;
                bitmap$0$4.elem = (byte)(bitmap$0$4.elem | 1);
            }
            return (DefaultFormats$)formats$lzy$4.elem;
        }
    }

    private final DefaultFormats$ formats$4(ObjectRef formats$lzy$4, VolatileByteRef bitmap$0$4) {
        return (byte)(bitmap$0$4.elem & 1) == 0 ? this.formats$lzycompute$4(formats$lzy$4, bitmap$0$4) : (DefaultFormats$)formats$lzy$4.elem;
    }

    private final JsonAST.JValue json$lzycompute$3(String input$3, ObjectRef json$lzy$3, VolatileByteRef bitmap$0$4) {
        DataciteToOAFTransformation$ dataciteToOAFTransformation$ = this;
        synchronized (dataciteToOAFTransformation$) {
            if ((byte)(bitmap$0$4.elem & 2) == 0) {
                json$lzy$3.elem = JsonMethods$.MODULE$.parse(package$.MODULE$.string2JsonInput(input$3), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3());
                bitmap$0$4.elem = (byte)(bitmap$0$4.elem | 2);
            }
            return (JsonAST.JValue)json$lzy$3.elem;
        }
    }

    private final JsonAST.JValue json$3(String input$3, ObjectRef json$lzy$3, VolatileByteRef bitmap$0$4) {
        return (byte)(bitmap$0$4.elem & 2) == 0 ? this.json$lzycompute$3(input$3, json$lzy$3, bitmap$0$4) : (JsonAST.JValue)json$lzy$3.elem;
    }

    private DataciteToOAFTransformation$() {
        MODULE$ = this;
        this.DOI_PREFIX = "50|doi_________";
        this.mapper = new ObjectMapper();
        this.unknown_repository = new DataciteToOAFTransformation.HostedByMapType("openaire____::1256f046-bf1f-4afc-8b47-d0b147148b18", ModelConstants.UNKNOWN_REPOSITORY.getValue(), ModelConstants.UNKNOWN_REPOSITORY.getValue(), (Option<Object>)new Some((Object)BoxesRunTime.boxToFloat((float)1.0f)));
        ObjectRef formats$lzy = ObjectRef.zero();
        ObjectRef json$lzy = ObjectRef.zero();
        VolatileByteRef bitmap$0 = VolatileByteRef.create((byte)0);
        String s = Source$.MODULE$.fromInputStream(this.getClass().getResourceAsStream("hostedBy_map.json"), Codec$.MODULE$.fallbackSystemCodec()).mkString();
        this.hostedByMap = (Map)package$.MODULE$.jvalue2extractable(this.json$1(s, json$lzy, bitmap$0)).extract((Formats)this.formats$1(formats$lzy, bitmap$0), ManifestFactory$.MODULE$.classType(Map.class, ManifestFactory$.MODULE$.classType(String.class), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Manifest[]{ManifestFactory$.MODULE$.classType(DataciteToOAFTransformation.HostedByMapType.class)})));
    }
}

