/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.sx.bio.ebi;

import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.sx.bio.BioDBToOAF;
import eu.dnetlib.dhp.sx.bio.ebi.SparkDownloadEBILinks$;
import eu.dnetlib.dhp.sx.bio.ebi.SparkEBILinksToOaf$;
import eu.dnetlib.dhp.sx.bio.pubmed.PMArticle;
import eu.dnetlib.dhp.sx.bio.pubmed.PMAuthor;
import eu.dnetlib.dhp.sx.bio.pubmed.PMJournal;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.spark.SparkConf;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.functions$;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class SparkDownloadEBILinks$ {
    public static final SparkDownloadEBILinks$ MODULE$;

    static {
        new SparkDownloadEBILinks$();
    }

    /*
     * WARNING - void declaration
     */
    public BioDBToOAF.EBILinkItem createEBILinks(long pmid) {
        void var3_2;
        String res = this.requestLinks(pmid);
        if (res == null) {
            return null;
        }
        return new BioDBToOAF.EBILinkItem(pmid, (String)var3_2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String requestPage(String url) {
        HttpGet r = new HttpGet(url);
        int timeout = 60;
        RequestConfig config = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).build();
        CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
        try {
            for (int tries = 4; tries > 0; --tries) {
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"requesting ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{r.getURI()})));
                {
                    CloseableHttpResponse response = client.execute((HttpUriRequest)r);
                    Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"get response with status", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)response.getStatusLine().getStatusCode())})));
                    if (response.getStatusLine().getStatusCode() <= 400) return IOUtils.toString((InputStream)response.getEntity().getContent());
                    continue;
                }
            }
            return "";
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    public String requestLinks(long PMID) {
        return this.requestPage(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"https://www.ebi.ac.uk/europepmc/webservices/rest/MED/", "/datalinks?format=json"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)PMID)})));
    }

    public void main(String[] args) {
        Logger log = LoggerFactory.getLogger(this.getClass());
        int MAX_ITEM_PER_PARTITION = 20000;
        SparkConf conf = new SparkConf();
        ArgumentApplicationParser parser = new ArgumentApplicationParser(IOUtils.toString((InputStream)this.getClass().getResourceAsStream("/eu/dnetlib/dhp/sx/bio/ebi/ebi_download_update.json")));
        parser.parseArgument(args);
        SparkSession spark = SparkSession$.MODULE$.builder().config(conf).appName(SparkEBILinksToOaf$.MODULE$.getClass().getSimpleName()).getOrCreate();
        Encoder PMEncoder = Encoders$.MODULE$.kryo(PMArticle.class);
        Encoder PMJEncoder = Encoders$.MODULE$.kryo(PMJournal.class);
        Encoder PMAEncoder = Encoders$.MODULE$.kryo(PMAuthor.class);
        String sourcePath = parser.get("sourcePath");
        log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sourcePath  -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourcePath})));
        String workingPath = parser.get("workingPath");
        log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"workingPath  -> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingPath})));
        log.info("Getting max pubmedId where the links have already requested");
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Eu_dnetlib_dhp_sx_bio_ebi_SparkDownloadEBILinks$$typecreator4$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("eu")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx.bio")), (Symbols.SymbolApi)$m.staticModule("eu.dnetlib.dhp.sx.bio.BioDBToOAF")), (Symbols.SymbolApi)$m.staticClass("eu.dnetlib.dhp.sx.bio.BioDBToOAF.EBILinkItem"), (List)Nil$.MODULE$);
            }

            public Eu_dnetlib_dhp_sx_bio_ebi_SparkDownloadEBILinks$$typecreator4$1() {
            }
        }
        Dataset links = spark.read().load(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/ebi_links_dataset"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourcePath}))).as(spark.implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Eu_dnetlib_dhp_sx_bio_ebi_SparkDownloadEBILinks$$typecreator4$1())));
        long lastPMIDRequested = ((Row)links.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(BioDBToOAF.EBILinkItem l) {
                return l.id();
            }
        }, spark.implicits().newLongEncoder()).select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.max("value")})).first()).getLong(0);
        log.info("Retrieving PMID to request links");
        Dataset pubmed = spark.read().load(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/baseline_dataset"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sourcePath}))).as(PMEncoder);
        pubmed.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(PMArticle p) {
                return new StringOps(Predef$.MODULE$.augmentString(p.getPmid())).toLong();
            }
        }, spark.implicits().newLongEncoder()).where(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"value > ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)lastPMIDRequested)}))).write().mode(SaveMode.Overwrite).save(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/id_to_request"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingPath})));
        Dataset pmidToReq = spark.read().load(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/id_to_request"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingPath}))).as(spark.implicits().newLongEncoder());
        long total = pmidToReq.count();
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Eu_dnetlib_dhp_sx_bio_ebi_SparkDownloadEBILinks$$typecreator9$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("eu")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx.bio")), (Symbols.SymbolApi)$m.staticModule("eu.dnetlib.dhp.sx.bio.BioDBToOAF")), (Symbols.SymbolApi)$m.staticClass("eu.dnetlib.dhp.sx.bio.BioDBToOAF.EBILinkItem"), (List)Nil$.MODULE$);
            }

            public Eu_dnetlib_dhp_sx_bio_ebi_SparkDownloadEBILinks$$typecreator9$1() {
            }
        }
        spark.createDataset(pmidToReq.rdd().repartition((int)(total / (long)MAX_ITEM_PER_PARTITION), (Ordering)Ordering.Long$.MODULE$).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BioDBToOAF.EBILinkItem apply(long pmid) {
                return SparkDownloadEBILinks$.MODULE$.createEBILinks(pmid);
            }
        }, ClassTag$.MODULE$.apply(BioDBToOAF.EBILinkItem.class)).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(BioDBToOAF.EBILinkItem l) {
                return l != null;
            }
        }), spark.implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Eu_dnetlib_dhp_sx_bio_ebi_SparkDownloadEBILinks$$typecreator9$1()))).write().mode(SaveMode.Overwrite).save(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/links_update"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingPath})));
        JavaUniverse $u3 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m3 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Eu_dnetlib_dhp_sx_bio_ebi_SparkDownloadEBILinks$$typecreator13$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("eu")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx.bio")), (Symbols.SymbolApi)$m.staticModule("eu.dnetlib.dhp.sx.bio.BioDBToOAF")), (Symbols.SymbolApi)$m.staticClass("eu.dnetlib.dhp.sx.bio.BioDBToOAF.EBILinkItem"), (List)Nil$.MODULE$);
            }

            public Eu_dnetlib_dhp_sx_bio_ebi_SparkDownloadEBILinks$$typecreator13$1() {
            }
        }
        Dataset updates = spark.read().load(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/links_update"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingPath}))).as(spark.implicits().newProductEncoder(((TypeTags)$u3).TypeTag().apply((Mirror)$m3, (TypeCreator)new Eu_dnetlib_dhp_sx_bio_ebi_SparkDownloadEBILinks$$typecreator13$1())));
        JavaUniverse $u4 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m4 = package$.MODULE$.universe().runtimeMirror(this.getClass().getClassLoader());
        public final class Eu_dnetlib_dhp_sx_bio_ebi_SparkDownloadEBILinks$$typecreator17$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().SingleType($u.internal().reificationSupport().thisPrefix((Symbols.SymbolApi)$m.RootClass()), (Symbols.SymbolApi)$m.staticPackage("eu")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx")), (Symbols.SymbolApi)$m.staticPackage("eu.dnetlib.dhp.sx.bio")), (Symbols.SymbolApi)$m.staticModule("eu.dnetlib.dhp.sx.bio.BioDBToOAF")), (Symbols.SymbolApi)$m.staticClass("eu.dnetlib.dhp.sx.bio.BioDBToOAF.EBILinkItem"), (List)Nil$.MODULE$);
            }

            public Eu_dnetlib_dhp_sx_bio_ebi_SparkDownloadEBILinks$$typecreator17$1() {
            }
        }
        links.union(updates).groupByKey((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final long apply(BioDBToOAF.EBILinkItem x$1) {
                return x$1.id();
            }
        }, spark.implicits().newLongEncoder()).reduceGroups((Function2)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BioDBToOAF.EBILinkItem apply(BioDBToOAF.EBILinkItem x, BioDBToOAF.EBILinkItem y) {
                BioDBToOAF.EBILinkItem eBILinkItem = x == null || x.links() == null ? y : BoxedUnit.UNIT;
                BioDBToOAF.EBILinkItem eBILinkItem2 = y == null || y.links() == null ? x : BoxedUnit.UNIT;
                return x.links().length() > y.links().length() ? x : y;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BioDBToOAF.EBILinkItem apply(Tuple2<Object, BioDBToOAF.EBILinkItem> x$2) {
                return (BioDBToOAF.EBILinkItem)x$2._2();
            }
        }, spark.implicits().newProductEncoder(((TypeTags)$u4).TypeTag().apply((Mirror)$m4, (TypeCreator)new Eu_dnetlib_dhp_sx_bio_ebi_SparkDownloadEBILinks$$typecreator17$1()))).write().mode(SaveMode.Overwrite).save(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/links_final"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{workingPath})));
    }

    private SparkDownloadEBILinks$() {
        MODULE$ = this;
    }
}

