/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.zenodo;

import eu.dnetlib.dhp.collection.ApiDescriptor;
import eu.dnetlib.dhp.collection.plugin.CollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.zenodo.ZenodoTarIterator;
import eu.dnetlib.dhp.common.aggregation.AggregatorReport;
import eu.dnetlib.dhp.common.collection.CollectorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.apache.hadoop.io.compress.CompressionInputStream;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectZenodoDumpCollectorPlugin
implements CollectorPlugin {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final FileSystem fileSystem;

    public CollectZenodoDumpCollectorPlugin(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    private void downloadItem(String name, String itemURL, String basePath, FileSystem fileSystem) {
        try {
            Path hdfsWritePath = new Path(String.format("%s/%s", basePath, name));
            FSDataOutputStream fsDataOutputStream = fileSystem.create(hdfsWritePath, true);
            HttpGet request = new HttpGet(itemURL);
            int timeout = 60;
            RequestConfig config = RequestConfig.custom().setConnectTimeout(60000).setConnectionRequestTimeout(60000).setSocketTimeout(60000).build();
            this.log.info("Downloading url {} into {}", (Object)itemURL, (Object)hdfsWritePath.getName());
            try (CloseableHttpClient client = HttpClientBuilder.create().setDefaultRequestConfig(config).build();
                 CloseableHttpResponse response = client.execute((HttpUriRequest)request);){
                int responseCode = response.getStatusLine().getStatusCode();
                this.log.info("Response code is {}", (Object)responseCode);
                if (responseCode >= 200 && responseCode < 400) {
                    IOUtils.copy((InputStream)response.getEntity().getContent(), (OutputStream)fsDataOutputStream);
                    fsDataOutputStream.flush();
                    fsDataOutputStream.hflush();
                    fsDataOutputStream.close();
                }
            }
            catch (Throwable eu) {
                throw new RuntimeException(eu);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Stream<String> collect(ApiDescriptor api, AggregatorReport report) throws CollectorException {
        String zenodoURL = api.getBaseUrl();
        return this.doStream(zenodoURL, "/tmp");
    }

    public Stream<String> doStream(String zenodoURL, String basePath) throws CollectorException {
        try {
            this.downloadItem("zenodoDump.tar.gz", zenodoURL, basePath, this.fileSystem);
            CompressionCodecFactory factory = new CompressionCodecFactory(this.fileSystem.getConf());
            Path sourcePath = new Path(basePath + "/zenodoDump.tar.gz");
            CompressionCodec codec = factory.getCodec(sourcePath);
            CompressionInputStream gzipInputStream = null;
            try {
                gzipInputStream = codec.createInputStream((InputStream)this.fileSystem.open(sourcePath));
                return this.iterateTar((InputStream)gzipInputStream);
            }
            catch (IOException e) {
                throw new CollectorException((Throwable)e);
            }
        }
        catch (Exception e) {
            throw new CollectorException((Throwable)e);
        }
    }

    private Stream<String> iterateTar(InputStream gzipInputStream) throws Exception {
        Iterable iterable = () -> new ZenodoTarIterator(gzipInputStream);
        return StreamSupport.stream(iterable.spliterator(), false);
    }
}

