/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.actionmanager.createunresolvedentities;

import eu.dnetlib.dhp.actionmanager.Constants;
import eu.dnetlib.dhp.actionmanager.createunresolvedentities.model.FOSDataModel;
import eu.dnetlib.dhp.application.ArgumentApplicationParser;
import eu.dnetlib.dhp.common.SparkSessionSupport;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkConf;
import org.apache.spark.api.java.function.MapFunction;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetFOSSparkJob
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(GetFOSSparkJob.class);

    public static void main(String[] args) throws Exception {
        String jsonConfiguration = IOUtils.toString((InputStream)GetFOSSparkJob.class.getResourceAsStream("/eu/dnetlib/dhp/actionmanager/createunresolvedentities/get_input_parameters.json"));
        ArgumentApplicationParser parser = new ArgumentApplicationParser(jsonConfiguration);
        parser.parseArgument(args);
        Boolean isSparkSessionManaged = Constants.isSparkSessionManaged(parser);
        log.info("isSparkSessionManaged: {}", (Object)isSparkSessionManaged);
        String sourcePath = parser.get("sourcePath");
        log.info("sourcePath {}", (Object)sourcePath);
        String outputPath = parser.get("outputPath");
        log.info("outputPath {}", (Object)outputPath);
        String delimiter = Optional.ofNullable(parser.get("delimiter")).orElse("\t");
        SparkConf sconf = new SparkConf();
        SparkSessionSupport.runWithSparkSession((SparkConf)sconf, (Boolean)isSparkSessionManaged, spark -> GetFOSSparkJob.getFOS(spark, sourcePath, outputPath, delimiter));
    }

    private static void getFOS(SparkSession spark, String sourcePath, String outputPath, String delimiter) {
        Dataset fosData = spark.read().format("csv").option("sep", delimiter).option("inferSchema", "true").option("header", "true").option("quotes", "\"").load(sourcePath);
        fosData.map((MapFunction & Serializable)r -> {
            FOSDataModel fosDataModel = new FOSDataModel();
            fosDataModel.setDoi(Optional.ofNullable(r.getString(0)).map(String::toLowerCase).orElse(null));
            fosDataModel.setOaid(Optional.ofNullable(r.getString(1)).map(String::toLowerCase).orElse(null));
            fosDataModel.setLevel1(r.getString(2));
            fosDataModel.setLevel2(r.getString(3));
            fosDataModel.setLevel3(r.getString(4));
            fosDataModel.setLevel4(r.getString(5));
            fosDataModel.setScoreL3(String.valueOf(r.getDouble(6)));
            fosDataModel.setScoreL4(String.valueOf(r.getDouble(7)));
            return fosDataModel;
        }, Encoders.bean(FOSDataModel.class)).write().mode(SaveMode.Overwrite).json(outputPath);
    }
}

