/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.gtr2;

import eu.dnetlib.dhp.collection.ApiDescriptor;
import eu.dnetlib.dhp.collection.plugin.CollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.gtr2.Gtr2PublicationsIterator;
import eu.dnetlib.dhp.common.aggregation.AggregatorReport;
import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.common.collection.HttpClientParams;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class Gtr2PublicationsCollectorPlugin
implements CollectorPlugin {
    private final HttpClientParams clientParams;

    public Gtr2PublicationsCollectorPlugin(HttpClientParams clientParams) {
        this.clientParams = clientParams;
    }

    @Override
    public Stream<String> collect(ApiDescriptor api, AggregatorReport report) throws CollectorException {
        String baseUrl = api.getBaseUrl();
        String startPage = (String)api.getParams().get("startPage");
        String endPage = (String)api.getParams().get("endPage");
        String fromDate = (String)api.getParams().get("fromDate");
        if (fromDate != null && !fromDate.matches("\\d{4}-\\d{2}-\\d{2}")) {
            throw new CollectorException("Invalid date (YYYY-MM-DD): " + fromDate);
        }
        Gtr2PublicationsIterator iterator = new Gtr2PublicationsIterator(baseUrl, fromDate, startPage, endPage, this.clientParams);
        Spliterator<String> spliterator = Spliterators.spliteratorUnknownSize(iterator, 16);
        return StreamSupport.stream(spliterator, false);
    }
}

