/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.omicsdi;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.collection.ApiDescriptor;
import eu.dnetlib.dhp.collection.plugin.CollectorPlugin;
import eu.dnetlib.dhp.collection.plugin.omicsdi.OmicsDIDatabase;
import eu.dnetlib.dhp.collection.plugin.omicsdi.OmicsDIDatabaseIterator;
import eu.dnetlib.dhp.common.aggregation.AggregatorReport;
import eu.dnetlib.dhp.common.collection.CollectorException;
import eu.dnetlib.dhp.common.collection.HttpClientParams;
import eu.dnetlib.dhp.common.collection.HttpConnector2;
import java.util.Arrays;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmicsDICollectorPlugin
implements CollectorPlugin {
    private static final int PAGE_SIZE_VALUE_DEFAULT = 1000;
    private static final Logger log = LoggerFactory.getLogger(OmicsDICollectorPlugin.class);
    private final HttpClientParams clientParams;

    public OmicsDICollectorPlugin(HttpClientParams clientParams) {
        this.clientParams = clientParams;
    }

    @Override
    public Stream<String> collect(ApiDescriptor api, AggregatorReport report) throws CollectorException {
        String baseUrl = api.getBaseUrl();
        int pageSize = Optional.ofNullable(api.getParams().get("pageSize")).filter(StringUtils::isNotBlank).map(s -> NumberUtils.toInt((String)s, (int)1000)).orElse(1000);
        try {
            HttpConnector2 connector = new HttpConnector2(this.clientParams);
            OmicsDIDatabase[] dbs = (OmicsDIDatabase[])new ObjectMapper().readValue(connector.getInputSource(baseUrl + "/database/all"), OmicsDIDatabase[].class);
            return Arrays.stream(dbs).map(OmicsDIDatabase::getRepository).filter(StringUtils::isNotBlank).map(repo -> new OmicsDIDatabaseIterator(baseUrl, (String)repo, pageSize, this.clientParams)).map(it -> StreamSupport.stream(Spliterators.spliteratorUnknownSize(it, 16), false)).flatMap(s -> s);
        }
        catch (Throwable e) {
            log.error("Collection failed", e);
            throw new CollectorException("Collection failed", e);
        }
    }
}

