/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.plugin.omicsdi;

import eu.dnetlib.dhp.collection.plugin.utils.JsonUtils;
import eu.dnetlib.dhp.common.collection.HttpClientParams;
import eu.dnetlib.dhp.common.collection.HttpConnector2;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.commons.lang3.math.NumberUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmicsDIDatabaseIterator
implements Iterator<String> {
    private final HttpClientParams clientParams;
    private final String baseUrl;
    private final String repo;
    private final int pageSize;
    private int currStart = -1;
    private int estimatedTotal = Integer.MAX_VALUE;
    private final Queue<String> queue = new LinkedList<String>();
    private String nextElement;
    private static final Logger log = LoggerFactory.getLogger(OmicsDIDatabaseIterator.class);

    public OmicsDIDatabaseIterator(String baseUrl, String repo, int pageSize, HttpClientParams clientParams) {
        this.baseUrl = baseUrl;
        this.repo = repo;
        this.pageSize = pageSize;
        this.clientParams = clientParams;
        this.prepareNextElement();
    }

    @Override
    public boolean hasNext() {
        return this.nextElement != null;
    }

    @Override
    public String next() {
        try {
            String string = this.nextElement;
            return string;
        }
        finally {
            this.prepareNextElement();
        }
    }

    private void prepareNextElement() {
        if (this.queue.isEmpty()) {
            if (this.currStart < 0) {
                this.queue.addAll(this.nextPage(0));
            } else if (this.currStart + this.pageSize < this.estimatedTotal) {
                this.queue.addAll(this.nextPage(this.currStart + this.pageSize));
            }
        }
        this.nextElement = this.queue.poll();
    }

    private List<String> nextPage(int start) {
        this.currStart = start;
        String url = this.databaseUrl(this.currStart);
        log.info("DOWNLOADING URL: " + url);
        HttpConnector2 connector = new HttpConnector2(this.clientParams);
        ArrayList<String> res = new ArrayList<String>();
        try {
            String json = connector.getInputSource(url);
            String xml = JsonUtils.convertToXML(json);
            Document doc = DocumentHelper.parseText((String)xml);
            this.estimatedTotal = NumberUtils.toInt((String)doc.valueOf("/recordWrap/count"));
            for (Object o : doc.selectNodes("/recordWrap/datasets")) {
                Element e = (Element)o;
                e.addElement("databaseRepo").addText(this.repo);
                res.add(e.asXML());
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return res;
    }

    private String databaseUrl(int startPage) {
        String escapedRepo = this.repo.contains(" ") ? "%22" + this.repo.replace(" ", "%20") + "%22" : this.repo;
        return String.format("%s/dataset/search?sort_field=id&query=repository:%s&size=%d&start=%d&format=json", this.baseUrl, escapedRepo, this.pageSize, startPage);
    }
}

