/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.dhp.collection.mag;

import com.fasterxml.jackson.databind.ObjectMapper;
import eu.dnetlib.dhp.collection.mag.MagUtility$;
import eu.dnetlib.dhp.collection.mag.SparkMAGtoOAF;
import eu.dnetlib.dhp.schema.oaf.Instance;
import eu.dnetlib.dhp.schema.oaf.Result;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import scala.Option;
import scala.Some;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001!4Aa\u0002\u0005\u0001'!)!\u0004\u0001C\u00017!9a\u0004\u0001b\u0001\n\u0003y\u0002B\u0002\u0017\u0001A\u0003%\u0001\u0005C\u0003.\u0001\u0011\u0005a\u0006C\u00033\u0001\u0011\u0005a\u0006C\u0003A\u0001\u0011\u0005\u0011I\u0001\bN\u0003\u001ek\u0015\r\u001d9j]\u001e$Vm\u001d;\u000b\u0005%Q\u0011aA7bO*\u00111\u0002D\u0001\u000bG>dG.Z2uS>t'BA\u0007\u000f\u0003\r!\u0007\u000e\u001d\u0006\u0003\u001fA\tq\u0001\u001a8fi2L'MC\u0001\u0012\u0003\t)Wo\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u00029A\u0011Q\u0004A\u0007\u0002\u0011\u00051Q.\u00199qKJ,\u0012\u0001\t\t\u0003C)j\u0011A\t\u0006\u0003G\u0011\n\u0001\u0002Z1uC\nLg\u000e\u001a\u0006\u0003K\u0019\nqA[1dWN|gN\u0003\u0002(Q\u0005Ia-Y:uKJDX\u000e\u001c\u0006\u0002S\u0005\u00191m\\7\n\u0005-\u0012#\u0001D(cU\u0016\u001cG/T1qa\u0016\u0014\u0018aB7baB,'\u000fI\u0001\f[\u0006\u0004\b/\u001b8h)\u0016\u001cH\u000fF\u00010!\t)\u0002'\u0003\u00022-\t!QK\\5u\u00039i\u0017\r\u001d9j]\u001el\u0015m\u001a+za\u0016D#!\u0002\u001b\u0011\u0005UrT\"\u0001\u001c\u000b\u0005]B\u0014aA1qS*\u0011\u0011HO\u0001\bUV\u0004\u0018\u000e^3s\u0015\tYD(A\u0003kk:LGOC\u0001>\u0003\ry'oZ\u0005\u0003\u007fY\u0012A\u0001V3ti\u0006Y1\r[3dWJ+7/\u001e7u+\t\u0011u\f\u0006\u00030\u00076\u0013\u0006\"\u0002#\u0007\u0001\u0004)\u0015!\u0001:\u0011\u0005\u0019[U\"A$\u000b\u0005!K\u0015aA8bM*\u0011!\nD\u0001\u0007g\u000eDW-\\1\n\u00051;%A\u0002*fgVdG\u000fC\u0003O\r\u0001\u0007q*A\u0005j]ZL7/\u001b2mKB\u0011Q\u0003U\u0005\u0003#Z\u0011qAQ8pY\u0016\fg\u000eC\u0003T\r\u0001\u0007A+\u0001\u0005usB,g*Y7f!\t)FL\u0004\u0002W5B\u0011qKF\u0007\u00021*\u0011\u0011LE\u0001\u0007yI|w\u000e\u001e \n\u0005m3\u0012A\u0002)sK\u0012,g-\u0003\u0002^=\n11\u000b\u001e:j]\u001eT!a\u0017\f\u0005\u000b\u00014!\u0019A1\u0003\u0003Q\u000b\"AY3\u0011\u0005U\u0019\u0017B\u00013\u0017\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"!\u00064\n\u0005\u001d4\"aA!os\u0002")
public class MAGMappingTest {
    private final ObjectMapper mapper = new ObjectMapper();

    public ObjectMapper mapper() {
        return this.mapper;
    }

    public void mappingTest() {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("Test").master("local[*]").getOrCreate();
        SparkMAGtoOAF s = new SparkMAGtoOAF(null, null, null);
        s.convertMAG(spark, "/Users/sandro/Downloads/", "/Users/sandro/Downloads/mag_OAF");
    }

    @Test
    public void mappingMagType() {
        this.checkResult(MagUtility$.MODULE$.createResultFromType(null, null), true, "Other literature type");
        this.checkResult(MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"BookChapter"), null), true, "Part of book or chapter of book");
        this.checkResult(MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Book"), null), true, "Book");
        this.checkResult(MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Repository"), null), true, "Other literature type");
        this.checkResult(MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Thesis"), null), true, "Thesis");
        this.checkResult(MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Conference"), null), true, "Article");
        this.checkResult(MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Journal"), null), true, "Article");
        this.checkResult(MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Dataset"), null), true, "Dataset");
        this.checkResult(MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Patent"), (Option)new Some((Object)"Patent Department of the Navy")), true, "Patent");
        this.checkResult(MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Patent"), (Option)new Some((Object)"Brevet Department of the Navy")), true, "Patent");
        this.checkResult(MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Patent"), (Option)new Some((Object)"Journal of the Navy")), true, "Journal");
        this.checkResult(MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Patent"), (Option)new Some((Object)"Proceedings of the Navy")), true, "Article");
        this.checkResult(MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Dataset"), null), true, "Dataset");
        Assertions.assertNull((Object)MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Patent"), null));
        Assertions.assertNull((Object)MagUtility$.MODULE$.createResultFromType((Option)new Some((Object)"Patent"), (Option)new Some((Object)"Some name ")));
    }

    public <T> void checkResult(Result r, boolean invisible, String typeName) {
        Assertions.assertNotNull((Object)r);
        Assertions.assertTrue((boolean)(r instanceof Object));
        Assertions.assertNotNull((Object)r.getDataInfo());
        Assertions.assertEquals((Object)BoxesRunTime.boxToBoolean((boolean)invisible), (Object)r.getDataInfo().getInvisible());
        Assertions.assertNotNull((Object)r.getInstance());
        Assertions.assertTrue((r.getInstance().size() > 0 ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)((Instance)r.getInstance().get(0)).getInstancetype());
        Assertions.assertEquals((Object)typeName, (Object)((Instance)r.getInstance().get(0)).getInstancetype().getClassname());
    }
}

